/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.altusmetrum.altoslib_14.AltosLib;

public class AltosParse {
    static NumberFormat nf_locale = AltosParse.get_nf_locale();
    static NumberFormat nf_net = AltosParse.get_nf_net();

    public static boolean isdigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static int parse_int(String string) throws ParseException {
        try {
            return (int)AltosLib.fromdec(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("error parsing int " + string, 0);
        }
    }

    public static long parse_long(String string) throws ParseException {
        try {
            return AltosLib.fromdec(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("error parsing int " + string, 0);
        }
    }

    public static int parse_hex(String string) throws ParseException {
        try {
            return AltosLib.fromhex(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("error parsing hex " + string, 0);
        }
    }

    static NumberFormat get_nf_locale() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setParseIntegerOnly(false);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    static NumberFormat get_nf_net() {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ROOT);
        numberFormat.setParseIntegerOnly(false);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    public static double parse_double_locale(String string) throws ParseException {
        try {
            return nf_locale.parse(string.trim()).doubleValue();
        }
        catch (ParseException parseException) {
            throw new ParseException("error parsing double " + string, 0);
        }
    }

    public static String format_double_locale(double d) {
        return nf_locale.format(d);
    }

    public static double parse_double_net(String string) throws ParseException {
        try {
            String string2 = string.trim();
            return nf_net.parse(string2).doubleValue();
        }
        catch (ParseException parseException) {
            throw new ParseException("error parsing double " + string, 0);
        }
    }

    public static String format_double_net(double d) {
        String string = nf_net.format(d);
        return string;
    }

    public static double parse_coord(String string) throws ParseException {
        String[] stringArray = string.split("\\D+");
        if (stringArray.length != 3) {
            throw new ParseException("error parsing coord " + string, 0);
        }
        int n = AltosParse.parse_int(stringArray[0]);
        int n2 = AltosParse.parse_int(stringArray[1]);
        int n3 = AltosParse.parse_int(stringArray[2]);
        double d = (double)n + ((double)n2 + (double)n3 / 10000.0) / 60.0;
        if (string.endsWith("S") || string.endsWith("W")) {
            d = -d;
        }
        return d;
    }

    public static String strip_suffix(String string, String string2) {
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static void word(String string, String string2) throws ParseException {
        if (!string.equals(string2)) {
            throw new ParseException("error matching '" + string + "' '" + string2 + "'", 0);
        }
    }
}

