/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedList;
import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosMap;
import org.altusmetrum.altoslib_14.AltosMapStoreListener;
import org.altusmetrum.altoslib_14.AltosPreferences;

public class AltosMapStore {
    String url;
    public File file;
    LinkedList<AltosMapStoreListener> listeners = new LinkedList();
    int status;
    public static String google_maps_api_key = null;
    static Object fetch_lock = new Object();
    static Object fetcher_lock = new Object();
    static LinkedList<AltosMapStore> waiting = new LinkedList();
    static LinkedList<AltosMapStore> running = new LinkedList();
    static HashMap<String, AltosMapStore> stores = new HashMap();

    private static File map_file(AltosLatLon altosLatLon, int n, int n2, int n3, int n4) {
        char c;
        double d = altosLatLon.lat;
        double d2 = altosLatLon.lon;
        char c2 = d < 0.0 ? (char)'S' : 'N';
        char c3 = c = d2 < 0.0 ? (char)'W' : 'E';
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        String string = String.format("%s-", AltosMap.maptype_names[n2]);
        String string2 = n2 == 0 || n2 == 2 || n2 == 3 ? "jpg" : "png";
        return new File(AltosPreferences.mapdir(), String.format("map-%c%.6f,%c%.6f-%s%d%s.%s", Character.valueOf(c2), d, Character.valueOf(c), d2, string, n, n4 == 1 ? "" : String.format("-%d", n4), string2));
    }

    private static String google_map_url(AltosLatLon altosLatLon, int n, int n2, int n3, int n4, String string) {
        return String.format("http://maps.google.com/maps/api/staticmap?center=%.6f,%.6f&zoom=%d&size=%dx%d&scale=%d&sensor=false&maptype=%s&format=%s&key=%s", altosLatLon.lat, altosLatLon.lon, n, n3, n3, n4, AltosMap.maptype_names[n2], string, google_maps_api_key);
    }

    private static String altos_map_url(AltosLatLon altosLatLon, int n, int n2, int n3, int n4, String string) {
        return String.format("https://maps.altusmetrum.org/cgi-bin/altos-map?lat=%.6f&lon=%.6f&zoom=%d", altosLatLon.lat, altosLatLon.lon, n);
    }

    private static String map_url(AltosLatLon altosLatLon, int n, int n2, int n3, int n4) {
        String string = n2 == 0 || n2 == 2 || n2 == 3 ? "jpg" : "png32";
        for (int i = 1; i < n4; i <<= 1) {
            --n;
        }
        n3 /= n4;
        if (google_maps_api_key != null) {
            return AltosMapStore.google_map_url(altosLatLon, n, n2, n3, n4, string);
        }
        return AltosMapStore.altos_map_url(altosLatLon, n, n2, n3, n4, string);
    }

    public synchronized int status() {
        return this.status;
    }

    public synchronized void add_listener(AltosMapStoreListener altosMapStoreListener) {
        if (!this.listeners.contains(altosMapStoreListener)) {
            this.listeners.add(altosMapStoreListener);
        }
        altosMapStoreListener.notify_store(this, this.status);
    }

    public synchronized void remove_listener(AltosMapStoreListener altosMapStoreListener) {
        this.listeners.remove(altosMapStoreListener);
    }

    private synchronized void notify_listeners(int n) {
        this.status = n;
        for (AltosMapStoreListener altosMapStoreListener : this.listeners) {
            altosMapStoreListener.notify_store(this, n);
        }
    }

    private int fetch_url() {
        Object object;
        URL uRL;
        try {
            uRL = new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            return 4;
        }
        byte[] byArray = null;
        URLConnection uRLConnection = null;
        int n = 3;
        int n2 = 0;
        while (n2 < 10 && n != 1) {
            try {
                int n3;
                uRLConnection = uRL.openConnection();
                object = uRLConnection.getContentType();
                int n4 = uRLConnection.getContentLength();
                if (uRLConnection instanceof HttpURLConnection) {
                    int n5 = ((HttpURLConnection)uRLConnection).getResponseCode();
                    switch (n5) {
                        case 401: 
                        case 402: 
                        case 403: {
                            return 5;
                        }
                    }
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                int n6 = 0;
                byArray = new byte[n4];
                for (n3 = 0; n3 < n4 && (n6 = ((InputStream)bufferedInputStream).read(byArray, n3, byArray.length - n3)) != -1; n3 += n6) {
                }
                ((InputStream)bufferedInputStream).close();
                n = n3 == n4 ? 1 : 3;
            }
            catch (IOException iOException) {
                n = 3;
            }
            if (n == 1) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.printf("Fetch failed, retrying %d\n", ++n2);
        }
        if (n != 1) {
            return n;
        }
        try {
            object = new FileOutputStream(this.file);
            if (byArray != null) {
                ((FileOutputStream)object).write(byArray);
            }
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 4;
        }
        catch (IOException iOException) {
            if (this.file.exists()) {
                this.file.delete();
            }
            return 4;
        }
        return 1;
    }

    static int concurrent_fetchers() {
        if (google_maps_api_key == null) {
            return 16;
        }
        return 128;
    }

    static void start_fetchers() {
        while (!waiting.isEmpty() && running.size() < AltosMapStore.concurrent_fetchers()) {
            AltosMapStore altosMapStore = waiting.remove();
            running.add(altosMapStore);
            Thread thread = altosMapStore.make_fetcher_thread();
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish_fetcher() {
        Object object = fetcher_lock;
        synchronized (object) {
            running.remove(this);
            AltosMapStore.start_fetchers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add_fetcher() {
        Object object = fetcher_lock;
        synchronized (object) {
            waiting.add(this);
            AltosMapStore.start_fetchers();
        }
    }

    private Thread make_fetcher_thread() {
        return new Thread(new fetcher());
    }

    private void fetch() {
        this.add_fetcher();
    }

    private AltosMapStore(String string, File file) {
        this.url = string;
        this.file = file;
        if (file.exists()) {
            this.status = 1;
        } else {
            this.status = 2;
            this.fetch();
        }
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AltosMapStore)) {
            return false;
        }
        AltosMapStore altosMapStore = (AltosMapStore)object;
        return this.url.equals(altosMapStore.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AltosMapStore get(AltosLatLon altosLatLon, int n, int n2, int n3, int n4) {
        AltosMapStore altosMapStore;
        String string = AltosMapStore.map_url(altosLatLon, n, n2, n3, n4);
        HashMap<String, AltosMapStore> hashMap = stores;
        synchronized (hashMap) {
            if (stores.containsKey(string)) {
                altosMapStore = stores.get(string);
            } else {
                altosMapStore = new AltosMapStore(string, AltosMapStore.map_file(altosLatLon, n, n2, n3, n4));
                stores.put(string, altosMapStore);
            }
        }
        return altosMapStore;
    }

    class fetcher
    implements Runnable {
        fetcher() {
        }

        @Override
        public void run() {
            try {
                if (AltosMapStore.this.file.exists()) {
                    AltosMapStore.this.notify_listeners(1);
                    return;
                }
                int n = AltosMapStore.this.fetch_url();
                AltosMapStore.this.notify_listeners(n);
            }
            finally {
                AltosMapStore.this.finish_fetcher();
            }
        }
    }
}

