/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.ArrayList;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosCompanion;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGPSTimeValue;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosRotation;
import org.altusmetrum.altoslib_14.AltosTimeSeries;
import org.altusmetrum.altoslib_14.AltosTimeValue;
import org.altusmetrum.altoslib_14.AltosUnits;

public class AltosFlightSeries
extends AltosDataListener {
    public ArrayList<AltosTimeSeries> series = new ArrayList();
    public double speed_filter_width = 4.0;
    public double accel_filter_width = 1.0;
    public AltosTimeSeries state_series;
    public static final String state_name = "State";
    public AltosTimeSeries accel_series;
    public boolean accel_computed;
    public static final String accel_name = "Accel";
    public AltosTimeSeries vert_accel_series;
    public static final String vert_accel_name = "Vertical Accel";
    public AltosTimeSeries tick_series;
    public static final String tick_name = "Tick";
    public AltosTimeSeries rssi_series;
    public static final String rssi_name = "RSSI";
    public AltosTimeSeries status_series;
    public static final String status_name = "Radio Status";
    public AltosTimeSeries pressure_series;
    public static final String pressure_name = "Pressure";
    public AltosTimeSeries altitude_series;
    public static final String altitude_name = "Altitude";
    public AltosTimeSeries height_series;
    public double max_height = 2.147483647E9;
    public static final String height_name = "Height";
    public AltosTimeSeries speed_series;
    public static final String speed_name = "Speed";
    public AltosTimeSeries orient_series;
    public AltosTimeSeries azimuth_series;
    public static final String orient_name = "Tilt Angle";
    public static final String azimuth_name = "Azimuth Angle";
    public AltosTimeSeries kalman_height_series;
    public AltosTimeSeries kalman_speed_series;
    public AltosTimeSeries kalman_accel_series;
    public static final String kalman_height_name = "Kalman Height";
    public static final String kalman_speed_name = "Kalman Speed";
    public static final String kalman_accel_name = "Kalman Accel";
    public AltosTimeSeries thrust_series;
    public static final String thrust_name = "Thrust";
    public AltosTimeSeries temperature_series;
    public static final String temperature_name = "Temperature";
    public AltosTimeSeries battery_voltage_series;
    public static final String battery_voltage_name = "Battery Voltage";
    public AltosTimeSeries apogee_voltage_series;
    public static final String apogee_voltage_name = "Apogee Voltage";
    public AltosTimeSeries main_voltage_series;
    public static final String main_voltage_name = "Main Voltage";
    public ArrayList<AltosGPSTimeValue> gps_series;
    public AltosTimeSeries sats_in_view;
    public AltosTimeSeries sats_in_soln;
    public AltosTimeSeries gps_altitude;
    public AltosTimeSeries gps_height;
    public AltosTimeSeries gps_ground_speed;
    public AltosTimeSeries gps_ascent_rate;
    public AltosTimeSeries gps_course;
    public AltosTimeSeries gps_speed;
    public AltosTimeSeries gps_pdop;
    public AltosTimeSeries gps_vdop;
    public AltosTimeSeries gps_hdop;
    public static final String sats_in_view_name = "Satellites in view";
    public static final String sats_in_soln_name = "Satellites in solution";
    public static final String gps_altitude_name = "GPS Altitude";
    public static final String gps_height_name = "GPS Height";
    public static final String gps_ground_speed_name = "GPS Ground Speed";
    public static final String gps_ascent_rate_name = "GPS Ascent Rate";
    public static final String gps_course_name = "GPS Course";
    public static final String gps_speed_name = "GPS Speed";
    public static final String gps_pdop_name = "GPS Dilution of Precision";
    public static final String gps_vdop_name = "GPS Vertical Dilution of Precision";
    public static final String gps_hdop_name = "GPS Horizontal Dilution of Precision";
    public static final String accel_along_name = "Accel Along";
    public static final String accel_across_name = "Accel Across";
    public static final String accel_through_name = "Accel Through";
    public AltosTimeSeries accel_along;
    public AltosTimeSeries accel_across;
    public AltosTimeSeries accel_through;
    public static final String gyro_roll_name = "Roll Rate";
    public static final String gyro_pitch_name = "Pitch Rate";
    public static final String gyro_yaw_name = "Yaw Rate";
    public AltosTimeSeries gyro_roll;
    public AltosTimeSeries gyro_pitch;
    public AltosTimeSeries gyro_yaw;
    public static final String mag_along_name = "Magnetic Field Along";
    public static final String mag_across_name = "Magnetic Field Across";
    public static final String mag_through_name = "Magnetic Field Through";
    public static final String mag_total_name = "Magnetic Field Strength";
    public static final String compass_name = "Compass";
    public AltosTimeSeries mag_along;
    public AltosTimeSeries mag_across;
    public AltosTimeSeries mag_through;
    public AltosTimeSeries mag_total;
    public AltosTimeSeries compass;
    private double accel_ground_along = 2.147483647E9;
    private double accel_ground_across = 2.147483647E9;
    private double accel_ground_through = 2.147483647E9;
    private double ground_time;
    public static final String pyro_voltage_name = "Pyro Voltage";
    public AltosTimeSeries pyro_voltage;
    private static String[] igniter_voltage_names;
    public AltosTimeSeries[] igniter_voltage;
    public static final String pyro_fired_name = "Pyro Channel State";
    public AltosTimeSeries pyro_fired_series;
    int last_pyro_mask;
    public static final String motor_pressure_name = "Motor Pressure";
    public AltosTimeSeries motor_pressure_series;

    public int[] indices() {
        int[] nArray = new int[this.series.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        this.step_indices(nArray);
        return nArray;
    }

    private double time(int n, int n2) {
        AltosTimeSeries altosTimeSeries = this.series.get(n);
        if (n2 < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n2 < altosTimeSeries.values.size()) {
            return altosTimeSeries.values.get((int)n2).time;
        }
        return Double.POSITIVE_INFINITY;
    }

    public boolean step_indices(int[] nArray) {
        double d;
        int n;
        double d2 = this.time(0, nArray[0] + 1);
        for (n = 1; n < nArray.length; ++n) {
            d = this.time(n, nArray[n] + 1);
            if (!(d < d2)) continue;
            d2 = d;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return false;
        }
        for (n = 0; n < nArray.length; ++n) {
            d = this.time(n, nArray[n] + 1);
            if (!(d <= d2)) continue;
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
        }
        return true;
    }

    public double time(int[] nArray) {
        double d = this.time(0, nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            double d2 = this.time(i, nArray[i]);
            if (!(d2 >= d)) continue;
            d = d2;
        }
        return d;
    }

    public double value(String string, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            AltosTimeSeries altosTimeSeries = this.series.get(i);
            if (!altosTimeSeries.label.equals(string)) continue;
            int n = nArray[i];
            if (n < 0) {
                n = 0;
            }
            if (n >= altosTimeSeries.values.size()) {
                n = altosTimeSeries.values.size() - 1;
            }
            return altosTimeSeries.values.get((int)n).value;
        }
        return 2.147483647E9;
    }

    public double value(String string, double d) {
        for (AltosTimeSeries altosTimeSeries : this.series) {
            if (!altosTimeSeries.label.equals(string)) continue;
            return altosTimeSeries.value(d);
        }
        return 2.147483647E9;
    }

    public double value_before(String string, double d) {
        for (AltosTimeSeries altosTimeSeries : this.series) {
            if (!altosTimeSeries.label.equals(string)) continue;
            return altosTimeSeries.value_before(d);
        }
        return 2.147483647E9;
    }

    public double value_after(String string, double d) {
        for (AltosTimeSeries altosTimeSeries : this.series) {
            if (!altosTimeSeries.label.equals(string)) continue;
            return altosTimeSeries.value_after(d);
        }
        return 2.147483647E9;
    }

    public AltosTimeSeries make_series(String string, AltosUnits altosUnits) {
        return new AltosTimeSeries(string, altosUnits);
    }

    public void add_series(AltosTimeSeries altosTimeSeries) {
        for (int i = 0; i < this.series.size(); ++i) {
            if (altosTimeSeries.compareTo(this.series.get(i)) >= 0) continue;
            this.series.add(i, altosTimeSeries);
            return;
        }
        this.series.add(altosTimeSeries);
    }

    public AltosTimeSeries add_series(String string, AltosUnits altosUnits) {
        AltosTimeSeries altosTimeSeries = this.make_series(string, altosUnits);
        this.add_series(altosTimeSeries);
        return altosTimeSeries;
    }

    public void remove_series(AltosTimeSeries altosTimeSeries) {
        this.series.remove(altosTimeSeries);
    }

    public boolean has_series(String string) {
        for (AltosTimeSeries altosTimeSeries : this.series) {
            if (!altosTimeSeries.label.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void set_state(int n) {
        if (n != 2 && n != Integer.MAX_VALUE && n != 10) {
            if (this.state_series == null) {
                this.state_series = this.add_series(state_name, AltosConvert.state_name);
            }
            if (this.state() != n) {
                this.state_series.add(this.time(), n);
            }
        }
        super.set_state(n);
    }

    @Override
    public void set_acceleration(double d) {
        if (d == 2.147483647E9) {
            return;
        }
        if (this.accel_series == null) {
            this.accel_series = this.add_series(accel_name, AltosConvert.accel);
        }
        this.accel_series.add(this.time(), d);
        this.accel_computed = false;
    }

    private AltosTimeSeries compute_accel() {
        AltosTimeSeries altosTimeSeries = null;
        if (this.speed_series != null) {
            AltosTimeSeries altosTimeSeries2;
            if (this.accel_filter_width > 0.0) {
                altosTimeSeries2 = this.make_series(speed_name, AltosConvert.speed);
                this.speed_series.filter(altosTimeSeries2, this.accel_filter_width);
            } else {
                altosTimeSeries2 = this.speed_series;
            }
            altosTimeSeries = this.make_series(accel_name, AltosConvert.accel);
            altosTimeSeries2.differentiate(altosTimeSeries);
        }
        return altosTimeSeries;
    }

    public void set_filter(double d, double d2) {
        Object object;
        Object object2;
        this.speed_filter_width = d;
        this.accel_filter_width = d2;
        AltosTimeSeries altosTimeSeries = this.compute_speed();
        if (altosTimeSeries != null) {
            this.speed_series.erase_values();
            object2 = altosTimeSeries.iterator();
            while (object2.hasNext()) {
                object = (AltosTimeValue)object2.next();
                this.speed_series.add((AltosTimeValue)object);
            }
        }
        if (this.accel_computed && (object2 = this.compute_accel()) != null) {
            this.accel_series.erase_values();
            object = ((AltosTimeSeries)object2).iterator();
            while (object.hasNext()) {
                AltosTimeValue altosTimeValue = (AltosTimeValue)object.next();
                this.accel_series.add(altosTimeValue);
            }
        }
    }

    @Override
    public void set_received_time(long l) {
    }

    @Override
    public void set_tick(int n) {
        super.set_tick(n);
        if (this.tick_series == null) {
            this.tick_series = this.add_series(tick_name, null);
        }
        this.tick_series.add(this.time(), n);
    }

    @Override
    public void set_rssi(int n, int n2) {
        if (this.rssi_series == null) {
            this.rssi_series = this.add_series(rssi_name, null);
            this.status_series = this.add_series(status_name, null);
        }
        this.rssi_series.add(this.time(), n);
        this.status_series.add(this.time(), n2);
    }

    public void set_min_pressure(double d) {
        double d2 = this.cal_data().ground_altitude;
        if (d2 != 2.147483647E9) {
            this.max_height = AltosConvert.pressure_to_altitude(d) - d2;
        }
    }

    @Override
    public void set_pressure(double d) {
        if (d == 2.147483647E9) {
            return;
        }
        if (this.pressure_series == null) {
            this.pressure_series = this.add_series(pressure_name, AltosConvert.pressure);
        }
        this.pressure_series.add(this.time(), d);
        if (this.altitude_series == null) {
            this.altitude_series = this.add_series(altitude_name, AltosConvert.height);
        }
        if (this.cal_data().ground_pressure == 2.147483647E9) {
            this.cal_data().set_ground_pressure(d);
        }
        double d2 = AltosConvert.pressure_to_altitude(d);
        this.altitude_series.add(this.time(), d2);
    }

    private void compute_height() {
        double d;
        if (this.height_series == null) {
            d = this.cal_data().ground_altitude;
            if (d != 2.147483647E9 && this.altitude_series != null) {
                this.height_series = this.add_series(height_name, AltosConvert.height);
                for (AltosTimeValue altosTimeValue : this.altitude_series) {
                    this.height_series.add(altosTimeValue.time, altosTimeValue.value - d);
                }
            } else if (this.speed_series != null) {
                this.height_series = this.add_series(height_name, AltosConvert.height);
                this.speed_series.integrate(this.height_series);
            }
        }
        if (this.gps_height == null && this.cal_data().gps_pad != null && this.cal_data().gps_pad.alt != 2.147483647E9 && this.gps_altitude != null) {
            d = this.cal_data().gps_pad.alt;
            this.gps_height = this.add_series(gps_height_name, AltosConvert.height);
            for (AltosTimeValue altosTimeValue : this.gps_altitude) {
                this.gps_height.add(altosTimeValue.time, altosTimeValue.value - d);
            }
        }
    }

    private AltosTimeSeries compute_speed() {
        Object object;
        AltosTimeSeries altosTimeSeries = null;
        AltosTimeSeries altosTimeSeries2 = null;
        AltosTimeSeries altosTimeSeries3 = null;
        if (this.altitude_series != null) {
            if (this.speed_filter_width > 0.0) {
                object = this.make_series(speed_name, AltosConvert.height);
                this.altitude_series.filter((AltosTimeSeries)object, this.speed_filter_width);
            } else {
                object = this.altitude_series;
            }
            altosTimeSeries2 = this.make_series(speed_name, AltosConvert.speed);
            ((AltosTimeSeries)object).differentiate(altosTimeSeries2);
        }
        if (this.accel_series != null && !this.accel_computed) {
            Object object22;
            if (this.orient_series != null) {
                this.vert_accel_series = this.add_series(vert_accel_name, AltosConvert.accel);
                for (Object object22 : this.accel_series) {
                    double d = this.orient_series.value(((AltosTimeValue)object22).time);
                    double d2 = ((AltosTimeValue)object22).value + 9.80665;
                    double d3 = d2 * Math.cos(AltosConvert.degrees_to_radians(d)) - 9.80665;
                    this.vert_accel_series.add(((AltosTimeValue)object22).time, d3);
                }
            }
            object = this.make_series(speed_name, AltosConvert.speed);
            if (this.vert_accel_series != null) {
                this.vert_accel_series.integrate((AltosTimeSeries)object);
            } else {
                this.accel_series.integrate((AltosTimeSeries)object);
            }
            object22 = this.make_series(speed_name, AltosConvert.speed);
            ((AltosTimeSeries)object).clip((AltosTimeSeries)object22, 0.0, Double.POSITIVE_INFINITY);
            altosTimeSeries3 = this.make_series(speed_name, AltosConvert.speed);
            ((AltosTimeSeries)object22).filter(altosTimeSeries3, 0.1);
        }
        if (altosTimeSeries2 != null && altosTimeSeries3 != null) {
            double d = 2.147483647E9;
            if (this.state_series != null) {
                for (AltosTimeValue altosTimeValue : this.state_series) {
                    if (!(altosTimeValue.value >= 6.0)) continue;
                    d = altosTimeValue.time;
                    break;
                }
            }
            if (d == 2.147483647E9) {
                altosTimeSeries = altosTimeSeries2;
            } else {
                altosTimeSeries = this.make_series(speed_name, AltosConvert.speed);
                for (AltosTimeValue altosTimeValue : altosTimeSeries3) {
                    if (!(altosTimeValue.time <= d)) continue;
                    altosTimeSeries.add(altosTimeValue);
                }
                for (AltosTimeValue altosTimeValue : altosTimeSeries2) {
                    if (!(altosTimeValue.time > d)) continue;
                    altosTimeSeries.add(altosTimeValue);
                }
            }
        } else if (altosTimeSeries2 != null) {
            altosTimeSeries = altosTimeSeries2;
        } else if (altosTimeSeries3 != null) {
            altosTimeSeries = altosTimeSeries3;
        }
        return altosTimeSeries;
    }

    private void compute_orient() {
        if (this.orient_series != null) {
            return;
        }
        if (this.accel_ground_across == 2.147483647E9) {
            return;
        }
        AltosCalData altosCalData = this.cal_data();
        if (altosCalData.pad_orientation == Integer.MAX_VALUE) {
            return;
        }
        if (altosCalData.accel_zero_across == 2.147483647E9) {
            return;
        }
        if (altosCalData.gyro_zero_roll == 2.147483647E9) {
            return;
        }
        AltosRotation altosRotation = new AltosRotation(this.accel_ground_across, this.accel_ground_through, this.accel_ground_along, altosCalData.pad_orientation);
        double d = this.ground_time;
        this.orient_series = this.add_series(orient_name, AltosConvert.orient);
        this.orient_series.add(this.ground_time, altosRotation.tilt());
        this.azimuth_series = this.add_series(azimuth_name, AltosConvert.orient);
        this.azimuth_series.add(this.ground_time, altosRotation.azimuth());
        for (AltosTimeValue altosTimeValue : this.gyro_roll) {
            double d2 = altosTimeValue.time;
            double d3 = d2 - d;
            if (d3 > 0.0) {
                double d4 = AltosConvert.degrees_to_radians(altosTimeValue.value) * d3;
                double d5 = AltosConvert.degrees_to_radians(this.gyro_pitch.value(d2)) * d3;
                double d6 = AltosConvert.degrees_to_radians(this.gyro_yaw.value(d2)) * d3;
                altosRotation.rotate(d5, d6, d4);
                this.orient_series.add(d2, altosRotation.tilt());
                this.azimuth_series.add(d2, altosRotation.azimuth());
            }
            d = d2;
        }
    }

    @Override
    public void set_kalman(double d, double d2, double d3) {
        if (this.kalman_height_series == null) {
            this.kalman_height_series = this.add_series(kalman_height_name, AltosConvert.height);
            this.kalman_speed_series = this.add_series(kalman_speed_name, AltosConvert.speed);
            this.kalman_accel_series = this.add_series(kalman_accel_name, AltosConvert.accel);
        }
        this.kalman_height_series.add(this.time(), d);
        this.kalman_speed_series.add(this.time(), d2);
        this.kalman_accel_series.add(this.time(), d3);
    }

    @Override
    public void set_thrust(double d) {
        if (this.thrust_series == null) {
            this.thrust_series = this.add_series(thrust_name, AltosConvert.force);
        }
        this.thrust_series.add(this.time(), d);
    }

    @Override
    public void set_temperature(double d) {
        if (this.temperature_series == null) {
            this.temperature_series = this.add_series(temperature_name, AltosConvert.temperature);
        }
        this.temperature_series.add(this.time(), d);
    }

    @Override
    public void set_battery_voltage(double d) {
        if (d == 2.147483647E9) {
            return;
        }
        if (this.battery_voltage_series == null) {
            this.battery_voltage_series = this.add_series(battery_voltage_name, AltosConvert.voltage);
        }
        this.battery_voltage_series.add(this.time(), d);
    }

    @Override
    public void set_apogee_voltage(double d) {
        if (d == 2.147483647E9) {
            return;
        }
        if (this.apogee_voltage_series == null) {
            this.apogee_voltage_series = this.add_series(apogee_voltage_name, AltosConvert.voltage);
        }
        this.apogee_voltage_series.add(this.time(), d);
    }

    @Override
    public void set_main_voltage(double d) {
        if (d == 2.147483647E9) {
            return;
        }
        if (this.main_voltage_series == null) {
            this.main_voltage_series = this.add_series(main_voltage_name, AltosConvert.voltage);
        }
        this.main_voltage_series.add(this.time(), d);
    }

    public AltosGPS gps_before(double d) {
        AltosGPSTimeValue altosGPSTimeValue = null;
        for (AltosGPSTimeValue altosGPSTimeValue2 : this.gps_series) {
            if (altosGPSTimeValue == null) {
                altosGPSTimeValue = altosGPSTimeValue2;
                continue;
            }
            if (altosGPSTimeValue2.time <= d) {
                if (!(altosGPSTimeValue.time <= d) || !(altosGPSTimeValue2.time > altosGPSTimeValue.time)) continue;
                altosGPSTimeValue = altosGPSTimeValue2;
                continue;
            }
            if (!(altosGPSTimeValue.time > d) || !(altosGPSTimeValue2.time < altosGPSTimeValue.time)) continue;
            altosGPSTimeValue = altosGPSTimeValue2;
        }
        if (altosGPSTimeValue != null) {
            return altosGPSTimeValue.gps;
        }
        return null;
    }

    @Override
    public void set_gps(AltosGPS altosGPS, boolean bl, boolean bl2) {
        super.set_gps(altosGPS, bl, bl2);
        AltosCalData altosCalData = this.cal_data();
        if (this.gps_series == null) {
            this.gps_series = new ArrayList();
        }
        this.gps_series.add(new AltosGPSTimeValue(this.time(), altosGPS));
        if (bl) {
            if (this.sats_in_soln == null) {
                this.sats_in_soln = this.add_series(sats_in_soln_name, null);
            }
            this.sats_in_soln.add(this.time(), altosGPS.nsat);
            if (altosGPS.pdop != 2.147483647E9) {
                if (this.gps_pdop == null) {
                    this.gps_pdop = this.add_series(gps_pdop_name, null);
                }
                this.gps_pdop.add(this.time(), altosGPS.pdop);
            }
            if (altosGPS.hdop != 2.147483647E9) {
                if (this.gps_hdop == null) {
                    this.gps_hdop = this.add_series(gps_hdop_name, null);
                }
                this.gps_hdop.add(this.time(), altosGPS.hdop);
            }
            if (altosGPS.vdop != 2.147483647E9) {
                if (this.gps_vdop == null) {
                    this.gps_vdop = this.add_series(gps_vdop_name, null);
                }
                this.gps_vdop.add(this.time(), altosGPS.vdop);
            }
            if (altosGPS.locked) {
                if (altosGPS.alt != 2.147483647E9) {
                    if (this.gps_altitude == null) {
                        this.gps_altitude = this.add_series(gps_altitude_name, AltosConvert.height);
                    }
                    this.gps_altitude.add(this.time(), altosGPS.alt);
                }
                if (altosGPS.ground_speed != 2.147483647E9) {
                    if (this.gps_ground_speed == null) {
                        this.gps_ground_speed = this.add_series(gps_ground_speed_name, AltosConvert.speed);
                    }
                    this.gps_ground_speed.add(this.time(), altosGPS.ground_speed);
                }
                if (altosGPS.climb_rate != 2.147483647E9) {
                    if (this.gps_ascent_rate == null) {
                        this.gps_ascent_rate = this.add_series(gps_ascent_rate_name, AltosConvert.speed);
                    }
                    this.gps_ascent_rate.add(this.time(), altosGPS.climb_rate);
                }
                if (altosGPS.course != Integer.MAX_VALUE) {
                    if (this.gps_course == null) {
                        this.gps_course = this.add_series(gps_course_name, null);
                    }
                    this.gps_course.add(this.time(), altosGPS.course);
                }
                if (altosGPS.ground_speed != 2.147483647E9 && altosGPS.climb_rate != 2.147483647E9) {
                    if (this.gps_speed == null) {
                        this.gps_speed = this.add_series(gps_speed_name, null);
                    }
                    this.gps_speed.add(this.time(), Math.sqrt(altosGPS.ground_speed * altosGPS.ground_speed + altosGPS.climb_rate * altosGPS.climb_rate));
                }
            }
        }
        if (bl2 && altosGPS.cc_gps_sat != null) {
            if (this.sats_in_view == null) {
                this.sats_in_view = this.add_series(sats_in_view_name, null);
            }
            this.sats_in_view.add(this.time(), altosGPS.cc_gps_sat.length);
        }
    }

    @Override
    public void set_accel(double d, double d2, double d3) {
        if (this.accel_along == null) {
            this.accel_along = this.add_series(accel_along_name, AltosConvert.accel);
            this.accel_across = this.add_series(accel_across_name, AltosConvert.accel);
            this.accel_through = this.add_series(accel_through_name, AltosConvert.accel);
        }
        this.accel_along.add(this.time(), d);
        this.accel_across.add(this.time(), d2);
        this.accel_through.add(this.time(), d3);
    }

    @Override
    public void set_accel_ground(double d, double d2, double d3) {
        this.accel_ground_along = d;
        this.accel_ground_across = d2;
        this.accel_ground_through = d3;
        this.ground_time = this.time();
    }

    @Override
    public void set_gyro(double d, double d2, double d3) {
        if (this.gyro_roll == null) {
            this.gyro_roll = this.add_series(gyro_roll_name, AltosConvert.rotation_rate);
            this.gyro_pitch = this.add_series(gyro_pitch_name, AltosConvert.rotation_rate);
            this.gyro_yaw = this.add_series(gyro_yaw_name, AltosConvert.rotation_rate);
        }
        this.gyro_roll.add(this.time(), d);
        this.gyro_pitch.add(this.time(), d2);
        this.gyro_yaw.add(this.time(), d3);
    }

    @Override
    public void set_mag(double d, double d2, double d3) {
        if (this.mag_along == null) {
            this.mag_along = this.add_series(mag_along_name, AltosConvert.magnetic_field);
            this.mag_across = this.add_series(mag_across_name, AltosConvert.magnetic_field);
            this.mag_through = this.add_series(mag_through_name, AltosConvert.magnetic_field);
            this.mag_total = this.add_series(mag_total_name, AltosConvert.magnetic_field);
            this.compass = this.add_series(compass_name, AltosConvert.orient);
        }
        this.mag_along.add(this.time(), d);
        this.mag_across.add(this.time(), d2);
        this.mag_through.add(this.time(), d3);
        this.mag_total.add(this.time(), Math.sqrt(d * d + d2 * d2 + d3 * d3));
        this.compass.add(this.time(), Math.atan2(d2, d3) * 180.0 / Math.PI);
    }

    @Override
    public void set_orient(double d) {
        if (this.orient_series == null) {
            this.orient_series = this.add_series(orient_name, AltosConvert.orient);
        }
        this.orient_series.add(this.time(), d);
    }

    @Override
    public void set_pyro_voltage(double d) {
        if (this.pyro_voltage == null) {
            this.pyro_voltage = this.add_series(pyro_voltage_name, AltosConvert.voltage);
        }
        this.pyro_voltage.add(this.time(), d);
    }

    public String igniter_voltage_name(int n) {
        if (igniter_voltage_names == null || igniter_voltage_names.length <= n) {
            int n2;
            String[] stringArray = new String[n + 1];
            if (igniter_voltage_names != null) {
                for (n2 = 0; n2 < igniter_voltage_names.length; ++n2) {
                    stringArray[n2] = igniter_voltage_names[n2];
                }
            }
            while (n2 < n + 1) {
                stringArray[n2] = AltosLib.igniter_name(n2);
                ++n2;
            }
            igniter_voltage_names = stringArray;
        }
        return igniter_voltage_names[n];
    }

    @Override
    public void set_igniter_voltage(double[] dArray) {
        int n = dArray.length;
        if (this.igniter_voltage == null || this.igniter_voltage.length <= n) {
            int n2;
            AltosTimeSeries[] altosTimeSeriesArray = new AltosTimeSeries[n];
            if (this.igniter_voltage != null) {
                for (n2 = 0; n2 < this.igniter_voltage.length; ++n2) {
                    altosTimeSeriesArray[n2] = this.igniter_voltage[n2];
                }
            }
            while (n2 < n) {
                altosTimeSeriesArray[n2] = this.add_series(this.igniter_voltage_name(n2), AltosConvert.voltage);
                ++n2;
            }
            this.igniter_voltage = altosTimeSeriesArray;
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.igniter_voltage[i].add(this.time(), dArray[i]);
        }
    }

    @Override
    public void set_pyro_fired(int n) {
        if (this.pyro_fired_series == null) {
            this.pyro_fired_series = this.add_series(pyro_fired_name, AltosConvert.pyro_name);
        }
        for (int i = 0; i < 32; ++i) {
            if ((this.last_pyro_mask & 1 << i) != 0 || (n & 1 << i) == 0) continue;
            this.pyro_fired_series.add(this.time(), i);
        }
        this.last_pyro_mask = n;
    }

    @Override
    public void set_companion(AltosCompanion altosCompanion) {
    }

    @Override
    public void set_motor_pressure(double d) {
        if (this.motor_pressure_series == null) {
            this.motor_pressure_series = this.add_series(motor_pressure_name, AltosConvert.pressure);
        }
        this.motor_pressure_series.add(this.time(), d);
    }

    @Override
    public void finish() {
        this.compute_orient();
        if (this.speed_series == null) {
            this.speed_series = this.compute_speed();
            if (this.speed_series != null) {
                this.add_series(this.speed_series);
            }
        }
        if (this.accel_series == null) {
            this.accel_series = this.compute_accel();
            if (this.accel_series != null) {
                this.add_series(this.accel_series);
                this.accel_computed = true;
            }
        }
        this.compute_height();
    }

    public AltosTimeSeries[] series() {
        this.finish();
        return this.series.toArray(new AltosTimeSeries[0]);
    }

    public AltosFlightSeries(AltosCalData altosCalData) {
        super(altosCalData);
    }
}

