/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.altusmetrum.altoslib_14.AltosDebug;
import org.altusmetrum.altoslib_14.AltosFlashListener;
import org.altusmetrum.altoslib_14.AltosHexfile;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosProgrammer;
import org.altusmetrum.altoslib_14.AltosRomconfig;
import org.altusmetrum.altoslib_14.AltosUsbId;

public class AltosFlash
extends AltosProgrammer {
    File file;
    FileInputStream input;
    AltosHexfile image;
    AltosLink link;
    AltosDebug debug;
    AltosRomconfig rom_config;
    boolean aborted;
    AltosFlashListener listener;
    static final byte MOV_direct_data = 117;
    static final byte MOV_DPTR_data16 = -112;
    static final byte MOV_A_data = 116;
    static final byte MOVX_atDPTR_A = -16;
    static final byte MOVX_A_atDPTR = -32;
    static final byte INC_DPTR = -93;
    static final byte TRAP = -91;
    static final byte JB = 32;
    static final byte MOV_A_direct = -27;
    static final byte MOV_direct1_direct2 = -123;
    static final byte MOV_direct_A = -11;
    static final byte MOV_R0_data = 120;
    static final byte MOV_R1_data = 121;
    static final byte MOV_R2_data = 122;
    static final byte MOV_R3_data = 123;
    static final byte MOV_R4_data = 124;
    static final byte MOV_R5_data = 125;
    static final byte MOV_R6_data = 126;
    static final byte MOV_R7_data = 127;
    static final byte DJNZ_R0_rel = -40;
    static final byte DJNZ_R1_rel = -39;
    static final byte DJNZ_R2_rel = -38;
    static final byte DJNZ_R3_rel = -37;
    static final byte DJNZ_R4_rel = -36;
    static final byte DJNZ_R5_rel = -35;
    static final byte DJNZ_R6_rel = -34;
    static final byte DJNZ_R7_rel = -33;
    static final byte P1DIR = -2;
    static final byte P1 = -112;
    static final byte FWT = -85;
    static final byte FADDRL = -84;
    static final byte FADDRH = -83;
    static final byte FCTL = -82;
    static final byte FCTL_BUSY = -128;
    static final byte FCTL_BUSY_BIT = 7;
    static final byte FCTL_SWBSY = 64;
    static final byte FCTL_SWBSY_BIT = 6;
    static final byte FCTL_CONTRD = 16;
    static final byte FCTL_WRITE = 2;
    static final byte FCTL_ERASE = 1;
    static final byte FWDATA = -81;
    static final byte ACC = -32;
    static final int FLASH_ADDR_HIGH = 8;
    static final int FLASH_ADDR_LOW = 11;
    static final int RAM_ADDR_HIGH = 13;
    static final int RAM_ADDR_LOW = 14;
    static final int FLASH_WORDS_HIGH = 16;
    static final int FLASH_WORDS_LOW = 18;
    static final int FLASH_TIMING = 21;
    static final int SLEEP = -66;
    static final int SLEEP_USB_EN = -128;
    static final int SLEEP_XOSC_STB = 64;
    static final int SLEEP_HFRC_STB = 32;
    static final int SLEEP_RST_MASK = 24;
    static final int SLEEP_RST_POWERON = 0;
    static final int SLEEP_RST_EXTERNAL = 16;
    static final int SLEEP_RST_WATCHDOG = 8;
    static final int SLEEP_OSC_PD = 4;
    static final int SLEEP_MODE_MASK = 3;
    static final int SLEEP_MODE_PM0 = 0;
    static final int SLEEP_MODE_PM1 = 1;
    static final int SLEEP_MODE_PM2 = 2;
    static final int SLEEP_MODE_PM3 = 3;
    static final byte CLKCON = -58;
    static final byte CLKCON_OSC32K = -128;
    static final byte CLKCON_OSC = 64;
    static final byte CLKCON_TICKSPD = 56;
    static final byte CLKCON_CLKSPD = 7;
    static final byte[] flash_page_proto = new byte[]{117, -2, 2, 117, -112, -1, 117, -83, 0, 117, -84, 0, -112, 0, 0, 127, 0, 126, 0, 117, -85, 32, 117, -82, 1, -27, -82, 32, -25, -5, 117, -112, -3, 117, -82, 2, 125, 2, -32, -93, -11, -81, -35, -6, -27, -82, 32, -26, -5, -34, -15, -33, -17, 117, -2, 0, 117, -112, -1, -91};
    static byte[] set_clkcon_fast = new byte[]{117, -58, 0};
    static byte[] get_sleep = new byte[]{-27, -66};

    public byte[] make_flash_page(int n, int n2, int n3) {
        int n4;
        int n5 = n >> 1;
        int n6 = n3 + 1 >> 1;
        byte[] byArray = new byte[flash_page_proto.length];
        for (n4 = 0; n4 < byArray.length; ++n4) {
            byArray[n4] = flash_page_proto[n4];
        }
        byArray[8] = (byte)(n5 >> 8);
        byArray[11] = (byte)n5;
        byArray[13] = (byte)(n2 >> 8);
        byArray[14] = (byte)n2;
        n4 = (byte)n6;
        byte by = (byte)(n6 >> 8);
        if (n4 != 0) {
            by = (byte)(by + 1);
        }
        byArray[16] = by;
        byArray[18] = n4;
        return byArray;
    }

    public void clock_init() throws IOException, InterruptedException {
        if (this.debug != null) {
            this.debug.debug_instr(set_clkcon_fast);
            for (int i = 0; i < 20; ++i) {
                Thread.sleep(1L);
                byte by = this.debug.debug_instr(get_sleep);
                if ((by & 0x40) == 0) continue;
                return;
            }
            throw new IOException("Failed to initialize target clock");
        }
    }

    void action(String string, int n) {
        if (this.listener != null && !this.aborted) {
            this.listener.position(string, n);
        }
    }

    void action(int n, int n2) {
        int n3 = 100 * n / n2;
        this.action(String.format("%d/%d (%d%%)", n, n2, n3), n3);
    }

    void altos_run(int n) throws IOException, InterruptedException {
        this.debug.set_pc(n);
        int n2 = this.debug.get_pc();
        if (n != n2) {
            throw new IOException("Failed to set target program counter");
        }
        this.debug.resume();
        for (int i = 0; i < 20; ++i) {
            byte by = this.debug.read_status();
            if ((by & 0x20) == 0) continue;
            return;
        }
        throw new IOException("Failed to execute program on target");
    }

    @Override
    public void flash() {
        try {
            if (!this.check_rom_config()) {
                throw new IOException("Invalid rom config settings");
            }
            if (this.image.address + (long)this.image.data.length > 32768L) {
                throw new IOException(String.format("Flash image too long %d", this.image.address + (long)this.image.data.length));
            }
            if ((this.image.address & 0x3FFL) != 0L) {
                throw new IOException(String.format("Flash image must start on page boundary (is 0x%x)", this.image.address));
            }
            int n = 61440;
            int n2 = 62464;
            this.rom_config.write(this.image);
            this.clock_init();
            int n3 = this.image.data.length;
            int n4 = (int)this.image.address;
            int n5 = 0;
            this.action("start", 0);
            this.action(0, this.image.data.length);
            while (n3 > 0 && !this.aborted) {
                int n6 = n3;
                if (n6 > 1024) {
                    n6 = 1024;
                }
                if (this.debug != null) {
                    this.debug.write_memory(n, this.image.data, n5, n6);
                    byte[] byArray = this.make_flash_page(n4, n, n6);
                    this.debug.write_memory(n2, byArray);
                    this.altos_run(n2);
                    byte[] byArray2 = this.debug.read_memory(n4, n6);
                    for (int i = 0; i < n6; ++i) {
                        if (byArray2[i] == this.image.data[n5 + i]) continue;
                        throw new IOException(String.format("Flash write failed at 0x%x (%02x != %02x)", this.image.address + (long)n5 + (long)i, byArray2[i], this.image.data[n5 + i]));
                    }
                } else {
                    Thread.sleep(100L);
                }
                n4 += n6;
                n5 += n6;
                this.action(this.image.data.length - (n3 -= n6), this.image.data.length);
            }
            if (!this.aborted) {
                this.action("done", 100);
                if (this.debug != null) {
                    this.debug.set_pc((int)this.image.address);
                    this.debug.resume();
                }
            }
            if (this.debug != null) {
                this.debug.close();
            }
        }
        catch (IOException iOException) {
            this.action(iOException.getMessage(), -1);
            this.abort();
        }
        catch (InterruptedException interruptedException) {
            this.abort();
        }
    }

    @Override
    public void close() {
        if (this.debug != null) {
            this.debug.close();
        }
    }

    @Override
    public synchronized void abort() {
        this.aborted = true;
        this.close();
    }

    public boolean check_rom_config() throws InterruptedException {
        if (this.debug == null) {
            return true;
        }
        if (this.rom_config == null) {
            this.rom_config = this.debug.romconfig();
        }
        return this.rom_config != null && this.rom_config.valid();
    }

    @Override
    public void set_romconfig(AltosRomconfig altosRomconfig) {
        this.rom_config = altosRomconfig;
    }

    @Override
    public AltosRomconfig target_romconfig(AltosUsbId altosUsbId, String string) throws InterruptedException {
        if (!this.check_rom_config()) {
            return null;
        }
        if (this.rom_config.usb_id == null) {
            this.rom_config.usb_id = altosUsbId;
        }
        if (this.rom_config.usb_product == null) {
            this.rom_config.usb_product = string;
        }
        return this.rom_config;
    }

    @Override
    public AltosRomconfig image_romconfig() {
        return new AltosRomconfig(this.image);
    }

    public AltosFlash(File file, AltosLink altosLink, AltosFlashListener altosFlashListener) throws IOException, FileNotFoundException, InterruptedException {
        this.file = file;
        this.link = altosLink;
        this.listener = altosFlashListener;
        if (altosLink != null) {
            this.debug = new AltosDebug(altosLink);
        }
        this.input = new FileInputStream(file);
        this.image = new AltosHexfile(this.input);
        boolean bl = true;
        if (this.debug != null) {
            try {
                bl = this.debug.check_connection();
            }
            catch (IOException iOException) {
                this.debug.close();
                throw iOException;
            }
            catch (InterruptedException interruptedException) {
                this.debug.close();
                throw interruptedException;
            }
        }
        if (!bl) {
            this.debug.close();
            throw new IOException("Debug port not connected");
        }
    }
}

