/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.List;
import org.altusmetrum.altoslib_14.AltosAccel;
import org.altusmetrum.altoslib_14.AltosDistance;
import org.altusmetrum.altoslib_14.AltosForce;
import org.altusmetrum.altoslib_14.AltosGauss;
import org.altusmetrum.altoslib_14.AltosHeight;
import org.altusmetrum.altoslib_14.AltosLatitude;
import org.altusmetrum.altoslib_14.AltosLongitude;
import org.altusmetrum.altoslib_14.AltosOrient;
import org.altusmetrum.altoslib_14.AltosPressure;
import org.altusmetrum.altoslib_14.AltosPyroName;
import org.altusmetrum.altoslib_14.AltosRotationRate;
import org.altusmetrum.altoslib_14.AltosSpeed;
import org.altusmetrum.altoslib_14.AltosStateName;
import org.altusmetrum.altoslib_14.AltosTemperature;
import org.altusmetrum.altoslib_14.AltosUnits;
import org.altusmetrum.altoslib_14.AltosVoltage;

public class AltosConvert {
    public static final double gravity = 9.80665;
    private static final double GRAVITATIONAL_ACCELERATION = -9.80665;
    private static final double AIR_GAS_CONSTANT = 287.053;
    private static final double NUMBER_OF_LAYERS = 7.0;
    private static final double MAXIMUM_ALTITUDE = 84852.0;
    private static final double MINIMUM_PRESSURE = 0.3734;
    private static final double LAYER0_BASE_TEMPERATURE = 288.15;
    private static final double LAYER0_BASE_PRESSURE = 101325.0;
    private static final double[] lapse_rate = new double[]{-0.0065, 0.0, 0.001, 0.0028, 0.0, -0.0028, -0.002};
    private static final int[] base_altitude = new int[]{0, 11000, 20000, 32000, 47000, 51000, 71000};
    public static boolean imperial_units = false;
    public static AltosDistance distance = new AltosDistance();
    public static AltosHeight height = new AltosHeight();
    public static AltosPressure pressure = new AltosPressure();
    public static AltosForce force = new AltosForce();
    public static AltosSpeed speed = new AltosSpeed();
    public static AltosAccel accel = new AltosAccel();
    public static AltosTemperature temperature = new AltosTemperature();
    public static AltosOrient orient = new AltosOrient();
    public static AltosVoltage voltage = new AltosVoltage();
    public static AltosLatitude latitude = new AltosLatitude();
    public static AltosLongitude longitude = new AltosLongitude();
    public static AltosRotationRate rotation_rate = new AltosRotationRate();
    public static AltosStateName state_name = new AltosStateName();
    public static AltosPyroName pyro_name = new AltosPyroName();
    public static AltosUnits magnetic_field = new AltosGauss();
    public static final int BEARING_LONG = 0;
    public static final int BEARING_SHORT = 1;
    public static final int BEARING_VOICE = 2;

    public static double altitude_to_pressure(double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = 288.15;
        double d7 = 101325.0;
        if (d > 84852.0) {
            return 0.0;
        }
        int n = 0;
        while ((double)n < 6.0 && d > (double)base_altitude[n + 1]) {
            d5 = base_altitude[n + 1] - base_altitude[n];
            if (lapse_rate[n] == 0.0) {
                d4 = -9.80665 * d5 / 287.053 / d6;
                d7 *= Math.exp(d4);
            } else {
                d3 = lapse_rate[n] * d5 / d6 + 1.0;
                d4 = -9.80665 / (287.053 * lapse_rate[n]);
                d7 *= Math.pow(d3, d4);
            }
            d6 += d5 * lapse_rate[n];
            ++n;
        }
        d5 = d - (double)base_altitude[n];
        if (lapse_rate[n] == 0.0) {
            d4 = -9.80665 * d5 / 287.053 / d6;
            d2 = d7 * Math.exp(d4);
        } else {
            d3 = lapse_rate[n] * d5 / d6 + 1.0;
            d4 = -9.80665 / (287.053 * lapse_rate[n]);
            d2 = d7 * Math.pow(d3, d4);
        }
        return d2;
    }

    public static double pressure_to_altitude(double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = 288.15;
        double d8 = 101325.0;
        if (d < 0.0) {
            return -1.0;
        }
        if (d < 0.3734) {
            return 84852.0;
        }
        int n = -1;
        do {
            d6 = d8;
            d5 = d7;
            int n2 = base_altitude[++n + 1] - base_altitude[n];
            if (lapse_rate[n] == 0.0) {
                d4 = -9.80665 * (double)n2 / 287.053 / d5;
                d8 *= Math.exp(d4);
            } else {
                d3 = lapse_rate[n] * (double)n2 / d5 + 1.0;
                d4 = -9.80665 / (287.053 * lapse_rate[n]);
                d8 *= Math.pow(d3, d4);
            }
            d7 += (double)n2 * lapse_rate[n];
        } while ((double)n < 6.0 && d < d8);
        if (lapse_rate[n] == 0.0) {
            double d9 = -29.271259808395325 * d5;
            d2 = (double)base_altitude[n] + d9 * Math.log(d / d6);
        } else {
            d3 = d / d6;
            d4 = 287.053 * lapse_rate[n] / -9.80665;
            double d10 = d5 / lapse_rate[n];
            d2 = (double)base_altitude[n] + d10 * (Math.pow(d3, d4) - 1.0);
        }
        return d2;
    }

    public static double degrees_to_radians(double d) {
        if (d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return d * (Math.PI / 180);
    }

    public static double radians_to_degrees(double d) {
        if (d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return d * 57.29577951308232;
    }

    public static double cc_battery_to_voltage(double d) {
        return d / 32767.0 * 5.0;
    }

    public static double cc_igniter_to_voltage(double d) {
        return d / 32767.0 * 15.0;
    }

    public static double barometer_to_pressure(double d) {
        return (d / 16.0 / 2047.0 + 0.095) / 0.009 * 1000.0;
    }

    static double thermometer_to_temperature(double d) {
        return (d - 19791.268) / 32728.0 * 1.25 / 0.00247;
    }

    static double mega_adc(int n) {
        return (double)n / 4095.0;
    }

    public static double mega_battery_voltage(int n) {
        if (n != Integer.MAX_VALUE) {
            return 3.3 * AltosConvert.mega_adc(n) * 15.6 / 10.0;
        }
        return 2.147483647E9;
    }

    static double mega_pyro_voltage(int n) {
        if (n != Integer.MAX_VALUE) {
            return 3.3 * AltosConvert.mega_adc(n) * 127.0 / 27.0;
        }
        return 2.147483647E9;
    }

    static double tele_mini_3_adc(int n) {
        return (double)n / 4095.0;
    }

    public static double tele_mini_3_battery_voltage(int n) {
        if (n != Integer.MAX_VALUE) {
            return 3.3 * AltosConvert.tele_mini_3_adc(n) * 15.6 / 10.0;
        }
        return 2.147483647E9;
    }

    static double tele_mini_3_pyro_voltage(int n) {
        if (n != Integer.MAX_VALUE) {
            return 3.3 * AltosConvert.tele_mini_3_adc(n) * 127.0 / 27.0;
        }
        return 2.147483647E9;
    }

    static double tele_mini_2_voltage(int n) {
        double d = 3.3;
        return (double)n / 32767.0 * d * 127.0 / 27.0;
    }

    static double tele_gps_1_voltage(int n) {
        double d = 3.3;
        return (double)n / 32767.0 * d * 15.6 / 10.0;
    }

    static double tele_gps_2_voltage(int n) {
        double d = 3.3;
        return (double)n / 4095.0 * d * 15.6 / 10.0;
    }

    static double tele_bt_3_battery(int n) {
        if (n == Integer.MAX_VALUE) {
            return 2.147483647E9;
        }
        return 3.3 * AltosConvert.mega_adc(n) * 15.1 / 10.0;
    }

    static double easy_timer_voltage(int n) {
        return 3.3 * AltosConvert.mega_adc(n) * 127.0 / 27.0;
    }

    static double easy_mini_2_adc(double d) {
        return d / 4095.0;
    }

    static double easy_mini_1_adc(double d) {
        return d / 32767.0;
    }

    static double easy_mini_1_voltage(int n, int n2) {
        double d = 3.3;
        double d2 = 0.0;
        if (n2 < 1000) {
            d = 3.0;
        }
        if (n2 < 1665) {
            d2 = 0.15;
        }
        return AltosConvert.easy_mini_1_adc(n) * d * 127.0 / 27.0 + d2;
    }

    static double easy_mini_2_voltage(int n) {
        double d = 3.3;
        return AltosConvert.easy_mini_2_adc(n) * d * 127.0 / 27.0;
    }

    static double motor_pressure(double d) {
        double d2 = 0.5;
        double d3 = 4.5;
        double d4 = AltosConvert.psi_to_pa(1600.0);
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        return (d - d2) / (d3 - d2) * d4;
    }

    static double easy_motor_2_motor_pressure(int n, double d) {
        double d2 = 3.3;
        double d3 = AltosConvert.easy_mini_2_adc(d) * d2 * 15.6 / 10.0;
        double d4 = AltosConvert.easy_mini_2_adc(n) * d2 * 15.6 / 10.0;
        return AltosConvert.motor_pressure(d4) - AltosConvert.motor_pressure(d3);
    }

    public static double radio_to_frequency(int n, int n2, int n3, int n4) {
        double d;
        if (n > 0) {
            d = (double)n / 1000.0;
        } else {
            if (n2 <= 0) {
                n2 = n3;
            }
            d = 434.55 * (double)n2 / (double)n3;
            d = Math.floor(20.0 * d + 0.5) / 20.0;
        }
        return d + (double)n4 * 0.1;
    }

    public static int radio_frequency_to_setting(double d, int n) {
        double d2 = d / 434.55 * (double)n;
        return (int)Math.floor(d2 + 0.5);
    }

    public static int radio_frequency_to_channel(double d) {
        int n = (int)Math.floor((d - 434.55) / 0.1 + 0.5);
        if (n < 0) {
            n = 0;
        }
        if (n > 9) {
            n = 9;
        }
        return n;
    }

    public static double radio_channel_to_frequency(int n) {
        return 434.55 + (double)n * 0.1;
    }

    public static int telem_to_rssi(int n) {
        return n / 2 - 74;
    }

    public static int[] ParseHex(String string) {
        String[] stringArray = string.split("\\s+");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i], 16);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return nArray;
    }

    public static double meters_to_feet(double d) {
        return d * 3.2808398950131235;
    }

    public static double feet_to_meters(double d) {
        return d * 12.0 * 2.54 / 100.0;
    }

    public static double meters_to_miles(double d) {
        return AltosConvert.meters_to_feet(d) / 5280.0;
    }

    public static double miles_to_meters(double d) {
        return AltosConvert.feet_to_meters(d * 5280.0);
    }

    public static double meters_to_mph(double d) {
        return AltosConvert.meters_to_miles(d) * 3600.0;
    }

    public static double mph_to_meters(double d) {
        return AltosConvert.miles_to_meters(d) / 3600.0;
    }

    public static double mps_to_fps(double d) {
        return AltosConvert.meters_to_miles(d) * 5280.0;
    }

    public static double fps_to_mps(double d) {
        return AltosConvert.miles_to_meters(d) / 5280.0;
    }

    public static double meters_to_mach(double d) {
        return d / 343.0;
    }

    public static double meters_to_g(double d) {
        return d / 9.80665;
    }

    public static double c_to_f(double d) {
        return d * 9.0 / 5.0 + 32.0;
    }

    public static double f_to_c(double d) {
        return (d - 32.0) * 5.0 / 9.0;
    }

    public static double psi_to_pa(double d) {
        return d * 6894.76;
    }

    public static double pa_to_psi(double d) {
        return d / 6894.76;
    }

    public static double n_to_lb(double d) {
        return d * 0.22480894;
    }

    public static double lb_to_n(double d) {
        return d / 0.22480894;
    }

    public static double acceleration_from_sensor(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        if (d == 2.147483647E9) {
            return 2.147483647E9;
        }
        if (d2 == 2.147483647E9 || d3 == 2.147483647E9) {
            return 2.147483647E9;
        }
        if (d4 == 2.147483647E9) {
            d4 = d2;
        }
        if ((d6 = (d5 = (d2 - d3) / 2.0) / 9.80665) == 0.0) {
            return 2.147483647E9;
        }
        return (d - d4) / d6;
    }

    public static String show_gs(String string, double d) {
        d = AltosConvert.meters_to_g(d);
        string = string.concat(" g");
        return String.format(string, d);
    }

    public static String say_gs(double d) {
        return String.format("%6.0 gees", AltosConvert.meters_to_g(d));
    }

    public static int checksum(int[] nArray, int n, int n2) {
        int n3 = 90;
        for (int i = 0; i < n2; ++i) {
            n3 += nArray[i + n];
        }
        return n3 & 0xFF;
    }

    public static int checksum(List<Byte> list, int n, int n2) {
        int n3 = 90;
        for (int i = 0; i < n2; ++i) {
            n3 += list.get(i + n).byteValue();
        }
        return n3 & 0xFF;
    }

    public static double beep_value_to_freq(int n) {
        if (n == 0) {
            return 4000.0;
        }
        return 375000.0 / (double)n;
    }

    public static int beep_freq_to_value(double d) {
        if (d == 0.0) {
            return 94;
        }
        return (int)Math.floor(375000.0 / d + 0.5);
    }

    public static String bearing_to_words(int n, double d) {
        String[][] stringArrayArray = new String[][]{{"North", "North North East", "North East", "East North East", "East", "East South East", "South East", "South South East", "South", "South South West", "South West", "West South West", "West", "West North West", "North West", "North North West"}, {"N", "NNE", "NE", "ENE", "E", "ESE", "SE", "SSE", "S", "SSW", "SW", "WSW", "W", "WNW", "NW", "NNW"}, {"north", "nor nor east", "north east", "east nor east", "east", "east sow east", "south east", "sow sow east", "south", "sow sow west", "south west", "west sow west", "west", "west nor west", "north west", "nor nor west "}};
        return stringArrayArray[n][(int)((d / 90.0 * 8.0 + 1.0) / 2.0) % 16];
    }
}

