/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.micropeak;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.micropeak.MicroData;
import org.altusmetrum.micropeak.MicroFile;

public class MicroSave
extends JFileChooser {
    JFrame frame;
    MicroData data;

    public static void save(File file, MicroData microData) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        microData.save(fileOutputStream);
        fileOutputStream.close();
    }

    public boolean runDialog() {
        int n;
        while ((n = this.showSaveDialog(this.frame)) == 0) {
            File file = this.getSelectedFile();
            if (file == null) continue;
            if (!file.getName().contains(".")) {
                String string = file.getPath();
                file = new File(string.concat(".mpd"));
            }
            String string = file.getName();
            if (file.exists()) {
                if (file.isDirectory()) {
                    JOptionPane.showMessageDialog(this.frame, String.format("\"%s\" is a directory", string), "Directory", 0);
                    continue;
                }
                int n2 = JOptionPane.showConfirmDialog(this.frame, String.format("\"%s\" already exists. Overwrite?", string), "Overwrite file?", 0);
                if (n2 != 0) continue;
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(this.frame, String.format("\"%s\" is not writable", string), "File not writable", 0);
                    continue;
                }
            }
            try {
                MicroSave.save(file, this.data);
                AltosUIPreferences.set_last_logdir(file.getParentFile());
                this.data.set_name(string);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this.frame, fileNotFoundException.getMessage(), "Cannot create file", 0);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        return false;
    }

    public MicroSave(JFrame jFrame, MicroData microData) {
        this.frame = jFrame;
        this.data = microData;
        this.setDialogTitle("Save MicroPeak Data File");
        this.setFileFilter(new FileNameExtensionFilter("MicroPeak data file", "mpd"));
        this.setCurrentDirectory(AltosUIPreferences.last_logdir());
        this.setSelectedFile(MicroFile.make(microData));
    }
}

