/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.micropeak;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.micropeak.MicroData;

public class MicroExport
extends JFileChooser {
    JFrame frame;
    MicroData data;

    public static void export(File file, MicroData microData) throws FileNotFoundException, IOException {
        FileWriter fileWriter = new FileWriter(file);
        microData.export(fileWriter);
        fileWriter.close();
    }

    public boolean runDialog() {
        this.setSelectedFile(new File(AltosLib.replace_extension(this.data.name, ".csv")));
        int n;
        while ((n = this.showSaveDialog(this.frame)) == 0) {
            File file = this.getSelectedFile();
            if (file == null) continue;
            if (!file.getName().contains(".")) {
                String string = file.getPath();
                file = new File(string.concat(".csv"));
            }
            String string = file.getName();
            if (file.exists()) {
                if (file.isDirectory()) {
                    JOptionPane.showMessageDialog(this.frame, String.format("\"%s\" is a directory", string), "Directory", 0);
                    continue;
                }
                int n2 = JOptionPane.showConfirmDialog(this.frame, String.format("\"%s\" already exists. Overwrite?", string), "Overwrite file?", 0);
                if (n2 != 0) continue;
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(this.frame, String.format("\"%s\" is not writable", string), "File not writable", 0);
                    continue;
                }
            }
            try {
                MicroExport.export(file, this.data);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this.frame, fileNotFoundException.getMessage(), "Cannot create file", 0);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        return false;
    }

    public MicroExport(JFrame jFrame, MicroData microData) {
        this.frame = jFrame;
        this.data = microData;
        this.setDialogTitle("Export MicroPeak Data File");
        this.setFileFilter(new FileNameExtensionFilter("MicroPeak CSV file", "csv"));
        this.setCurrentDirectory(AltosUIPreferences.logdir());
    }
}

