/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.micropeak;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosFlightStats;
import org.altusmetrum.altoslib_14.AltosTimeValue;
import org.altusmetrum.altosuilib_14.AltosUIFlightSeries;

public class MicroData {
    public int ground_pressure;
    public int min_pressure;
    AltosUIFlightSeries flight_series;
    AltosFlightStats flight_stats;
    AltosCalData cal_data;
    private double time_step;
    private ArrayList<Integer> bytes;
    public int nsamples;
    public int log_id;
    String name;
    String unique_id;
    public static final int LOG_ID_MICROPEAK = 0;
    public static final int LOG_ID_MICROKITE = 1;
    public static final int LOG_ID_MICROPEAK2 = 2;
    public static final double CLOCK_MP1 = 0.096;
    public static final double CLOCK_MP2 = 0.1;
    private static final int POLY = 33800;
    int file_crc;
    public boolean crc_valid;

    private int getc(InputStream inputStream) throws IOException, FileEndedException {
        int n = inputStream.read();
        if (n == -1) {
            throw new FileEndedException();
        }
        this.bytes.add(n);
        return n;
    }

    private int get_nonwhite(InputStream inputStream) throws IOException, FileEndedException {
        int n;
        while (Character.isWhitespace(n = this.getc(inputStream))) {
        }
        return n;
    }

    private int get_hexc(InputStream inputStream) throws IOException, FileEndedException, NonHexcharException {
        int n = this.get_nonwhite(inputStream);
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (97 <= n && n <= 102) {
            return n - 97 + 10;
        }
        if (65 <= n && n <= 70) {
            return n - 65 + 10;
        }
        throw new NonHexcharException();
    }

    private int log_crc(int n, int n2) {
        for (int i = 0; i < 8; ++i) {
            n = (n & 1 ^ n2 & 1) != 0 ? n >> 1 ^ 0x8408 : (n >>= 1);
            n2 >>= 1;
        }
        return n & 0xFFFF;
    }

    private int get_hex(InputStream inputStream) throws IOException, FileEndedException, NonHexcharException {
        int n = this.get_hexc(inputStream);
        int n2 = this.get_hexc(inputStream);
        int n3 = (n << 4) + n2;
        this.file_crc = this.log_crc(this.file_crc, n3);
        return n3;
    }

    private boolean find_header(InputStream inputStream) throws IOException, FileEndedException {
        while (this.get_nonwhite(inputStream) != 77 || this.get_nonwhite(inputStream) != 80) {
        }
        return true;
    }

    private int get_32(InputStream inputStream) throws IOException, FileEndedException, NonHexcharException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += this.get_hex(inputStream) << i * 8;
        }
        return n;
    }

    private int get_16(InputStream inputStream) throws IOException, FileEndedException, NonHexcharException {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            n += this.get_hex(inputStream) << i * 8;
        }
        return n;
    }

    private String get_line(InputStream inputStream) throws IOException, FileEndedException, NonHexcharException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isWhitespace(n = inputStream.read())) {
        }
        do {
            stringBuffer.append((char)n);
        } while (!Character.isWhitespace(n = inputStream.read()));
        return new String(stringBuffer);
    }

    private int swap16(int n) {
        return n << 8 & 0xFF00 | n >> 8 & 0xFF;
    }

    int mix_in(int n, int n2) {
        return n - (n & 0xFFFF) + n2;
    }

    boolean closer(int n, int n2, int n3) {
        return Math.abs(n - n2) < Math.abs(n - n3);
    }

    public double altitude(double d) {
        if (this.flight_series.altitude_series == null) {
            return 0.0;
        }
        return this.flight_series.altitude_series.value(d);
    }

    public double altitude(int n) {
        return this.altitude(this.time(n));
    }

    public String name() {
        return this.name;
    }

    public double pressure(int n) {
        if (this.flight_series.pressure_series == null) {
            return 0.0;
        }
        return this.flight_series.pressure_series.value(this.time(n));
    }

    public double height(double d) {
        if (this.flight_series.height_series == null) {
            return 0.0;
        }
        return this.flight_series.height_series.value(d);
    }

    public double height(int n) {
        return this.height(this.time(n));
    }

    public int length() {
        if (this.flight_series.pressure_series == null) {
            return 0;
        }
        return this.flight_series.pressure_series.size();
    }

    public double apogee_pressure() {
        return this.min_pressure;
    }

    public double apogee_altitude() {
        return AltosConvert.pressure_to_altitude(this.apogee_pressure());
    }

    public double apogee_height() {
        return this.apogee_altitude() - this.cal_data.ground_altitude;
    }

    public double speed(double d) {
        if (this.flight_series.speed_series == null) {
            return 0.0;
        }
        return this.flight_series.speed_series.value(d);
    }

    public double speed(int n) {
        return this.speed(this.time(n));
    }

    public double acceleration(double d) {
        if (this.flight_series.accel_series == null) {
            return 0.0;
        }
        return this.flight_series.accel_series.value(d);
    }

    public double acceleration(int n) {
        return this.acceleration(this.time(n));
    }

    public double time(int n) {
        return (double)n * this.time_step;
    }

    public void save(OutputStream outputStream) throws IOException {
        for (int n : this.bytes) {
            outputStream.write(n);
        }
        outputStream.write(10);
    }

    public void export(Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.printf("  Time, Press(Pa), Height(m), Height(f), Speed(m/s), Speed(mph), Speed(mach), Accel(m/s\u00b2), Accel(ft/s\u00b2),  Accel(g)\n", new Object[0]);
        for (AltosTimeValue altosTimeValue : this.flight_series.pressure_series) {
            double d = this.height(altosTimeValue.time);
            double d2 = this.speed(altosTimeValue.time);
            double d3 = this.acceleration(altosTimeValue.time);
            printWriter.printf("%6.3f,%10.0f,%10.1f,%10.1f,%11.2f,%11.2f,%12.4f,%12.2f,%13.2f,%10.4f\n", altosTimeValue.time, altosTimeValue.value, d, AltosConvert.meters_to_feet(d), d2, AltosConvert.meters_to_mph(d2), AltosConvert.meters_to_mach(d2), d3, AltosConvert.meters_to_feet(d3), AltosConvert.meters_to_g(d3));
        }
    }

    public void set_name(String string) {
        this.name = string;
    }

    public MicroData() {
        this.ground_pressure = 101000;
        this.min_pressure = 101000;
        this.cal_data = new AltosCalData();
        this.flight_series = new AltosUIFlightSeries(this.cal_data);
    }

    public MicroData(InputStream inputStream, String string) throws IOException, InterruptedException, NonHexcharException, FileEndedException {
        this.name = string;
        this.bytes = new ArrayList();
        this.cal_data = new AltosCalData();
        this.flight_series = new AltosUIFlightSeries(this.cal_data);
        if (!this.find_header(inputStream)) {
            throw new IOException("No MicroPeak data header found");
        }
        try {
            int n;
            int n2;
            int n3;
            this.file_crc = 65535;
            this.ground_pressure = this.get_32(inputStream);
            this.min_pressure = this.get_32(inputStream);
            this.nsamples = this.get_16(inputStream);
            this.log_id = this.nsamples >> 12;
            this.nsamples &= 0xFFF;
            if (this.log_id == 2) {
                n3 = this.get_16(inputStream);
                this.nsamples |= n3 << 12;
            }
            this.cal_data.set_ground_pressure(this.ground_pressure);
            switch (this.log_id) {
                case 0: {
                    this.time_step = 0.192;
                    break;
                }
                case 1: {
                    this.time_step = 19.2;
                    break;
                }
                case 2: {
                    this.time_step = 0.1;
                    break;
                }
                default: {
                    throw new IOException(String.format("Unknown device type: %d", this.log_id));
                }
            }
            this.cal_data.set_ticks_per_sec(1.0 / this.time_step);
            this.cal_data.set_tick(0);
            this.cal_data.set_boost_tick();
            n3 = this.ground_pressure;
            this.cal_data.set_tick(0);
            this.flight_series.set_time(this.cal_data.time());
            this.flight_series.set_pressure(n3);
            for (n2 = 0; n2 < this.nsamples; ++n2) {
                n = this.get_16(inputStream);
                int n4 = this.mix_in(n3, n);
                int n5 = this.mix_in(n3 + 65536, n);
                int n6 = this.mix_in(n3 - 65536, n);
                n3 = this.closer(n3, n4, n5) ? (this.closer(n3, n4, n6) ? n4 : n6) : (this.closer(n3, n5, n6) ? n5 : n6);
                this.cal_data.set_tick(n2 + 1);
                this.flight_series.set_time(this.cal_data.time());
                this.flight_series.set_pressure(n3);
            }
            n2 = this.swap16(~this.file_crc & 0xFFFF);
            n = this.get_16(inputStream);
            boolean bl = this.crc_valid = n == n2;
            if (this.log_id == 2) {
                this.unique_id = this.get_line(inputStream);
            }
            this.flight_series.finish();
            this.flight_series.set_time(0.0);
            this.flight_series.set_state(3);
            if (this.flight_series.speed_series != null && this.flight_series.speed_series.max() != null) {
                this.flight_series.set_time(this.flight_series.speed_series.max().time);
                this.flight_series.set_state(5);
            }
            this.flight_series.set_time(this.flight_series.height_series.max().time);
            this.flight_series.set_state(6);
            this.cal_data.set_tick(this.nsamples);
            this.flight_series.set_time(this.cal_data.time());
            this.flight_series.set_state(8);
            this.flight_series.set_min_pressure(this.min_pressure);
            this.flight_series.finish();
            this.flight_stats = new AltosFlightStats(this.flight_series);
        }
        catch (FileEndedException fileEndedException) {
            throw new IOException("File Ended Unexpectedly");
        }
    }

    public class InvalidCrcException
    extends Exception {
    }

    public class NonHexcharException
    extends Exception {
    }

    public class FileEndedException
    extends Exception {
    }
}

