/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.InputStream;
import org.altusmetrum.altoslib_14.AltosJson;
import org.altusmetrum.altoslib_14.JsonArray;
import org.altusmetrum.altoslib_14.JsonHash;
import org.altusmetrum.altoslib_14.JsonLexer;

class JsonParse {
    JsonLexer lexer;

    void parse_error(String string, Object ... objectArray) {
        throw new IllegalArgumentException(String.format("line %d: JSON parse error %s\n", this.lexer.line, String.format(string, objectArray)));
    }

    JsonHash hash() {
        JsonHash jsonHash = new JsonHash();
        this.lexer.next();
        block4: while (true) {
            if (this.lexer.token().token == 5) {
                this.lexer.next();
                return jsonHash;
            }
            String string = this.lexer.expect((int)0).sval;
            this.lexer.expect(9);
            AltosJson altosJson = this.value();
            jsonHash.put(string, altosJson);
            switch (this.lexer.token().token) {
                case 8: {
                    this.lexer.next();
                    continue block4;
                }
                case 5: {
                    this.lexer.next();
                    return jsonHash;
                }
            }
            break;
        }
        this.parse_error("got %s expect \",\" or \"}\"", this.lexer.token().token_name());
        return null;
    }

    JsonArray array() {
        JsonArray jsonArray = new JsonArray();
        this.lexer.next();
        int n = 0;
        while (true) {
            if (this.lexer.token().token == 7) {
                this.lexer.next();
                return jsonArray;
            }
            AltosJson altosJson = this.value();
            jsonArray.put(n, altosJson);
            switch (this.lexer.token().token) {
                case 8: {
                    this.lexer.next();
                    break;
                }
                case 7: {
                    this.lexer.next();
                    return jsonArray;
                }
                default: {
                    this.parse_error("got %s expect \",\" or \"]\"", this.lexer.token().token_name());
                    return null;
                }
            }
            ++n;
        }
    }

    AltosJson value() {
        switch (this.lexer.token().token) {
            case 4: {
                return new AltosJson(this.hash());
            }
            case 6: {
                return new AltosJson(this.array());
            }
            case 1: {
                double d = this.lexer.token().dval;
                this.lexer.next();
                return new AltosJson(d);
            }
            case 2: {
                long l = this.lexer.token().lval;
                this.lexer.next();
                return new AltosJson(l);
            }
            case 0: {
                String string = this.lexer.token().sval;
                this.lexer.next();
                return new AltosJson(string);
            }
            case 3: {
                boolean bl = this.lexer.token().bval;
                this.lexer.next();
                return new AltosJson(bl);
            }
        }
        this.parse_error("Unexpected token \"%s\"", this.lexer.token().token_name());
        return null;
    }

    AltosJson parse() {
        this.lexer.next();
        return this.value();
    }

    JsonParse(String string) {
        this.lexer = new JsonLexer(string);
    }

    JsonParse(InputStream inputStream) {
        this.lexer = new JsonLexer(inputStream);
    }
}

