/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosTelemetryStandard;

public class AltosTelemetryMegaSensor
extends AltosTelemetryStandard {
    int imu_type;

    int orient() {
        return this.int8(5);
    }

    int accel() {
        return this.int16(6);
    }

    int pres() {
        return this.int32(8);
    }

    int temp() {
        return this.int16(12);
    }

    int accel_x() {
        return this.int16(14);
    }

    int accel_y() {
        return this.int16(16);
    }

    int accel_z() {
        return this.int16(18);
    }

    int gyro_x() {
        return this.int16(20);
    }

    int gyro_y() {
        return this.int16(22);
    }

    int gyro_z() {
        return this.int16(24);
    }

    int mag_x() {
        return this.int16(26);
    }

    int mag_z() {
        return this.int16(28);
    }

    int mag_y() {
        return this.int16(30);
    }

    private int accel_across(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.accel_x();
            }
            case 4: {
                return -this.accel_y();
            }
            case 2: {
                return -this.accel_y();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int accel_along(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.accel_y();
            }
            case 2: 
            case 4: {
                return this.accel_x();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int accel_through(int n) {
        return this.accel_z();
    }

    private int gyro_roll(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.gyro_y();
            }
            case 2: 
            case 4: {
                return this.gyro_x();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int gyro_pitch(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.gyro_x();
            }
            case 4: {
                return -this.gyro_y();
            }
            case 2: {
                return this.gyro_y();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int gyro_yaw(int n) {
        return this.gyro_z();
    }

    public static int mag_across_axis(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: {
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int mag_across(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.mag_x();
            }
            case 2: 
            case 4: {
                return -this.mag_y();
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int mag_along_axis(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return 1;
            }
            case 2: 
            case 4: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int mag_along(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.mag_y();
            }
            case 2: 
            case 4: {
                return this.mag_x();
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int mag_through_axis(int n) {
        return 2;
    }

    private int mag_through(int n) {
        return this.mag_z();
    }

    public AltosTelemetryMegaSensor(int[] nArray, int n) throws AltosCRCException {
        super(nArray);
        switch (n) {
            case 0: 
            case 1: {
                if (this.serial() < 3000) {
                    n = 0;
                    break;
                }
                n = 1;
                break;
            }
        }
        this.imu_type = n;
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        super.provide_data(altosDataListener);
        AltosCalData altosCalData = altosDataListener.cal_data();
        altosDataListener.set_acceleration(altosCalData.acceleration(this.accel()));
        altosDataListener.set_pressure(this.pres());
        altosDataListener.set_temperature((double)this.temp() / 100.0);
        altosDataListener.set_orient(this.orient());
        altosCalData.set_imu_type(this.imu_type);
        if (altosCalData.accel_zero_along == 2.147483647E9) {
            altosCalData.set_accel_zero(0.0, 0.0, 0.0);
        }
        if (altosCalData.gyro_zero_roll == 2.147483647E9) {
            altosCalData.set_gyro_zero(0.0, 0.0, 0.0);
        }
        int n = this.accel_along(this.imu_type);
        int n2 = this.accel_across(this.imu_type);
        int n3 = this.accel_through(this.imu_type);
        int n4 = this.gyro_roll(this.imu_type);
        int n5 = this.gyro_pitch(this.imu_type);
        int n6 = this.gyro_yaw(this.imu_type);
        int n7 = this.mag_along(this.imu_type);
        int n8 = this.mag_across(this.imu_type);
        int n9 = this.mag_through(this.imu_type);
        altosDataListener.set_accel(altosCalData.accel_along(n), altosCalData.accel_across(n2), altosCalData.accel_through(n3));
        altosDataListener.set_gyro(altosCalData.gyro_roll(n4), altosCalData.gyro_pitch(n5), altosCalData.gyro_yaw(n6));
        altosDataListener.set_mag(altosCalData.mag_along(n7), altosCalData.mag_across(n8), altosCalData.mag_through(n9));
    }
}

