/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosQuaternion;

public class AltosRotation
extends AltosQuaternion {
    private AltosQuaternion rotation;

    public double tilt() {
        double d = this.rotation.z * this.rotation.z - this.rotation.y * this.rotation.y - this.rotation.x * this.rotation.x + this.rotation.r * this.rotation.r;
        double d2 = Math.acos(d) * 180.0 / Math.PI;
        return d2;
    }

    public double azimuth() {
        double d = this.rotation.x * this.rotation.x + this.rotation.r * this.rotation.r - this.rotation.z * this.rotation.z - this.rotation.y * this.rotation.y;
        double d2 = this.rotation.x * this.rotation.y + this.rotation.r * this.rotation.z + this.rotation.z * this.rotation.r + this.rotation.y * this.rotation.x;
        double d3 = Math.acos(d) * 180.0 / Math.PI;
        if (d2 < 0.0) {
            return -d3;
        }
        return d3;
    }

    public void rotate(double d, double d2, double d3) {
        AltosQuaternion altosQuaternion = AltosQuaternion.euler(d, d2, d3);
        this.rotation = altosQuaternion.multiply(this.rotation).normalize();
    }

    public AltosRotation(AltosRotation altosRotation) {
        this.rotation = new AltosQuaternion(altosRotation.rotation);
    }

    public AltosRotation(double d, double d2, double d3, int n) {
        AltosQuaternion altosQuaternion = AltosQuaternion.vector(d, d2, d3).normalize();
        double d4 = (n & 1) == 0 ? 1.0 : -1.0;
        AltosQuaternion altosQuaternion2 = new AltosQuaternion(0.0, 0.0, 0.0, d4);
        this.rotation = altosQuaternion2.vectors_to_rotation(altosQuaternion);
    }

    public AltosRotation() {
        this.rotation = new AltosQuaternion();
    }
}

