/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.text.ParseException;
import java.util.HashMap;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosUnits;

public class AltosPyro {
    public static final int pyro_none = 0;
    public static final int pyro_accel_less = 1;
    public static final int pyro_accel_greater = 2;
    public static final String pyro_accel_less_string = "a<";
    public static final String pyro_accel_greater_string = "a>";
    public static final String pyro_accel_less_name = "Vertical acceleration less than";
    public static final String pyro_accel_greater_name = "Vertical acceleration greater than";
    public static final double pyro_accel_scale = 16.0;
    public static final int pyro_speed_less = 4;
    public static final int pyro_speed_greater = 8;
    public static final String pyro_speed_less_string = "s<";
    public static final String pyro_speed_greater_string = "s>";
    public static final String pyro_speed_less_name = "Ascent rate less than";
    public static final String pyro_speed_greater_name = "Ascent rate greater than";
    public static final double pyro_speed_scale = 16.0;
    public static final int pyro_height_less = 16;
    public static final int pyro_height_greater = 32;
    public static final String pyro_height_less_string = "h<";
    public static final String pyro_height_greater_string = "h>";
    public static final String pyro_height_less_name = "Height above pad less than";
    public static final String pyro_height_greater_name = "Height above pad greater than";
    public static final double pyro_height_scale = 1.0;
    public static final int pyro_orient_less = 64;
    public static final int pyro_orient_greater = 128;
    public static final String pyro_orient_less_string = "o<";
    public static final String pyro_orient_greater_string = "o>";
    public static final String pyro_orient_less_name = "Angle from vertical less than (degrees)";
    public static final String pyro_orient_greater_name = "Angle from vertical greater than (degrees)";
    public static final double pyro_orient_scale = 1.0;
    public static final int pyro_time_less = 256;
    public static final int pyro_time_greater = 512;
    public static final String pyro_time_less_string = "t<";
    public static final String pyro_time_greater_string = "t>";
    public static final String pyro_time_less_name = "Time since launch less than (s)";
    public static final String pyro_time_greater_name = "Time since launch greater than (s)";
    public static final double pyro_time_scale = 100.0;
    public static final int pyro_ascending = 1024;
    public static final int pyro_descending = 2048;
    public static final String pyro_ascending_string = "A";
    public static final String pyro_descending_string = "D";
    public static final String pyro_ascending_name = "Ascending";
    public static final String pyro_descending_name = "Descending";
    public static final int pyro_after_motor = 4096;
    public static final String pyro_after_motor_string = "m";
    public static final String pyro_after_motor_name = "After motor number";
    public static final double pyro_after_motor_scale = 1.0;
    public static final int pyro_delay = 8192;
    public static final String pyro_delay_string = "d";
    public static final String pyro_delay_name = "Delay after other conditions (s)";
    public static final double pyro_delay_scale = 100.0;
    public static final int pyro_state_less = 16384;
    public static final int pyro_state_greater_or_equal = 32768;
    public static final String pyro_state_less_string = "f<";
    public static final String pyro_state_greater_or_equal_string = "f>=";
    public static final String pyro_state_less_name = "Flight state before";
    public static final String pyro_state_greater_or_equal_name = "Flight state after";
    public static final double pyro_state_scale = 1.0;
    public static final int pyro_deprecate = 3072;
    public static final int pyro_all = 65535;
    public static final int pyro_all_useful = 62463;
    public static final int pyro_no_value = 3072;
    public static final int pyro_state_value = 49152;
    private static HashMap<String, Integer> string_to_pyro = new HashMap();
    private static HashMap<Integer, String> pyro_to_string = new HashMap();
    private static HashMap<Integer, String> pyro_to_name = new HashMap();
    private static HashMap<Integer, AltosUnits> pyro_to_units = new HashMap();
    private static HashMap<Integer, Double> pyro_to_scale = new HashMap();
    public int channel;
    public int flags;
    public int accel_less;
    public int accel_greater;
    public int speed_less;
    public int speed_greater;
    public int height_less;
    public int height_greater;
    public int orient_less;
    public int orient_greater;
    public int time_less;
    public int time_greater;
    public int delay;
    public int state_less;
    public int state_greater_or_equal;
    public int motor;

    private static void insert_map(int n, String string, String string2, AltosUnits altosUnits, double d) {
        string_to_pyro.put(string, n);
        pyro_to_string.put(n, string);
        pyro_to_name.put(n, string2);
        if (altosUnits != null) {
            pyro_to_units.put(n, altosUnits);
        }
        pyro_to_scale.put(n, d);
    }

    public static int string_to_pyro(String string) {
        if (string_to_pyro.containsKey(string)) {
            return string_to_pyro.get(string);
        }
        return 0;
    }

    public static String pyro_to_string(int n) {
        if (pyro_to_string.containsKey(n)) {
            return pyro_to_string.get(n);
        }
        return null;
    }

    public static String pyro_to_name(int n) {
        AltosUnits altosUnits = null;
        if (!pyro_to_name.containsKey(n)) {
            return null;
        }
        String string = pyro_to_name.get(n);
        if (pyro_to_units.containsKey(n)) {
            altosUnits = pyro_to_units.get(n);
        }
        if (altosUnits == null) {
            return string;
        }
        return String.format("%s (%s)", string, altosUnits.parse_units());
    }

    public static AltosUnits pyro_to_units(int n) {
        if (pyro_to_units.containsKey(n)) {
            return pyro_to_units.get(n);
        }
        return null;
    }

    public static double pyro_to_scale(int n) {
        if (pyro_to_scale.containsKey(n)) {
            return pyro_to_scale.get(n);
        }
        return 1.0;
    }

    private static void initialize_maps() {
        AltosPyro.insert_map(1, pyro_accel_less_string, pyro_accel_less_name, AltosConvert.accel, 16.0);
        AltosPyro.insert_map(2, pyro_accel_greater_string, pyro_accel_greater_name, AltosConvert.accel, 16.0);
        AltosPyro.insert_map(4, pyro_speed_less_string, pyro_speed_less_name, AltosConvert.speed, 16.0);
        AltosPyro.insert_map(8, pyro_speed_greater_string, pyro_speed_greater_name, AltosConvert.speed, 16.0);
        AltosPyro.insert_map(16, pyro_height_less_string, pyro_height_less_name, AltosConvert.height, 1.0);
        AltosPyro.insert_map(32, pyro_height_greater_string, pyro_height_greater_name, AltosConvert.height, 1.0);
        AltosPyro.insert_map(64, pyro_orient_less_string, pyro_orient_less_name, null, 1.0);
        AltosPyro.insert_map(128, pyro_orient_greater_string, pyro_orient_greater_name, null, 1.0);
        AltosPyro.insert_map(256, pyro_time_less_string, pyro_time_less_name, null, 100.0);
        AltosPyro.insert_map(512, pyro_time_greater_string, pyro_time_greater_name, null, 100.0);
        AltosPyro.insert_map(1024, pyro_ascending_string, pyro_ascending_name, null, 1.0);
        AltosPyro.insert_map(2048, pyro_descending_string, pyro_descending_name, null, 1.0);
        AltosPyro.insert_map(4096, pyro_after_motor_string, pyro_after_motor_name, null, 1.0);
        AltosPyro.insert_map(8192, pyro_delay_string, pyro_delay_name, null, 100.0);
        AltosPyro.insert_map(16384, pyro_state_less_string, pyro_state_less_name, null, 1.0);
        AltosPyro.insert_map(32768, pyro_state_greater_or_equal_string, pyro_state_greater_or_equal_name, null, 1.0);
    }

    public AltosPyro(int n) {
        AltosPyro.initialize_maps();
        this.channel = n;
        this.flags = 0;
    }

    private boolean set_ivalue(int n, int n2) {
        switch (n) {
            case 1: {
                this.accel_less = n2;
                break;
            }
            case 2: {
                this.accel_greater = n2;
                break;
            }
            case 4: {
                this.speed_less = n2;
                break;
            }
            case 8: {
                this.speed_greater = n2;
                break;
            }
            case 16: {
                this.height_less = n2;
                break;
            }
            case 32: {
                this.height_greater = n2;
                break;
            }
            case 64: {
                this.orient_less = n2;
                break;
            }
            case 128: {
                this.orient_greater = n2;
                break;
            }
            case 256: {
                this.time_less = n2;
                break;
            }
            case 512: {
                this.time_greater = n2;
                break;
            }
            case 4096: {
                this.motor = n2;
                break;
            }
            case 8192: {
                this.delay = n2;
                break;
            }
            case 16384: {
                this.state_less = n2;
                break;
            }
            case 32768: {
                this.state_greater_or_equal = n2;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean set_value(int n, double d) {
        return this.set_ivalue(n, (int)(d * AltosPyro.pyro_to_scale(n)));
    }

    private int get_ivalue(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = this.accel_less;
                break;
            }
            case 2: {
                n2 = this.accel_greater;
                break;
            }
            case 4: {
                n2 = this.speed_less;
                break;
            }
            case 8: {
                n2 = this.speed_greater;
                break;
            }
            case 16: {
                n2 = this.height_less;
                break;
            }
            case 32: {
                n2 = this.height_greater;
                break;
            }
            case 64: {
                n2 = this.orient_less;
                break;
            }
            case 128: {
                n2 = this.orient_greater;
                break;
            }
            case 256: {
                n2 = this.time_less;
                break;
            }
            case 512: {
                n2 = this.time_greater;
                break;
            }
            case 4096: {
                n2 = this.motor;
                break;
            }
            case 8192: {
                n2 = this.delay;
                break;
            }
            case 16384: {
                n2 = this.state_less;
                break;
            }
            case 32768: {
                n2 = this.state_greater_or_equal;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public double get_value(int n) {
        return (double)this.get_ivalue(n) / AltosPyro.pyro_to_scale(n);
    }

    public AltosPyro(int n, String string) throws ParseException {
        AltosPyro.initialize_maps();
        String[] stringArray = string.split("\\s+");
        this.channel = n;
        this.flags = 0;
        int n2 = 0;
        if (stringArray[n2].equals("Pyro")) {
            n2 += 2;
        }
        while (n2 < stringArray.length && !stringArray[n2].equals("<disabled>")) {
            int n3 = AltosPyro.string_to_pyro(stringArray[n2]);
            if (n3 == 0) {
                throw new ParseException(String.format("Invalid pyro token \"%s\"", stringArray[n2]), n2);
            }
            this.flags |= n3;
            if ((n3 & 0xC00) == 0) {
                int n4 = 0;
                ++n2;
                try {
                    n4 = (int)AltosLib.fromdec(stringArray[n2]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(String.format("Invalid pyro value \"%s\"", stringArray[n2]), n2);
                }
                if (!this.set_ivalue(n3, n4)) {
                    throw new ParseException(String.format("Internal parser error \"%s\" \"%s\"", stringArray[n2 - 1], stringArray[n2]), n2 - 1);
                }
            }
            ++n2;
        }
    }

    public AltosPyro() {
        this(0);
    }

    public String toString() {
        String string = String.format("%d", this.channel);
        for (int i = 1; i <= this.flags; i <<= 1) {
            if ((this.flags & i) == 0) continue;
            String string2 = (i & 0xC00) == 0 ? String.format(" %s %d", pyro_to_string.get(i), this.get_ivalue(i)) : String.format(" %s", pyro_to_string.get(i));
            string = string.concat(string2);
        }
        return string;
    }
}

