/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosFrequency;
import org.altusmetrum.altoslib_14.AltosJson;
import org.altusmetrum.altoslib_14.AltosMapCacheListener;
import org.altusmetrum.altoslib_14.AltosMapTypeListener;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altoslib_14.AltosPreferencesBackend;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosUnitsListener;

public class AltosPreferences {
    public static AltosPreferencesBackend backend = null;
    public static final String logdirPreference = "LOGDIR";
    public static final String channelPreferenceFormat = "CHANNEL-%d";
    public static final String frequencyPreferenceFormat = "FREQUENCY-%d";
    public static final String telemetryPreferenceFormat = "TELEMETRY-%d";
    public static final String telemetryRatePreferenceFormat = "RATE-%d";
    public static final String logfilePreferenceFormat = "LOGFILE-%d";
    public static final String statePreferenceHead = "STATE-";
    public static final String statePreferenceFormat = "STATE-%d";
    public static final String statePreferenceLatest = "STATE-LATEST";
    public static final String voicePreference = "VOICE";
    public static final String callsignPreference = "CALLSIGN";
    public static final String firmwaredirPreference = "FIRMWARE";
    public static final String serialDebugPreference = "SERIAL-DEBUG";
    public static final String scanningTelemetryPreference = "SCANNING-TELEMETRY";
    public static final String scanningTelemetryRatePreference = "SCANNING-RATE";
    public static final String launcherSerialPreference = "LAUNCHER-SERIAL";
    public static final String launcherChannelPreference = "LAUNCHER-CHANNEL";
    public static final String logdirName = "AltusMetrum";
    public static File logdir;
    public static File last_logdir;
    public static File mapdir;
    public static Hashtable<Integer, Double> frequencies;
    public static Hashtable<Integer, Integer> telemetries;
    public static Hashtable<Integer, Integer> telemetry_rates;
    public static Hashtable<Integer, File> logfiles;
    public static boolean voice;
    public static String callsign;
    public static File firmwaredir;
    public static int scanning_telemetry;
    public static int scanning_telemetry_rate;
    public static final String common_frequencies_node_name = "COMMON-FREQUENCIES";
    public static AltosFrequency[] common_frequencies;
    public static final String frequency_count = "COUNT";
    public static final String frequency_format = "FREQUENCY-%d";
    public static final String description_format = "DESCRIPTION-%d";
    public static final String frequenciesPreference = "FREQUENCIES-1";
    public static final String unitsPreference = "IMPERIAL-UNITS";
    static final String mapCachePreference = "MAP-CACHE";
    static LinkedList<AltosMapCacheListener> map_cache_listeners;
    public static int map_cache;
    static final String mapTypePreference = "MAP-TYPE";
    static int map_type;
    public static int launcher_serial;
    public static int launcher_channel;
    static LinkedList<AltosUnitsListener> units_listeners;
    static LinkedList<AltosMapTypeListener> map_type_listeners;

    public static AltosFrequency[] load_common_frequencies() {
        int n;
        Object object;
        AltosFrequency[] altosFrequencyArray = null;
        try {
            object = AltosJson.fromString(backend.getString(frequenciesPreference, null));
            altosFrequencyArray = (AltosFrequency[])((AltosJson)object).make(new AltosFrequency[1].getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (altosFrequencyArray == null && backend.nodeExists(common_frequencies_node_name) && (n = ((AltosPreferencesBackend)(object = backend.node(common_frequencies_node_name))).getInt(frequency_count, 0)) > 0) {
            altosFrequencyArray = new AltosFrequency[n];
            for (int i = 0; i < n; ++i) {
                double d = ((AltosPreferencesBackend)object).getDouble(String.format("FREQUENCY-%d", i), 0.0);
                String string = ((AltosPreferencesBackend)object).getString(String.format(description_format, i), null);
                altosFrequencyArray[i] = new AltosFrequency(d, string);
            }
        }
        if (altosFrequencyArray == null) {
            altosFrequencyArray = new AltosFrequency[10];
            for (int i = 0; i < 10; ++i) {
                altosFrequencyArray[i] = new AltosFrequency(434.55 + (double)i * 0.1, String.format("Channel %d", i));
            }
        }
        return altosFrequencyArray;
    }

    public static void save_common_frequencies() {
        AltosJson altosJson = new AltosJson(common_frequencies);
        backend.putString(frequenciesPreference, altosJson.toString());
        AltosPreferences.flush_preferences();
    }

    public static void init(AltosPreferencesBackend altosPreferencesBackend) {
        if (backend != null) {
            return;
        }
        backend = altosPreferencesBackend;
        String string = backend.getString(logdirPreference, null);
        if (string != null) {
            logdir = new File(string);
        } else {
            logdir = new File(backend.homeDirectory(), logdirName);
            if (!logdir.exists()) {
                logdir.mkdirs();
            }
        }
        mapdir = new File(logdir, "maps");
        if (!mapdir.exists()) {
            mapdir.mkdirs();
        }
        frequencies = new Hashtable();
        telemetries = new Hashtable();
        telemetry_rates = new Hashtable();
        logfiles = new Hashtable();
        voice = backend.getBoolean(voicePreference, true);
        callsign = backend.getString(callsignPreference, "N0CALL");
        scanning_telemetry = backend.getInt(scanningTelemetryPreference, 2);
        scanning_telemetry_rate = backend.getInt(scanningTelemetryRatePreference, 1);
        launcher_serial = backend.getInt(launcherSerialPreference, 0);
        launcher_channel = backend.getInt(launcherChannelPreference, 0);
        String string2 = backend.getString(firmwaredirPreference, null);
        firmwaredir = string2 != null ? new File(string2) : null;
        common_frequencies = AltosPreferences.load_common_frequencies();
        AltosConvert.imperial_units = backend.getBoolean(unitsPreference, false);
        map_cache = backend.getInt(mapCachePreference, 9);
        map_cache_listeners = new LinkedList();
        map_type = backend.getInt(mapTypePreference, 0);
    }

    public static void flush_preferences() {
        backend.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_logdir(File file) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            logdir = file;
            mapdir = new File(logdir, "maps");
            if (!mapdir.exists()) {
                mapdir.mkdirs();
            }
            backend.putString(logdirPreference, logdir.getPath());
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File logdir() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return logdir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File last_logdir() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            if (last_logdir == null) {
                last_logdir = logdir;
            }
            return last_logdir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_last_logdir(File file) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            if (file != null && !file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file == null) {
                file = new File(".");
            }
            last_logdir = file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File mapdir() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return mapdir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_frequency(int n, double d) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            frequencies.put(n, d);
            backend.putDouble(String.format("FREQUENCY-%d", n), d);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double frequency(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            if (frequencies.containsKey(n)) {
                return frequencies.get(n);
            }
            double d = backend.getDouble(String.format("FREQUENCY-%d", n), 0.0);
            if (d == 0.0) {
                int n2 = backend.getInt(String.format(channelPreferenceFormat, n), 0);
                d = AltosConvert.radio_channel_to_frequency(n2);
            }
            frequencies.put(n, d);
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_telemetry(int n, int n2) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            telemetries.put(n, n2);
            backend.putInt(String.format(telemetryPreferenceFormat, n), n2);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int telemetry(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            if (telemetries.containsKey(n)) {
                return telemetries.get(n);
            }
            int n2 = backend.getInt(String.format(telemetryPreferenceFormat, n), 1);
            telemetries.put(n, n2);
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_telemetry_rate(int n, int n2) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            telemetry_rates.put(n, n2);
            backend.putInt(String.format(telemetryRatePreferenceFormat, n), n2);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int telemetry_rate(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            if (telemetry_rates.containsKey(n)) {
                return telemetry_rates.get(n);
            }
            int n2 = backend.getInt(String.format(telemetryRatePreferenceFormat, n), 0);
            telemetry_rates.put(n, n2);
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_logfile(int n, File file) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            logfiles.put(n, file);
            backend.putString(String.format(logfilePreferenceFormat, n), file.getPath());
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File logfile(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            if (logfiles.containsKey(n)) {
                return logfiles.get(n);
            }
            String string = backend.getString(String.format(logfilePreferenceFormat, n), null);
            if (string == null) {
                return null;
            }
            File file = new File(string);
            logfiles.put(n, file);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_state(AltosState altosState, int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            backend.putJson(String.format(statePreferenceFormat, n), new AltosJson(altosState));
            backend.putInt(statePreferenceLatest, n);
            AltosPreferences.flush_preferences();
        }
    }

    public static ArrayList<Integer> list_states() {
        String[] stringArray = backend.keys();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : stringArray) {
            if (!string.startsWith(statePreferenceHead)) continue;
            try {
                int n = AltosParse.parse_int(string.substring(statePreferenceHead.length()));
                arrayList.add(n);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove_state(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            backend.remove(String.format(statePreferenceFormat, n));
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int latest_state() {
        int n = 0;
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            n = backend.getInt(statePreferenceLatest, 0);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AltosState state(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            try {
                AltosJson altosJson = backend.getJson(String.format(statePreferenceFormat, n));
                if (altosJson != null) {
                    return (AltosState)altosJson.make(AltosState.class);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_scanning_telemetry(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            scanning_telemetry = n;
            backend.putInt(scanningTelemetryPreference, scanning_telemetry);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int scanning_telemetry() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return scanning_telemetry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_scanning_telemetry_rate(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            scanning_telemetry_rate = n;
            backend.putInt(scanningTelemetryRatePreference, scanning_telemetry_rate);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int scanning_telemetry_rate() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return scanning_telemetry_rate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_voice(boolean bl) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            voice = bl;
            backend.putBoolean(voicePreference, voice);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean voice() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return voice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_callsign(String string) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            callsign = string;
            backend.putString(callsignPreference, callsign);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String callsign() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return callsign;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_firmwaredir(File file) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            firmwaredir = file;
            backend.putString(firmwaredirPreference, firmwaredir.getPath());
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File firmwaredir() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return firmwaredir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_launcher_serial(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            launcher_serial = n;
            backend.putInt(launcherSerialPreference, launcher_serial);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int launcher_serial() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return launcher_serial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_launcher_channel(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            launcher_channel = n;
            backend.putInt(launcherChannelPreference, launcher_channel);
            AltosPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int launcher_channel() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return launcher_channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AltosPreferencesBackend bt_devices() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return backend.node("bt_devices");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AltosFrequency[] common_frequencies() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return common_frequencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_common_frequencies(AltosFrequency[] altosFrequencyArray) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            common_frequencies = altosFrequencyArray;
            AltosPreferences.save_common_frequencies();
        }
    }

    public static void add_common_frequency(AltosFrequency altosFrequency) {
        int n;
        AltosFrequency[] altosFrequencyArray = AltosPreferences.common_frequencies();
        AltosFrequency[] altosFrequencyArray2 = new AltosFrequency[altosFrequencyArray.length + 1];
        for (n = 0; n < altosFrequencyArray.length; ++n) {
            if (altosFrequency.frequency == altosFrequencyArray[n].frequency) {
                return;
            }
            if (altosFrequency.frequency < altosFrequencyArray[n].frequency) break;
            altosFrequencyArray2[n] = altosFrequencyArray[n];
        }
        altosFrequencyArray2[n] = altosFrequency;
        while (n < altosFrequencyArray.length) {
            altosFrequencyArray2[n + 1] = altosFrequencyArray[n];
            ++n;
        }
        AltosPreferences.set_common_frequencies(altosFrequencyArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean imperial_units() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return AltosConvert.imperial_units;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_imperial_units(boolean bl) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            AltosConvert.imperial_units = bl;
            backend.putBoolean(unitsPreference, bl);
            AltosPreferences.flush_preferences();
        }
        if (units_listeners != null) {
            for (AltosUnitsListener altosUnitsListener : units_listeners) {
                altosUnitsListener.units_changed(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register_units_listener(AltosUnitsListener altosUnitsListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            if (units_listeners == null) {
                units_listeners = new LinkedList();
            }
            units_listeners.add(altosUnitsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister_units_listener(AltosUnitsListener altosUnitsListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            units_listeners.remove(altosUnitsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register_map_cache_listener(AltosMapCacheListener altosMapCacheListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            map_cache_listeners.add(altosMapCacheListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister_map_cache_listener(AltosMapCacheListener altosMapCacheListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            map_cache_listeners.remove(altosMapCacheListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_map_cache(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            map_cache = n;
            backend.putInt(mapCachePreference, map_cache);
            AltosPreferences.flush_preferences();
            for (AltosMapCacheListener altosMapCacheListener : map_cache_listeners) {
                altosMapCacheListener.map_cache_changed(map_cache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int map_cache() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return map_cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_map_type(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            map_type = n;
            backend.putInt(mapTypePreference, n);
            AltosPreferences.flush_preferences();
        }
        if (map_type_listeners != null) {
            for (AltosMapTypeListener altosMapTypeListener : map_type_listeners) {
                altosMapTypeListener.map_type_changed(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int map_type() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return map_type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register_map_type_listener(AltosMapTypeListener altosMapTypeListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            if (map_type_listeners == null) {
                map_type_listeners = new LinkedList();
            }
            map_type_listeners.add(altosMapTypeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister_map_type_listener(AltosMapTypeListener altosMapTypeListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            map_type_listeners.remove(altosMapTypeListener);
        }
    }

    static {
        map_cache = 9;
    }
}

