/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.LinkedList;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGreatCircle;
import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosMapPathPoint;
import org.altusmetrum.altoslib_14.AltosMapRectangle;
import org.altusmetrum.altoslib_14.AltosMapTransform;

public abstract class AltosMapPath {
    public LinkedList<AltosMapPathPoint> points = new LinkedList();
    public AltosMapPathPoint last_point = null;
    public static int stroke_width = 6;

    public abstract void paint(AltosMapTransform var1);

    public AltosMapRectangle add(AltosGPS altosGPS, double d, int n, double d2) {
        AltosMapPathPoint altosMapPathPoint = new AltosMapPathPoint(altosGPS, d, n, d2);
        AltosMapRectangle altosMapRectangle = null;
        if (!altosMapPathPoint.equals(this.last_point)) {
            if (this.last_point != null) {
                altosMapRectangle = new AltosMapRectangle(this.last_point.gps.lat_lon(), altosMapPathPoint.gps.lat_lon());
            }
            this.points.add(altosMapPathPoint);
            this.last_point = altosMapPathPoint;
        }
        return altosMapRectangle;
    }

    private double dist(AltosLatLon altosLatLon, AltosMapPathPoint altosMapPathPoint) {
        return new AltosGreatCircle((double)altosLatLon.lat, (double)altosLatLon.lon, (double)altosMapPathPoint.gps.lat, (double)altosMapPathPoint.gps.lon).distance;
    }

    public AltosMapPathPoint nearest(AltosLatLon altosLatLon) {
        AltosMapPathPoint altosMapPathPoint = null;
        double d = 0.0;
        for (AltosMapPathPoint altosMapPathPoint2 : this.points) {
            if (altosMapPathPoint == null) {
                altosMapPathPoint = altosMapPathPoint2;
                d = this.dist(altosLatLon, altosMapPathPoint2);
                continue;
            }
            double d2 = this.dist(altosLatLon, altosMapPathPoint2);
            if (!(d2 < d)) continue;
            altosMapPathPoint = altosMapPathPoint2;
            d = d2;
        }
        return altosMapPathPoint;
    }

    public void clear() {
        this.points = new LinkedList();
    }
}

