/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosFile;
import org.altusmetrum.altoslib_14.AltosLine;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosTelemetry;

public class AltosLog
implements Runnable {
    LinkedBlockingQueue<AltosLine> input_queue;
    LinkedBlockingQueue<String> pending_queue = new LinkedBlockingQueue();
    int serial;
    int flight;
    int receiver_serial;
    FileWriter log_file;
    Thread log_thread;
    AltosFile file;
    AltosLink link;

    private void close_log_file() {
        if (this.log_file != null) {
            try {
                this.log_file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.log_file = null;
        }
    }

    public void close() {
        this.link.remove_monitor(this.input_queue);
        this.close_log_file();
        if (this.log_thread != null) {
            this.log_thread.interrupt();
            this.log_thread = null;
        }
    }

    public File file() {
        return this.file;
    }

    boolean open(AltosCalData altosCalData) throws IOException, InterruptedException {
        AltosFile altosFile = new AltosFile(altosCalData);
        this.log_file = new FileWriter((File)altosFile, true);
        if (this.log_file != null) {
            while (!this.pending_queue.isEmpty()) {
                String string = this.pending_queue.take();
                this.log_file.write(string);
                this.log_file.write(10);
            }
            this.log_file.flush();
            this.file = altosFile;
            AltosPreferences.set_logfile(this.link.serial, this.file);
        }
        return this.log_file != null;
    }

    @Override
    public void run() {
        try {
            AltosConfigData altosConfigData = this.link.config_data();
            AltosCalData altosCalData = new AltosCalData();
            AltosState altosState = null;
            altosCalData.set_receiver_serial(altosConfigData.serial);
            while (true) {
                AltosLine altosLine = this.input_queue.take();
                if (altosLine.line == null) continue;
                try {
                    AltosTelemetry altosTelemetry = AltosTelemetry.parse(altosLine.line);
                    if (altosState == null) {
                        altosState = new AltosState(altosCalData);
                    }
                    altosTelemetry.provide_data(altosState);
                    if (altosCalData.serial != this.serial || altosCalData.flight != this.flight || this.log_file == null) {
                        this.close_log_file();
                        this.serial = altosCalData.serial;
                        this.flight = altosCalData.flight;
                        altosState = null;
                        if (altosCalData.serial != Integer.MAX_VALUE && altosCalData.flight != Integer.MAX_VALUE) {
                            this.open(altosCalData);
                        }
                    }
                }
                catch (ParseException parseException) {
                }
                catch (AltosCRCException altosCRCException) {
                    // empty catch block
                }
                if (this.log_file != null) {
                    this.log_file.write(altosLine.line);
                    this.log_file.write(10);
                    this.log_file.flush();
                    continue;
                }
                this.pending_queue.put(altosLine.line);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TimeoutException timeoutException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    public AltosLog(AltosLink altosLink) {
        this.input_queue = new LinkedBlockingQueue();
        altosLink.add_monitor(this.input_queue);
        this.serial = -1;
        this.flight = -1;
        this.link = altosLink;
        this.log_file = null;
        this.log_thread = new Thread(this);
        this.log_thread.start();
    }
}

