/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.altusmetrum.altoslib_14.AltosHexsym;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosUsbId;
import org.altusmetrum.altoslib_14.HexFileInputStream;
import org.altusmetrum.altoslib_14.HexRecord;

public class AltosHexfile {
    public long address;
    public long max_address;
    public byte[] data;
    LinkedList<AltosHexsym> symlist = new LinkedList();
    static final int ao_romconfig_version_addr = 160;
    static final int ao_romconfig_check_addr = 162;
    static final int ao_serial_number_addr = 164;
    static final int ao_radio_cal_addr = 166;
    static final int ao_usb_descriptors_addr = 170;
    static AltosHexsym[] cc_symbols = new AltosHexsym[]{new AltosHexsym("ao_romconfig_version", 160L), new AltosHexsym("ao_romconfig_check", 162L), new AltosHexsym("ao_serial_number", 164L), new AltosHexsym("ao_radio_cal", 166L), new AltosHexsym("ao_usb_descriptors", 170L)};
    static final int AO_USB_DESC_DEVICE = 1;
    static final int AO_USB_DESC_STRING = 3;
    static final int AO_ROMCONFIG_VERSION_INDEX = 0;
    static final int AO_ROMCONFIG_CHECK_INDEX = 1;
    static final int AO_SERIAL_NUMBER_INDEX = 2;
    static final int AO_RADIO_CAL_INDEX = 3;
    static final int AO_USB_DESCRIPTORS_INDEX = 4;
    private static final int[] look_around = new int[]{0, -2, 2, -4, 4};

    public byte get_byte(long l) {
        return this.data[(int)(l - this.address)];
    }

    public int get_u8(long l) {
        return this.get_byte(l) & 0xFF;
    }

    public int get_u16(long l) {
        return this.get_u8(l) | this.get_u8(l + 1L) << 8;
    }

    private void add_cc_symbols() {
        for (int i = 0; i < cc_symbols.length; ++i) {
            this.symlist.add(cc_symbols[i]);
        }
    }

    public void add_symbol(AltosHexsym altosHexsym) {
        this.symlist.add(altosHexsym);
    }

    public void add_symbols(AltosHexfile altosHexfile) {
        for (AltosHexsym altosHexsym : altosHexfile.symlist) {
            this.symlist.add(altosHexsym);
        }
    }

    public AltosHexsym lookup_symbol(String string) {
        if (this.symlist.isEmpty()) {
            this.add_cc_symbols();
        }
        for (AltosHexsym altosHexsym : this.symlist) {
            if (!string.equals(altosHexsym.name)) continue;
            return altosHexsym;
        }
        return null;
    }

    private long find_usb_descriptors() {
        AltosHexsym altosHexsym = this.lookup_symbol("ao_usb_descriptors");
        if (altosHexsym == null) {
            return -1L;
        }
        long l = altosHexsym.address;
        for (int n : look_around) {
            try {
                if (this.get_u8(l + (long)n) != 18 || this.get_u8(l + (long)n + 1L) != 1) continue;
                return l;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public AltosUsbId find_usb_id() {
        long l = this.find_usb_descriptors();
        if (l == -1L) {
            return null;
        }
        while (this.get_u8(l + 1L) != 1) {
            int n = this.get_u8(l);
            if (n != 0 && (l += (long)n) < this.max_address) continue;
            return null;
        }
        return new AltosUsbId(this.get_u16(l + 8L), this.get_u16(l + 10L));
    }

    public String find_usb_product() {
        int n;
        long l = this.find_usb_descriptors();
        if (l == -1L) {
            return null;
        }
        int n2 = this.get_u8(l + 15L);
        int n3 = 0;
        while (this.get_u8(l + 1L) != 3 || ++n3 != n2 + 1) {
            n = this.get_u8(l);
            if (n != 0 && (l += (long)n) < this.max_address) continue;
            return null;
        }
        n = this.get_u8(l);
        if (n <= 0) {
            return null;
        }
        String string = "";
        for (int i = 0; i < n - 2; i += 2) {
            int n4 = this.get_u16(l + 2L + (long)i);
            string = string + Character.toString((char)n4);
        }
        if (AltosLink.debug) {
            System.out.printf("product %s\n", string);
        }
        return string;
    }

    private String make_string(byte[] byArray, int n, int n2) {
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + (char)byArray[n + i];
        }
        return string;
    }

    public AltosHexfile(byte[] byArray, long l) {
        this.data = byArray;
        this.address = l;
        this.max_address = this.address + (long)byArray.length;
    }

    public AltosHexfile(FileInputStream fileInputStream) throws IOException {
        long l;
        long l2;
        HexFileInputStream hexFileInputStream = new HexFileInputStream(fileInputStream);
        LinkedList<HexRecord> linkedList = new LinkedList<HexRecord>();
        boolean bl = false;
        while (!bl) {
            try {
                HexRecord hexRecord = new HexRecord(hexFileInputStream);
                linkedList.add(hexRecord);
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        }
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean bl2 = false;
        block17: for (HexRecord hexRecord : linkedList) {
            switch (hexRecord.type) {
                case 0: {
                    l2 = l3 + hexRecord.address;
                    l = l2 + (long)hexRecord.data.length;
                    if (!bl2 || l2 < l4) {
                        l4 = l2;
                    }
                    if (!bl2 || l > l5) {
                        l5 = l;
                    }
                    bl2 = true;
                    continue block17;
                }
                case 1: {
                    continue block17;
                }
                case 2: {
                    if (hexRecord.data.length != 2) {
                        throw new IOException("invalid extended segment address record");
                    }
                    l3 = (hexRecord.data[0] << 8) + hexRecord.data[1] << 4;
                    continue block17;
                }
                case 4: {
                    if (hexRecord.data.length != 2) {
                        throw new IOException("invalid extended segment address record");
                    }
                    l3 = (hexRecord.data[0] << 8) + hexRecord.data[1] << 16;
                    continue block17;
                }
                case 254: {
                    String string = this.make_string(hexRecord.data, 0, hexRecord.data.length);
                    l2 = l3 + hexRecord.address;
                    AltosHexsym altosHexsym = new AltosHexsym(string, l2);
                    this.symlist.add(altosHexsym);
                    continue block17;
                }
            }
            throw new IOException("invalid hex record type");
        }
        if (!bl2 || l4 >= l5) {
            throw new IOException("invalid hex file");
        }
        if (l5 - l4 > 0x400000L) {
            throw new IOException("hex file too large");
        }
        this.data = new byte[(int)(l5 - l4)];
        this.address = l4;
        this.max_address = l5;
        Arrays.fill(this.data, (byte)-1);
        block18: for (HexRecord hexRecord : linkedList) {
            switch (hexRecord.type) {
                case 0: {
                    l2 = l3 + hexRecord.address;
                    l = l2 + (long)hexRecord.data.length;
                    for (int i = 0; i < hexRecord.data.length; ++i) {
                        this.data[(int)(l2 - l4) + i] = hexRecord.data[i];
                    }
                    continue block18;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (hexRecord.data.length != 2) {
                        throw new IOException("invalid extended segment address record");
                    }
                    l3 = (hexRecord.data[0] << 8) + hexRecord.data[1] << 4;
                    break;
                }
                case 4: {
                    if (hexRecord.data.length != 2) {
                        throw new IOException("invalid extended segment address record");
                    }
                    l3 = (hexRecord.data[0] << 8) + hexRecord.data[1] << 16;
                    break;
                }
                case 254: {
                    break;
                }
                default: {
                    throw new IOException("invalid hex record type");
                }
            }
        }
    }
}

