/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;

public class AltosEepromRecordMotor
extends AltosEepromRecord {
    public static final int record_length = 16;
    private int log_format;

    private int flight() {
        return this.data16(0);
    }

    private int ground_accel() {
        return this.data16(2);
    }

    private int ground_accel_along() {
        return this.data16(4);
    }

    private int ground_accel_across() {
        return this.data16(6);
    }

    private int ground_accel_through() {
        return this.data16(8);
    }

    private int ground_motor_pressure() {
        return this.data16(10);
    }

    private int state() {
        return this.data16(0);
    }

    private int reason() {
        return this.data16(2);
    }

    private int motor_pres() {
        return this.data16(0);
    }

    private int v_batt() {
        return this.data16(2);
    }

    private int accel() {
        return this.data16(4);
    }

    private int accel_across() {
        return this.data16(6);
    }

    private int accel_along() {
        return -this.data16(8);
    }

    private int accel_through() {
        return this.data16(10);
    }

    private int imu_type() {
        switch (this.log_format) {
            case 20: {
                return 6;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        super.provide_data(altosDataListener, altosCalData);
        altosCalData.set_imu_type(this.imu_type());
        switch (this.cmd()) {
            case 70: {
                altosCalData.set_flight(this.flight());
                altosCalData.set_ground_accel(this.ground_accel());
                altosDataListener.set_accel_ground(altosCalData.accel_along(this.ground_accel_along()), altosCalData.accel_across(this.ground_accel_across()), altosCalData.accel_through(this.ground_accel_through()));
                altosCalData.set_ground_motor_pressure(this.ground_motor_pressure());
                break;
            }
            case 83: {
                altosDataListener.set_state(this.state());
                break;
            }
            case 65: {
                AltosConfigData altosConfigData = this.eeprom.config_data();
                altosDataListener.set_battery_voltage(AltosConvert.easy_mini_2_voltage(this.v_batt()));
                double d = AltosConvert.easy_motor_2_motor_pressure(this.motor_pres(), altosCalData.ground_motor_pressure);
                altosDataListener.set_motor_pressure(d);
                int n = this.accel_along();
                int n2 = this.accel_across();
                int n3 = this.accel_through();
                altosDataListener.set_accel(altosCalData.accel_along(n), altosCalData.accel_across(n2), altosCalData.accel_through(n3));
                altosDataListener.set_acceleration(altosCalData.acceleration(this.accel()));
            }
        }
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordMotor(this.eeprom, n);
    }

    public AltosEepromRecordMotor(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 16);
        this.log_format = altosEeprom.config_data().log_format;
    }

    public AltosEepromRecordMotor(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

