/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;
import org.altusmetrum.altoslib_14.AltosPresTemp;

public class AltosEepromRecordMini
extends AltosEepromRecord {
    public static final int record_length = 16;

    public int flight() {
        return this.data16(0);
    }

    public int ground_pres() {
        return this.data32(4);
    }

    public int state() {
        return this.data16(0);
    }

    public int reason() {
        return this.data16(2);
    }

    public int pres() {
        return this.data24(0);
    }

    public int temp() {
        return this.data24(3);
    }

    public int sense_a() {
        return this.data16(6);
    }

    public int sense_m() {
        return this.data16(8);
    }

    public int v_batt() {
        return this.data16(10);
    }

    private int log_format() {
        return this.eeprom.config_data().log_format;
    }

    private double battery_voltage(int n) {
        int n2 = this.log_format();
        if (n2 == 6) {
            return AltosConvert.easy_mini_1_voltage(n, this.eeprom.config_data().serial);
        }
        if (n2 == 14) {
            return AltosConvert.easy_mini_2_voltage(n);
        }
        if (n2 == 8) {
            return AltosConvert.tele_mini_2_voltage(n);
        }
        if (n2 == 12) {
            return AltosConvert.tele_mini_3_battery_voltage(n);
        }
        return -1.0;
    }

    private double pyro_voltage(int n) {
        int n2 = this.log_format();
        if (n2 == 6) {
            return AltosConvert.easy_mini_1_voltage(n, this.eeprom.config_data().serial);
        }
        if (n2 == 14) {
            return AltosConvert.easy_mini_2_voltage(n);
        }
        if (n2 == 8) {
            return AltosConvert.tele_mini_2_voltage(n);
        }
        if (n2 == 12) {
            return AltosConvert.tele_mini_3_pyro_voltage(n);
        }
        return -1.0;
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        super.provide_data(altosDataListener, altosCalData);
        switch (this.cmd()) {
            case 70: {
                altosCalData.set_flight(this.flight());
                altosCalData.set_ground_pressure(this.ground_pres());
                break;
            }
            case 83: {
                altosDataListener.set_state(this.state());
                break;
            }
            case 65: {
                AltosPresTemp altosPresTemp = this.eeprom.config_data().ms5607().pres_temp(this.pres(), this.temp());
                altosDataListener.set_pressure(altosPresTemp.pres);
                altosDataListener.set_temperature(altosPresTemp.temp);
                altosDataListener.set_apogee_voltage(this.pyro_voltage(this.sense_a()));
                altosDataListener.set_main_voltage(this.pyro_voltage(this.sense_m()));
                altosDataListener.set_battery_voltage(this.battery_voltage(this.v_batt()));
            }
        }
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordMini(this.eeprom, n);
    }

    public AltosEepromRecordMini(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 16);
    }

    public AltosEepromRecordMini(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

