/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.text.ParseException;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosLink;

public class AltosEepromChunk {
    public static final int chunk_size = 256;
    public static final int per_line = 8;
    public int[] data = new int[256];
    public int address;
    public ParseException parse_exception = null;

    int[] ParseHex(String string) {
        String[] stringArray = string.split("\\s+");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i], 16);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return nArray;
    }

    public int data(int n) {
        return this.data[n];
    }

    public int data16(int n) {
        return this.data[n] | this.data[n + 1] << 8;
    }

    public int data32(int n) {
        return this.data[n] | this.data[n + 1] << 8 | this.data[n + 2] << 16 | this.data[n + 3] << 24;
    }

    public boolean erased(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (this.data[n + i] == 255) continue;
            return false;
        }
        return true;
    }

    public boolean erased() {
        return this.erased(0, 256);
    }

    public AltosEepromChunk(AltosLink altosLink, int n, boolean bl) throws TimeoutException, InterruptedException {
        this.address = n * 256;
        if (bl) {
            altosLink.flush_input();
        }
        altosLink.printf("e %x\n", n);
        for (int i = 0; i < 256; i += 8) {
            try {
                String string = altosLink.get_reply(5000);
                if (string == null) {
                    throw new TimeoutException();
                }
                int[] nArray = this.ParseHex(string);
                if (nArray == null || nArray.length != 9) {
                    throw new ParseException(String.format("invalid line %s", string), 0);
                }
                if (nArray[0] != i) {
                    throw new ParseException(String.format("data address out of sync at 0x%x", this.address + i), 0);
                }
                for (int j = 0; j < 8; ++j) {
                    this.data[i + j] = nArray[1 + j];
                }
                continue;
            }
            catch (ParseException parseException) {
                for (int j = 0; j < 8; ++j) {
                    this.data[i + j] = 255;
                }
                if (this.parse_exception != null) continue;
                this.parse_exception = parseException;
            }
        }
    }
}

