/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosUnknownProduct;

public class AltosAdxl375
implements Cloneable {
    private int[] accels = new int[3];
    private int axis;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;

    public boolean parse_line(String string) throws NumberFormatException {
        if (string.startsWith("ADXL375 value")) {
            String[] stringArray = string.split("\\s+");
            if (this.axis == Integer.MAX_VALUE) {
                throw new NumberFormatException("No ADXL375 axis specified");
            }
            if (stringArray.length >= 3) {
                for (int i = 0; i < 3; ++i) {
                    this.accels[i] = Integer.parseInt(stringArray[2 + i]);
                }
                return true;
            }
        }
        return false;
    }

    public AltosAdxl375 clone() {
        AltosAdxl375 altosAdxl375 = new AltosAdxl375(this.axis);
        for (int i = 0; i < 3; ++i) {
            altosAdxl375.accels[i] = this.accels[i];
        }
        return altosAdxl375;
    }

    private int accel_along() {
        return this.accels[this.axis];
    }

    private int accel_across() {
        if (this.axis == 0) {
            return this.accels[1];
        }
        return this.accels[0];
    }

    private int accel_through() {
        return this.accels[2];
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink, boolean bl, int n) throws InterruptedException, AltosUnknownProduct {
        try {
            AltosCalData altosCalData = altosDataListener.cal_data();
            AltosAdxl375 altosAdxl375 = new AltosAdxl375(altosLink, altosCalData.adxl375_axis);
            if (altosAdxl375 != null) {
                int n2 = altosAdxl375.accel_along();
                if (!altosCalData.adxl375_inverted) {
                    n2 = -n2;
                }
                if (altosCalData.pad_orientation == 1) {
                    n2 = -n2;
                }
                altosDataListener.set_acceleration(altosCalData.acceleration(n2));
                if (bl) {
                    altosCalData.set_imu_type(n);
                    double d = altosCalData.accel_along(-n2);
                    double d2 = altosCalData.accel_across(altosAdxl375.accel_across());
                    double d3 = altosCalData.accel_through(altosAdxl375.accel_through());
                    altosDataListener.set_accel_ground(d, d2, d3);
                    altosDataListener.set_accel(d, d2, d3);
                }
            }
        }
        catch (TimeoutException timeoutException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public AltosAdxl375() {
        for (int i = 0; i < 3; ++i) {
            this.accels[i] = Integer.MAX_VALUE;
        }
        this.axis = Integer.MAX_VALUE;
    }

    public AltosAdxl375(int n) {
        this();
        this.axis = n;
    }

    public AltosAdxl375(AltosLink altosLink, int n) throws InterruptedException, TimeoutException, NumberFormatException {
        this(n);
        String string;
        altosLink.printf("A\n", new Object[0]);
        do {
            if ((string = altosLink.get_reply_no_dialog(5000)) != null) continue;
            throw new TimeoutException();
        } while (!this.parse_line(string));
    }
}

