/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Frame;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import libaltosJNI.SWIGTYPE_p_altos_file;
import libaltosJNI.libaltos;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;

public class AltosSerial
extends AltosLink {
    static List<String> devices_opened = Collections.synchronizedList(new LinkedList());
    public AltosDevice device;
    SWIGTYPE_p_altos_file altos;
    Thread input_thread;
    String line;
    byte[] line_bytes;
    int line_count;
    Frame frame;
    JDialog timeout_dialog;

    public int getchar() {
        if (this.altos == null) {
            return -1;
        }
        return libaltos.altos_getchar((SWIGTYPE_p_altos_file)this.altos, (int)0);
    }

    public void flush_output() {
        super.flush_output();
        if (this.altos != null && libaltos.altos_flush((SWIGTYPE_p_altos_file)this.altos) != 0) {
            this.close_serial();
        }
    }

    private void start_timeout_dialog_internal() {
        Object[] objectArray = new Object[]{"Cancel"};
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setMessage(String.format("Connecting to %s, %7.3f MHz as %s", this.device.toShortString(), this.frequency, this.callsign));
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(null);
        this.timeout_dialog = jOptionPane.createDialog(this.frame, "Connecting...");
        this.timeout_dialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == null) {
            return;
        }
        if (objectArray[0].equals(object)) {
            this.reply_abort = true;
        }
        this.timeout_dialog.dispose();
        this.timeout_dialog = null;
    }

    public boolean can_cancel_reply() {
        return !SwingUtilities.isEventDispatchThread();
    }

    public boolean show_reply_timeout() {
        if (!SwingUtilities.isEventDispatchThread() && this.frame != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AltosSerial.this.start_timeout_dialog_internal();
                }
            };
            SwingUtilities.invokeLater(runnable);
            return true;
        }
        return false;
    }

    public void hide_reply_timeout() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AltosSerial.this.timeout_dialog.setVisible(false);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close_serial() {
        List<String> list = devices_opened;
        synchronized (list) {
            devices_opened.remove(this.device.getPath());
        }
        if (this.altos != null) {
            libaltos.altos_free((SWIGTYPE_p_altos_file)this.altos);
            this.altos = null;
        }
        this.abort_reply();
    }

    public void close() {
        if (this.remote) {
            try {
                this.stop_remote();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.in_reply != 0) {
            System.out.printf("Uh-oh. Closing active serial device\n", new Object[0]);
        }
        this.close_serial();
        if (this.input_thread != null) {
            try {
                this.input_thread.interrupt();
                this.input_thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.input_thread = null;
        }
        if (debug) {
            System.out.printf("Closing %s\n", this.device.getPath());
        }
    }

    private void putc(char c) {
        if (this.altos != null && libaltos.altos_putchar((SWIGTYPE_p_altos_file)this.altos, (char)c) != 0) {
            this.close_serial();
        }
    }

    public void putchar(byte by) {
        if (this.altos != null) {
            if (debug) {
                System.out.printf(" %02x", by & 0xFF);
            }
            if (libaltos.altos_putchar((SWIGTYPE_p_altos_file)this.altos, (char)((char)by)) != 0) {
                this.close_serial();
            }
        }
    }

    public void print(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.putc(string.charAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws FileNotFoundException, AltosSerialInUseException {
        Object object = devices_opened;
        synchronized (object) {
            if (devices_opened.contains(this.device.getPath())) {
                throw new AltosSerialInUseException(this.device);
            }
            devices_opened.add(this.device.getPath());
        }
        this.altos = this.device.open();
        if (this.altos == null) {
            object = this.device.getErrorString();
            this.close();
            throw new FileNotFoundException(String.format("%s (%s)", this.device.toShortString(), object));
        }
        if (debug) {
            System.out.printf("Open %s\n", this.device.getPath());
        }
        this.input_thread = new Thread((Runnable)((Object)this));
        this.input_thread.start();
        this.print("~\nE 0\n");
        this.set_monitor(false);
        this.flush_output();
    }

    public void set_frame(Frame frame) {
        this.frame = frame;
    }

    public AltosSerial(AltosDevice altosDevice) throws FileNotFoundException, AltosSerialInUseException {
        this.device = altosDevice;
        this.frame = null;
        this.serial = this.device.getSerial();
        this.name = this.device.toShortString();
        this.open();
    }
}

