/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.concurrent.Semaphore;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.altusmetrum.altoslib_14.AltosEepromMonitor;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.result_holder;

public class AltosEepromMonitorUI
extends AltosUIDialog
implements AltosEepromMonitor {
    JFrame owner;
    Container pane;
    Box box;
    JLabel serial_label;
    JLabel flight_label;
    JLabel file_label;
    JLabel serial_value;
    JLabel flight_value;
    JButton cancel;
    JProgressBar pbar;
    ActionListener listener;
    static final int progress_max = 10000;
    int max_block = 1;

    public AltosEepromMonitorUI(JFrame jFrame) {
        super(jFrame, "Download Flight Data", false);
        Insets insets;
        Insets insets2;
        this.setMinimumSize(new Dimension(600, 100));
        this.owner = jFrame;
        Insets insets3 = new Insets(4, 4, 4, 4);
        Insets insets4 = new Insets(4, 4, 4, 4);
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets3;
        this.serial_label = new JLabel("Serial:");
        this.pane.add((Component)this.serial_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets4;
        this.serial_value = new JLabel("");
        this.pane.add((Component)this.serial_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets3;
        this.flight_label = new JLabel("Flight:");
        this.pane.add((Component)this.flight_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets4;
        this.flight_value = new JLabel("");
        this.pane.add((Component)this.flight_value, gridBagConstraints);
        this.pbar = new JProgressBar();
        this.pbar.setMinimum(0);
        this.pbar.setMaximum(10000);
        this.pbar.setStringPainted(true);
        this.set_block_internal(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2 = new Insets(4, 4, 4, 4);
        this.pane.add((Component)this.pbar, gridBagConstraints);
        this.cancel = new JButton("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets = new Insets(4, 4, 4, 4);
        this.pane.add((Component)this.cancel, gridBagConstraints);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void set_thread(Thread thread) {
        final Thread thread2 = thread;
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (thread2 != null) {
                    thread2.interrupt();
                }
            }
        });
    }

    public void start() {
        this.setVisible(true);
    }

    public void set_block_internal(int n) {
        double d = (double)n / (double)this.max_block;
        String string = String.format("block %d of %d", n, this.max_block);
        this.pbar.setString(string);
        this.pbar.setStringPainted(true);
        this.pbar.setValue((int)(d * 10000.0));
    }

    public void set_max(int n) {
        this.max_block = n;
    }

    public void set_block(int n) {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AltosEepromMonitorUI.this.set_block_internal(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void set_serial_internal(int n) {
        this.serial_value.setText(String.format("%d", n));
    }

    public void set_serial(int n) {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AltosEepromMonitorUI.this.set_serial_internal(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void set_flight_internal(int n) {
        this.flight_value.setText(String.format("%d", n));
    }

    public void set_flight(int n) {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AltosEepromMonitorUI.this.set_flight_internal(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void done_internal(boolean bl) {
        this.listener.actionPerformed(new ActionEvent(this, bl ? 1 : 0, "download"));
        this.setVisible(false);
        this.dispose();
    }

    public void done(boolean bl) {
        final boolean bl2 = bl;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AltosEepromMonitorUI.this.done_internal(bl2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void reset_internal() {
        this.set_max(1);
        this.set_block_internal(0);
        this.set_flight_internal(0);
    }

    public void reset() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AltosEepromMonitorUI.this.reset_internal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void show_message_internal(String string, String string2, int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 0;
            }
        }
        JOptionPane.showMessageDialog(this.owner, string, string2, n2);
    }

    public Boolean check_overwrite(File file) {
        final Semaphore semaphore = new Semaphore(0);
        final File file2 = file;
        result_holder result_holder2 = new result_holder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                result_holder.result = JOptionPane.showConfirmDialog(AltosEepromMonitorUI.this.owner, String.format("\"%s\" already exists, overwrite?", file2.toString()), "Overwrite Existing File?", 0);
                semaphore.release();
            }
        };
        SwingUtilities.invokeLater(runnable);
        try {
            semaphore.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result_holder.result == 0;
    }

    public void show_message(String string, String string2, int n) {
        final String string3 = string;
        final String string4 = string2;
        final int n2 = n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AltosEepromMonitorUI.this.show_message_internal(string3, string4, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

