/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicArrowButton;
import org.altusmetrum.altosuilib_14.AltosBTDevice;
import org.altusmetrum.altosuilib_14.AltosBTDeviceIterator;
import org.altusmetrum.altosuilib_14.AltosBTKnown;
import org.altusmetrum.altosuilib_14.AltosUIDialog;

public class AltosBTManage
extends AltosUIDialog
implements ActionListener,
Iterable<AltosBTDevice> {
    LinkedBlockingQueue<AltosBTDevice> found_devices;
    Frame frame;
    LinkedList<ActionListener> listeners;
    AltosBTKnown bt_known;
    DeviceList visible_devices;
    DeviceList known_devices;
    Thread bt_thread;

    @Override
    public Iterator<AltosBTDevice> iterator() {
        return this.known_devices.iterator();
    }

    public void commit() {
        this.bt_known.set(this);
    }

    public void add_known() {
        try {
            for (AltosBTDevice altosBTDevice : this.visible_devices.selected_list()) {
                this.known_devices.add(altosBTDevice);
                this.visible_devices.remove(altosBTDevice);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void remove_known() {
        try {
            for (AltosBTDevice altosBTDevice : this.known_devices.selected_list()) {
                this.known_devices.remove(altosBTDevice);
                this.visible_devices.add(altosBTDevice);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    private void forwardAction(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok".equals(string)) {
            this.bt_thread.interrupt();
            this.commit();
            this.setVisible(false);
            this.forwardAction(actionEvent);
        } else if ("cancel".equals(string)) {
            this.bt_thread.interrupt();
            this.setVisible(false);
            this.forwardAction(actionEvent);
        } else if ("select".equals(string)) {
            this.add_known();
        } else if ("deselect".equals(string)) {
            this.remove_known();
        }
    }

    public void got_visible_device() {
        while (!this.found_devices.isEmpty()) {
            AltosBTDevice altosBTDevice = (AltosBTDevice)this.found_devices.remove();
            if (this.known_devices.contains(altosBTDevice)) continue;
            this.visible_devices.add(altosBTDevice);
        }
    }

    public static void show(Component component, AltosBTKnown altosBTKnown) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        AltosBTManage altosBTManage = new AltosBTManage(frame, altosBTKnown);
        altosBTManage.setVisible(true);
    }

    public AltosBTManage(Frame frame, AltosBTKnown altosBTKnown) {
        super(frame, "Manage Bluetooth Devices", true);
        Object object2;
        this.frame = frame;
        this.bt_known = altosBTKnown;
        BTGetVisibleDevices bTGetVisibleDevices = new BTGetVisibleDevices();
        this.bt_thread = new Thread(bTGetVisibleDevices);
        this.bt_thread.start();
        this.listeners = new LinkedList();
        this.found_devices = new LinkedBlockingQueue();
        Container container = this.getScrollablePane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)new JLabel("Known Devices"), gridBagConstraints);
        this.known_devices = new DeviceList();
        for (Object object2 : this.bt_known) {
            this.known_devices.add((AltosBTDevice)object2);
        }
        JScrollPane jScrollPane = new JScrollPane(this.known_devices);
        jScrollPane.setPreferredSize(new Dimension(400, 80));
        jScrollPane.setAlignmentX(0.0f);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)new JLabel("Visible Devices"), gridBagConstraints);
        this.visible_devices = new DeviceList();
        object2 = new JScrollPane(this.visible_devices);
        ((JComponent)object2).setPreferredSize(new Dimension(400, 80));
        ((JComponent)object2).setAlignmentX(0.0f);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)object2, gridBagConstraints);
        BasicArrowButton basicArrowButton = new BasicArrowButton(7);
        basicArrowButton.setActionCommand("select");
        basicArrowButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)basicArrowButton, gridBagConstraints);
        BasicArrowButton basicArrowButton2 = new BasicArrowButton(3);
        basicArrowButton2.setActionCommand("deselect");
        basicArrowButton2.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)basicArrowButton2, gridBagConstraints);
        JButton jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton("OK");
        jButton2.setActionCommand("ok");
        jButton2.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)jButton2, gridBagConstraints);
        this.getRootPane().setDefaultButton(jButton2);
        this.pack();
        this.setLocationRelativeTo(this.frame);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AltosBTManage.this.bt_thread.interrupt();
                AltosBTManage.this.setVisible(false);
            }
        });
    }

    class BTGetVisibleDevices
    implements Runnable {
        BTGetVisibleDevices() {
        }

        @Override
        public void run() {
            block2: while (true) {
                int n = 1;
                while (true) {
                    if (n > 8) continue block2;
                    AltosBTDeviceIterator altosBTDeviceIterator = new AltosBTDeviceIterator(n);
                    if (Thread.interrupted()) {
                        return;
                    }
                    try {
                        AltosBTDevice altosBTDevice;
                        while ((altosBTDevice = altosBTDeviceIterator.next()) != null) {
                            if (Thread.interrupted()) {
                                return;
                            }
                            AltosBTManage.this.found_devices.add(altosBTDevice);
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    AltosBTManage.this.got_visible_device();
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    }
                    catch (Exception exception) {
                        System.out.printf("uh-oh, exception %s\n", exception.toString());
                    }
                    n <<= 1;
                }
                break;
            }
        }
    }

    class DeviceList
    extends JList<AltosBTDevice>
    implements Iterable<AltosBTDevice> {
        LinkedList<AltosBTDevice> devices = new LinkedList();
        DefaultListModel<AltosBTDevice> list_model = new DefaultListModel();

        public void add(AltosBTDevice altosBTDevice) {
            if (!this.devices.contains(altosBTDevice)) {
                this.devices.add(altosBTDevice);
                this.list_model.addElement(altosBTDevice);
            }
        }

        public void remove(AltosBTDevice altosBTDevice) {
            if (this.devices.contains(altosBTDevice)) {
                this.devices.remove(altosBTDevice);
                this.list_model.removeElement(altosBTDevice);
            }
        }

        public boolean contains(AltosBTDevice altosBTDevice) {
            return this.devices.contains(altosBTDevice);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            int n3;
            if (n == 1 && n2 < 0 && (n3 = this.getFirstVisibleIndex()) != -1) {
                Rectangle rectangle2 = this.getCellBounds(n3, n3);
                if (rectangle2.y == rectangle.y && n3 != 0) {
                    Point point = rectangle2.getLocation();
                    --point.y;
                    int n4 = this.locationToIndex(point);
                    Rectangle rectangle3 = this.getCellBounds(n4, n4);
                    if (rectangle3 == null || rectangle3.y >= rectangle2.y) {
                        return 0;
                    }
                    return rectangle3.height;
                }
            }
            return super.getScrollableUnitIncrement(rectangle, n, n2);
        }

        @Override
        public Iterator<AltosBTDevice> iterator() {
            return this.devices.iterator();
        }

        public List<AltosBTDevice> selected_list() throws InterruptedException {
            return this.getSelectedValuesList();
        }

        public DeviceList() {
            this.setModel(this.list_model);
            this.setSelectionMode(2);
            this.setLayoutOrientation(2);
            this.setVisibleRowCount(-1);
        }
    }
}

