/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.Altos;
import altosui.AltosConfigFC;
import altosui.AltosConfigTD;
import altosui.AltosConfigureUI;
import altosui.AltosFlightUI;
import altosui.AltosGraphUI;
import altosui.AltosIdleMonitorUI;
import altosui.AltosIgniteUI;
import altosui.AltosLaunchUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.altusmetrum.altoslib_14.AltosCSV;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosEepromList;
import org.altusmetrum.altoslib_14.AltosEepromLog;
import org.altusmetrum.altoslib_14.AltosFlightSeries;
import org.altusmetrum.altoslib_14.AltosFlightStats;
import org.altusmetrum.altoslib_14.AltosKML;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosRecordSet;
import org.altusmetrum.altoslib_14.AltosReplayReader;
import org.altusmetrum.altoslib_14.AltosTelemetryReader;
import org.altusmetrum.altoslib_14.AltosWriter;
import org.altusmetrum.altosuilib_14.AltosCSVUI;
import org.altusmetrum.altosuilib_14.AltosDataChooser;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosEepromGrapher;
import org.altusmetrum.altosuilib_14.AltosEepromManage;
import org.altusmetrum.altosuilib_14.AltosFlashUI;
import org.altusmetrum.altosuilib_14.AltosScanUI;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIMapPreload;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.AltosUSBDevice;
import org.altusmetrum.altosuilib_14.AltosVoice;

public class AltosUI
extends AltosUIFrame
implements AltosEepromGrapher {
    public AltosVoice voice = new AltosVoice();
    Container pane;
    GridBagLayout gridbag;
    static final int process_none = 0;
    static final int process_csv = 1;
    static final int process_kml = 2;
    static final int process_graph = 3;
    static final int process_replay = 4;
    static final int process_summary = 5;
    static final int process_oneline = 6;

    public static boolean load_library(Frame frame) {
        if (!Altos.load_library()) {
            JOptionPane.showMessageDialog(frame, String.format("No AltOS library in \"%s\"", System.getProperty("java.library.path", "<undefined>")), "Cannot load device access library", 0);
            return false;
        }
        return true;
    }

    void telemetry_window(AltosDevice altosDevice) {
        try {
            AltosTelemetryReader altosTelemetryReader = new AltosTelemetryReader(new AltosSerial(altosDevice));
            if (altosTelemetryReader != null) {
                new AltosFlightUI(this.voice, altosTelemetryReader, altosDevice.getSerial());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, fileNotFoundException.getMessage(), String.format("Cannot open %s", altosDevice.toShortString()), 0);
        }
        catch (AltosSerialInUseException altosSerialInUseException) {
            JOptionPane.showMessageDialog(this, String.format("Device \"%s\" already in use", altosDevice.toShortString()), "Device in use", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, String.format("Unknown I/O error on %s", altosDevice.toShortString()), "Unknown I/O error", 0);
        }
        catch (TimeoutException timeoutException) {
            JOptionPane.showMessageDialog(this, String.format("Timeout on %s", altosDevice.toShortString()), "Timeout error", 0);
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(this, String.format("Interrupted %s", altosDevice.toShortString()), "Interrupted exception", 0);
        }
    }

    @Override
    public void scan_device_selected(AltosDevice altosDevice) {
        this.telemetry_window(altosDevice);
    }

    JButton addButton(int n, int n2, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JButton jButton = new JButton(string);
        this.gridbag.setConstraints(jButton, gridBagConstraints);
        this.add((Component)jButton, gridBagConstraints);
        return jButton;
    }

    @Override
    public void macosx_file_handler(String string) {
        AltosUI.process_graph(null, new File(string));
    }

    @Override
    public void macosx_quit_handler() {
        System.exit(0);
    }

    @Override
    public void macosx_preferences_handler() {
        this.ConfigureAltosUI();
    }

    public AltosUI() {
        AltosUI.load_library(null);
        this.register_for_macosx_events();
        AltosUIPreferences.set_component(this);
        this.pane = this.getContentPane();
        this.gridbag = new GridBagLayout();
        this.pane.setLayout(this.gridbag);
        JButton jButton = this.addButton(0, 0, "Monitor Flight");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.ConnectToDevice();
            }
        });
        jButton.setToolTipText("Connect to TeleDongle and monitor telemetry");
        jButton = this.addButton(1, 0, "Save Flight Data");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.SaveFlightData();
            }
        });
        jButton.setToolTipText("Download and/or delete flight data from an altimeter");
        jButton = this.addButton(2, 0, "Replay Flight");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.Replay();
            }
        });
        jButton.setToolTipText("Watch an old flight in real-time");
        jButton = this.addButton(3, 0, "Graph Data");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.GraphData();
            }
        });
        jButton.setToolTipText("Present flight data in a graph and table of statistics");
        jButton = this.addButton(4, 0, "Export Data");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.ExportData();
            }
        });
        jButton.setToolTipText("Convert flight data for a spreadsheet or GoogleEarth");
        jButton = this.addButton(0, 1, "Configure Altimeter");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.ConfigureTeleMetrum();
            }
        });
        jButton.setToolTipText("Set flight, storage and communication parameters");
        jButton = this.addButton(1, 1, "Configure AltosUI");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.ConfigureAltosUI();
            }
        });
        jButton.setToolTipText("Global AltosUI settings");
        jButton = this.addButton(2, 1, "Configure Ground Station");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.ConfigureTeleDongle();
            }
        });
        jButton = this.addButton(3, 1, "Flash Image");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.FlashImage();
            }
        });
        jButton.setToolTipText("Replace the firmware in any AltusMetrum product");
        jButton = this.addButton(4, 1, "Fire Igniter");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.FireIgniter();
            }
        });
        jButton.setToolTipText("Remote control of igniters for deployment testing");
        jButton = this.addButton(0, 2, "Scan Channels");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.ScanChannels();
            }
        });
        jButton.setToolTipText("Find what channel an altimeter is sending telemetry on");
        jButton = this.addButton(1, 2, "Load Maps");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.LoadMaps();
            }
        });
        jButton.setToolTipText("Download satellite images for off-line flight monitoring");
        jButton = this.addButton(2, 2, "Monitor Idle");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUI.this.IdleMonitor();
            }
        });
        jButton.setToolTipText("Check flight readiness of altimeter in idle mode");
        jButton = this.addButton(4, 2, "Quit");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jButton.setToolTipText("Close all active windows and terminate AltosUI");
        this.setTitle("AltOS");
        this.pane.doLayout();
        this.pane.validate();
        this.doLayout();
        this.validate();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setLocationByPlatform(false);
        this.setVisible(true);
    }

    private void ConnectToDevice() {
        AltosDevice altosDevice = AltosDeviceUIDialog.show(this, 65537);
        if (altosDevice != null) {
            this.telemetry_window(altosDevice);
        }
    }

    void ConfigureCallsign() {
        String string = JOptionPane.showInputDialog(this, "Configure Callsign", AltosUIPreferences.callsign());
        if (string != null) {
            AltosUIPreferences.set_callsign(string);
        }
    }

    void ConfigureTeleMetrum() {
        new AltosConfigFC(this);
    }

    void ConfigureTeleDongle() {
        new AltosConfigTD(this);
    }

    void FlashImage() {
        AltosFlashUI.show(this);
    }

    void FireIgniter() {
        new AltosIgniteUI(this);
    }

    void ScanChannels() {
        new AltosScanUI(this, true);
    }

    void LoadMaps() {
        new AltosUIMapPreload(this);
    }

    void LaunchController() {
        new AltosLaunchUI(this);
    }

    private void Replay() {
        AltosDataChooser altosDataChooser = new AltosDataChooser(this);
        AltosRecordSet altosRecordSet = altosDataChooser.runDialog();
        if (altosRecordSet != null) {
            AltosReplayReader altosReplayReader = new AltosReplayReader(altosRecordSet, altosDataChooser.file());
            new AltosFlightUI(this.voice, altosReplayReader);
        }
    }

    @Override
    public void graph_flights(AltosEepromList altosEepromList) {
        for (AltosEepromLog altosEepromLog : altosEepromList) {
            if (!altosEepromLog.graph_selected || altosEepromLog.file == null) continue;
            AltosUI.process_graph(this, altosEepromLog.file);
        }
    }

    private void SaveFlightData() {
        new AltosEepromManage(this, this, 65536);
    }

    private static AltosFlightSeries make_series(AltosRecordSet altosRecordSet) {
        AltosFlightSeries altosFlightSeries = new AltosFlightSeries(altosRecordSet.cal_data());
        altosRecordSet.capture_series(altosFlightSeries);
        altosFlightSeries.finish();
        return altosFlightSeries;
    }

    private void ExportData() {
        AltosDataChooser altosDataChooser = new AltosDataChooser(this);
        AltosRecordSet altosRecordSet = altosDataChooser.runDialog();
        if (altosRecordSet == null) {
            return;
        }
        AltosFlightSeries altosFlightSeries = AltosUI.make_series(altosRecordSet);
        new AltosCSVUI(this, altosFlightSeries, altosDataChooser.file());
    }

    private static boolean graph_file(AltosUI altosUI, AltosRecordSet altosRecordSet, File file) {
        if (altosRecordSet == null) {
            return false;
        }
        if (!altosRecordSet.valid()) {
            JOptionPane.showMessageDialog(altosUI, String.format("Failed to parse file %s", file), "Graph Failed", 0);
            return false;
        }
        try {
            new AltosGraphUI(altosRecordSet, file);
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private void GraphData() {
        AltosDataChooser altosDataChooser = new AltosDataChooser(this);
        AltosRecordSet altosRecordSet = altosDataChooser.runDialog();
        AltosUI.graph_file(this, altosRecordSet, altosDataChooser.file());
    }

    private void ConfigureAltosUI() {
        new AltosConfigureUI(this, this.voice);
    }

    private void IdleMonitor() {
        try {
            new AltosIdleMonitorUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static AltosWriter open_csv(File file) {
        try {
            return new AltosCSV(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.printf("%s\n", fileNotFoundException.getMessage());
            return null;
        }
    }

    static AltosWriter open_kml(File file) {
        try {
            return new AltosKML(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.printf("%s\n", fileNotFoundException.getMessage());
            return null;
        }
    }

    static AltosRecordSet record_set(File file) {
        try {
            return AltosLib.record_set(file);
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string == null) {
                string = String.format("%s (I/O error)", file.toString());
            }
            System.err.printf("%s: %s\n", file.toString(), string);
            return null;
        }
    }

    static boolean process_csv(File file) {
        AltosRecordSet altosRecordSet = AltosUI.record_set(file);
        if (altosRecordSet == null) {
            return false;
        }
        File file2 = Altos.replace_extension(file, ".csv");
        System.out.printf("Processing \"%s\" to \"%s\"\n", file, file2);
        if (file.equals(file2)) {
            System.out.printf("Not processing '%s'\n", file);
            return false;
        }
        AltosWriter altosWriter = AltosUI.open_csv(file2);
        if (altosWriter == null) {
            return false;
        }
        AltosFlightSeries altosFlightSeries = AltosUI.make_series(altosRecordSet);
        altosWriter.write(altosFlightSeries);
        altosWriter.close();
        return true;
    }

    static boolean process_kml(File file) {
        AltosRecordSet altosRecordSet = AltosUI.record_set(file);
        if (altosRecordSet == null) {
            return false;
        }
        File file2 = Altos.replace_extension(file, ".kml");
        System.out.printf("Processing \"%s\" to \"%s\"\n", file, file2);
        if (file.equals(file2)) {
            System.out.printf("Not processing '%s'\n", file);
            return false;
        }
        AltosWriter altosWriter = AltosUI.open_kml(file2);
        if (altosWriter == null) {
            return false;
        }
        AltosFlightSeries altosFlightSeries = AltosUI.make_series(altosRecordSet);
        altosFlightSeries.finish();
        altosWriter.write(altosFlightSeries);
        altosWriter.close();
        return true;
    }

    static AltosReplayReader replay_file(File file) {
        AltosRecordSet altosRecordSet = AltosUI.record_set(file);
        if (altosRecordSet == null) {
            return null;
        }
        return new AltosReplayReader(altosRecordSet, file);
    }

    static boolean process_replay(File file) {
        AltosReplayReader altosReplayReader = AltosUI.replay_file(file);
        if (altosReplayReader == null) {
            return false;
        }
        AltosFlightUI altosFlightUI = new AltosFlightUI(new AltosVoice(), altosReplayReader);
        return true;
    }

    static boolean process_graph(AltosUI altosUI, File file) {
        AltosRecordSet altosRecordSet = AltosUI.record_set(file);
        return AltosUI.graph_file(altosUI, altosRecordSet, file);
    }

    static boolean process_summary(File file) {
        AltosRecordSet altosRecordSet = AltosUI.record_set(file);
        if (altosRecordSet == null) {
            return false;
        }
        System.out.printf("%s:\n", file.toString());
        AltosFlightSeries altosFlightSeries = AltosUI.make_series(altosRecordSet);
        AltosFlightStats altosFlightStats = new AltosFlightStats(altosFlightSeries);
        if (altosFlightStats.serial != Integer.MAX_VALUE) {
            System.out.printf("Serial:       %5d\n", altosFlightStats.serial);
        }
        if (altosFlightStats.flight != Integer.MAX_VALUE) {
            System.out.printf("Flight:       %5d\n", altosFlightStats.flight);
        }
        if (altosFlightStats.year != Integer.MAX_VALUE) {
            System.out.printf("Date:    %04d-%02d-%02d\n", altosFlightStats.year, altosFlightStats.month, altosFlightStats.day);
        }
        if (altosFlightStats.hour != Integer.MAX_VALUE) {
            System.out.printf("Time:      %02d:%02d:%02d UTC\n", altosFlightStats.hour, altosFlightStats.minute, altosFlightStats.second);
        }
        if (altosFlightStats.max_height != 2.147483647E9) {
            System.out.printf("Max height:  %6.0f m    %6.0f ft\n", altosFlightStats.max_height, AltosConvert.meters_to_feet(altosFlightStats.max_height));
        }
        if (altosFlightStats.max_speed != 2.147483647E9) {
            System.out.printf("Max speed:   %6.0f m/s  %6.0f ft/s  %6.4f Mach\n", altosFlightStats.max_speed, AltosConvert.meters_to_feet(altosFlightStats.max_speed), AltosConvert.meters_to_mach(altosFlightStats.max_speed));
        }
        if (altosFlightStats.max_acceleration != 2.147483647E9) {
            System.out.printf("Max accel:   %6.0f m/s\u00b2 %6.0f ft/s\u00b2 %6.2f g\n", altosFlightStats.max_acceleration, AltosConvert.meters_to_feet(altosFlightStats.max_acceleration), AltosConvert.meters_to_g(altosFlightStats.max_acceleration));
        }
        if (altosFlightStats.state_speed[6] != 2.147483647E9) {
            System.out.printf("Drogue rate: %6.0f m/s  %6.0f ft/s\n", altosFlightStats.state_speed[6], AltosConvert.meters_to_feet(altosFlightStats.state_speed[6]));
        }
        if (altosFlightStats.state_speed[7] != 2.147483647E9) {
            System.out.printf("Main rate:   %6.0f m/s  %6.0f ft/s\n", altosFlightStats.state_speed[7], AltosConvert.meters_to_feet(altosFlightStats.state_speed[7]));
        }
        if (altosFlightStats.landed_time != 2.147483647E9 && altosFlightStats.boost_time != 2.147483647E9 && altosFlightStats.landed_time > altosFlightStats.boost_time) {
            System.out.printf("Flight time: %6.0f s\n", altosFlightStats.landed_time - altosFlightStats.boost_time);
        }
        System.out.printf("\n", new Object[0]);
        return true;
    }

    static boolean process_oneline(File file) {
        AltosRecordSet altosRecordSet = AltosUI.record_set(file);
        if (altosRecordSet == null) {
            return false;
        }
        System.out.printf("%s", file.toString());
        AltosFlightSeries altosFlightSeries = AltosUI.make_series(altosRecordSet);
        AltosFlightStats altosFlightStats = new AltosFlightStats(altosFlightSeries);
        if (altosFlightStats.max_height != 2.147483647E9) {
            System.out.printf(" height  %6.0f m", altosFlightStats.max_height);
        }
        if (altosFlightStats.max_speed != 2.147483647E9) {
            System.out.printf(" speed   %6.0f m/s", altosFlightStats.max_speed);
        }
        if (altosFlightStats.state_enter_speed[6] != 2.147483647E9) {
            System.out.printf(" drogue-deploy   %6.0f m/s", altosFlightStats.state_enter_speed[6]);
        }
        if (altosFlightStats.max_acceleration != 2.147483647E9) {
            System.out.printf(" accel   %6.0f m/s\u00b2", altosFlightStats.max_acceleration);
        }
        System.out.printf("\n", new Object[0]);
        return true;
    }

    public static void help(int n) {
        System.out.printf("Usage: altosui [OPTION]... [FILE]...\n", new Object[0]);
        System.out.printf("  Options:\n", new Object[0]);
        System.out.printf("    --replay <filename>\t\trelive the glory of past flights \n", new Object[0]);
        System.out.printf("    --graph <filename>\t\tgraph a flight\n", new Object[0]);
        System.out.printf("    --summary <filename>\t\tText summary of a flight\n", new Object[0]);
        System.out.printf("    --oneline <filename>\t\tOne line summary of a flight\n", new Object[0]);
        System.out.printf("    --csv\tgenerate comma separated output for spreadsheets, etc\n", new Object[0]);
        System.out.printf("    --kml\tgenerate KML output for use with Google Earth\n", new Object[0]);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        AltosUI.load_library(null);
        try {
            UIManager.setLookAndFeel(AltosUIPreferences.look_and_feel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        AltosUI altosUI = null;
        if (stringArray.length == 0) {
            altosUI = new AltosUI();
            List<AltosDevice> list = AltosUSBDevice.list(65537);
            if (list != null) {
                for (AltosDevice altosDevice : list) {
                    altosUI.telemetry_window(altosDevice);
                }
            }
        } else {
            int n2 = 0;
            block12: for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("--help")) {
                    AltosUI.help(0);
                    continue;
                }
                if (stringArray[i].equals("--replay")) {
                    n2 = 4;
                    continue;
                }
                if (stringArray[i].equals("--kml")) {
                    n2 = 2;
                    continue;
                }
                if (stringArray[i].equals("--csv")) {
                    n2 = 1;
                    continue;
                }
                if (stringArray[i].equals("--graph")) {
                    n2 = 3;
                    continue;
                }
                if (stringArray[i].equals("--summary")) {
                    n2 = 5;
                    continue;
                }
                if (stringArray[i].equals("--oneline")) {
                    n2 = 6;
                    continue;
                }
                if (stringArray[i].startsWith("--")) {
                    AltosUI.help(1);
                    continue;
                }
                File file = new File(stringArray[i]);
                switch (n2) {
                    case 0: {
                        if (altosUI == null) {
                            altosUI = new AltosUI();
                        }
                    }
                    case 3: {
                        if (AltosUI.process_graph(null, file)) continue block12;
                        ++n;
                        continue block12;
                    }
                    case 4: {
                        if (AltosUI.process_replay(file)) continue block12;
                        ++n;
                        continue block12;
                    }
                    case 2: {
                        if (AltosUI.process_kml(file)) continue block12;
                        ++n;
                        continue block12;
                    }
                    case 1: {
                        if (AltosUI.process_csv(file)) continue block12;
                        ++n;
                        continue block12;
                    }
                    case 5: {
                        if (AltosUI.process_summary(file)) continue block12;
                        ++n;
                        continue block12;
                    }
                    case 6: {
                        if (AltosUI.process_oneline(file)) continue block12;
                        ++n;
                    }
                }
            }
        }
        if (n != 0) {
            System.exit(n);
        }
    }
}

