/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.AltosLaunch;
import altosui.FireButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosLaunchUI
extends AltosUIDialog
implements ActionListener {
    AltosDevice device;
    JFrame owner;
    JLabel label;
    int radio_channel;
    JLabel radio_channel_label;
    JTextField radio_channel_text;
    int launcher_serial;
    JLabel launcher_serial_label;
    JTextField launcher_serial_text;
    int launcher_channel = AltosUIPreferences.launcher_channel();
    JLabel launcher_channel_label;
    JTextField launcher_channel_text;
    JLabel armed_label;
    JLabel armed_status_label;
    JLabel igniter;
    JLabel igniter_status_label;
    JToggleButton arm;
    FireButton fire;
    Timer arm_timer;
    Timer fire_timer;
    boolean firing;
    boolean armed;
    int armed_status;
    int igniter_status;
    int rssi;
    static final int arm_timeout = 1000;
    static final int fire_timeout = 250;
    int armed_count;
    LinkedBlockingQueue<String> command_queue;
    boolean getting_status = false;

    void launch_exception(Exception exception) {
        if (exception instanceof FileNotFoundException) {
            JOptionPane.showMessageDialog(this.owner, ((FileNotFoundException)exception).getMessage(), "Cannot open target device", 0);
        } else if (exception instanceof AltosSerialInUseException) {
            JOptionPane.showMessageDialog(this.owner, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
        } else if (exception instanceof IOException) {
            IOException iOException = (IOException)exception;
            JOptionPane.showMessageDialog(this.owner, this.device.toShortString(), iOException.getLocalizedMessage(), 0);
        } else {
            JOptionPane.showMessageDialog(this.owner, String.format("Connection to \"%s\" failed", this.device.toShortString()), "Connection Failed", 0);
        }
        this.close();
    }

    void launch_reply(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("remote set")) {
            this.poll_launch_status();
        }
        if (string.equals("status")) {
            this.set_launch_status();
        }
    }

    void set_arm_text() {
        if (this.arm.isSelected()) {
            this.arm.setText(String.format("%d", this.armed_count));
        } else {
            this.arm.setText("Arm");
        }
    }

    void start_arm_timer() {
        this.armed_count = 30;
        this.set_arm_text();
    }

    void stop_arm_timer() {
        this.armed_count = 0;
        this.armed = false;
        this.arm.setSelected(false);
        this.fire.setEnabled(false);
        this.set_arm_text();
    }

    void cancel() {
        this.fire.setEnabled(false);
        this.firing = false;
        this.stop_arm_timer();
    }

    void send_command(String string) {
        try {
            this.command_queue.put(string);
        }
        catch (Exception exception) {
            this.launch_exception(exception);
        }
    }

    void set_launch_status() {
        this.getting_status = false;
        this.armed_status_label.setText(String.format("\"%s\"", AltosLaunch.status_string(this.armed_status)));
        this.igniter_status_label.setText(String.format("\"%s\"", AltosLaunch.status_string(this.igniter_status)));
    }

    void poll_launch_status() {
        if (!(this.getting_status || this.firing || this.armed)) {
            this.getting_status = true;
            this.send_command("get_status");
        }
    }

    void fired() {
        this.firing = false;
        this.cancel();
    }

    void close() {
        this.send_command("quit");
        this.arm_timer.stop();
        this.setVisible(false);
        this.dispose();
    }

    void tick_arm_timer() {
        if (this.armed_count > 0) {
            --this.armed_count;
            if (this.armed_count <= 0) {
                this.armed_count = 0;
                this.cancel();
            } else if (!this.firing) {
                this.send_command("arm");
                this.set_arm_text();
            }
        }
        this.poll_launch_status();
    }

    void arm() {
        if (this.arm.isSelected()) {
            this.fire.setEnabled(true);
            this.start_arm_timer();
            if (!this.firing) {
                this.send_command("arm");
            }
            this.armed = true;
        } else {
            this.cancel();
        }
    }

    void fire_more() {
        if (this.firing) {
            this.send_command("fire");
        }
    }

    void fire_down() {
        if (this.arm.isEnabled() && this.arm.isSelected() && this.armed_count > 0) {
            this.firing = true;
            this.fire_more();
            this.fire_timer.restart();
        }
    }

    void fire_up() {
        this.firing = false;
        this.fire_timer.stop();
    }

    void set_radio() {
        try {
            this.radio_channel = Integer.parseInt(this.radio_channel_text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.radio_channel_text.setText(String.format("%d", this.radio_channel));
        }
    }

    void set_serial() {
        try {
            this.launcher_serial = Integer.parseInt(this.launcher_serial_text.getText());
            AltosUIPreferences.set_launcher_serial(this.launcher_serial);
            this.send_command("set_remote");
        }
        catch (NumberFormatException numberFormatException) {
            this.launcher_serial_text.setText(String.format("%d", this.launcher_serial));
        }
    }

    void set_channel() {
        try {
            this.launcher_channel = Integer.parseInt(this.launcher_channel_text.getText());
            AltosUIPreferences.set_launcher_serial(this.launcher_channel);
            this.send_command("set_remote");
        }
        catch (NumberFormatException numberFormatException) {
            this.launcher_channel_text.setText(String.format("%d", this.launcher_channel));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("armed") || string.equals("igniter")) {
            this.stop_arm_timer();
        }
        if (string.equals("arm")) {
            this.arm();
        }
        if (string.equals("tick_arm")) {
            this.tick_arm_timer();
        }
        if (string.equals("close")) {
            this.close();
        }
        if (string.equals("fire_down")) {
            this.fire_down();
        }
        if (string.equals("fire_up")) {
            this.fire_up();
        }
        if (string.equals("tick_fire")) {
            this.fire_more();
        }
        if (string.equals("new_serial")) {
            this.set_serial();
        }
        if (string.equals("new_channel")) {
            this.set_channel();
        }
    }

    private boolean open() {
        this.command_queue = new LinkedBlockingQueue();
        this.device = AltosDeviceUIDialog.show(this.owner, 65536);
        if (this.device != null) {
            LaunchHandler launchHandler = new LaunchHandler(this.owner);
            Thread thread = new Thread(launchHandler);
            thread.start();
            return true;
        }
        return false;
    }

    public AltosLaunchUI(JFrame jFrame) {
        this.launcher_serial = AltosUIPreferences.launcher_serial();
        this.owner = jFrame;
        this.armed_status = -1;
        this.igniter_status = -1;
        if (!this.open()) {
            return;
        }
        Container container = this.getScrollablePane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(4, 4, 4, 4);
        this.arm_timer = new Timer(1000, this);
        this.arm_timer.setActionCommand("tick_arm");
        this.arm_timer.restart();
        this.fire_timer = new Timer(250, this);
        this.fire_timer.setActionCommand("tick_fire");
        this.owner = jFrame;
        container.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        this.label = new JLabel("Launch Controller");
        container.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.launcher_serial_label = new JLabel("Launcher Serial");
        container.add((Component)this.launcher_serial_label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.launcher_serial_text = new JTextField(7);
        this.launcher_serial_text.setText(String.format("%d", this.launcher_serial));
        this.launcher_serial_text.setActionCommand("new_serial");
        this.launcher_serial_text.addActionListener(this);
        container.add((Component)this.launcher_serial_text, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.launcher_channel_label = new JLabel("Launcher Channel");
        container.add((Component)this.launcher_channel_label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.launcher_channel_text = new JTextField(7);
        this.launcher_channel_text.setText(String.format("%d", this.launcher_channel));
        this.launcher_channel_text.setActionCommand("new_channel");
        this.launcher_channel_text.addActionListener(this);
        container.add((Component)this.launcher_channel_text, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.armed_label = new JLabel("Armed");
        container.add((Component)this.armed_label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.armed_status_label = new JLabel();
        container.add((Component)this.armed_status_label, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.igniter = new JLabel("Igniter");
        container.add((Component)this.igniter, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.igniter_status_label = new JLabel();
        container.add((Component)this.igniter_status_label, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        this.arm = new JToggleButton("Arm");
        container.add((Component)this.arm, gridBagConstraints);
        this.arm.addActionListener(this);
        this.arm.setActionCommand("arm");
        this.arm.setEnabled(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        this.fire = new FireButton("Fire");
        this.fire.setEnabled(false);
        container.add((Component)this.fire, gridBagConstraints);
        this.fire.addActionListener(this);
        this.fire.setActionCommand("fire");
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.addWindowListener(new ConfigListener(this));
        this.setVisible(true);
    }

    class ConfigListener
    extends WindowAdapter {
        AltosLaunchUI ui;

        public ConfigListener(AltosLaunchUI altosLaunchUI2) {
            this.ui = altosLaunchUI2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.ui.actionPerformed(new ActionEvent(windowEvent.getSource(), 1001, "close"));
        }
    }

    class LaunchHandler
    implements Runnable {
        AltosLaunch launch;
        JFrame owner;

        void send_exception(Exception exception) {
            final Exception exception2 = exception;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AltosLaunchUI.this.launch_exception(exception2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        @Override
        public void run() {
            try {
                this.launch = new AltosLaunch(AltosLaunchUI.this.device);
            }
            catch (Exception exception) {
                this.send_exception(exception);
                return;
            }
            this.launch.set_frame(this.owner);
            this.launch.set_remote(AltosLaunchUI.this.launcher_serial, AltosLaunchUI.this.launcher_channel);
            block4: while (true) {
                try {
                    while (true) {
                        String string = AltosLaunchUI.this.command_queue.take();
                        String string2 = null;
                        if (string.equals("get_status")) {
                            this.launch.status();
                            string2 = "status";
                            AltosLaunchUI.this.armed_status = this.launch.armed;
                            AltosLaunchUI.this.igniter_status = this.launch.igniter;
                            AltosLaunchUI.this.rssi = this.launch.rssi;
                        } else if (string.equals("set_remote")) {
                            this.launch.set_remote(AltosLaunchUI.this.launcher_serial, AltosLaunchUI.this.launcher_channel);
                            string2 = "remote set";
                        } else if (string.equals("arm")) {
                            this.launch.arm();
                            string2 = "armed";
                        } else if (string.equals("fire")) {
                            this.launch.fire();
                            string2 = "fired";
                        } else {
                            if (string.equals("quit")) {
                                this.launch.close();
                                break block4;
                            }
                            throw new ParseException(String.format("invalid command %s", string), 0);
                        }
                        final String string3 = string2;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                AltosLaunchUI.this.launch_reply(string3);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
                catch (Exception exception) {
                    this.send_exception(exception);
                    continue;
                }
                break;
            }
        }

        public LaunchHandler(JFrame jFrame) {
            this.owner = jFrame;
        }
    }
}

