/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.Altos;
import altosui.AltosFlightStatusUpdate;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;

public class AltosFlightStatus
extends JComponent
implements AltosFlightDisplay {
    GridBagLayout layout = new GridBagLayout();
    Call call;
    Serial serial;
    Flight flight;
    FlightState flight_state;
    RSSI rssi;
    LastPacket last_packet;
    AltosFlightStatusUpdate status_update;
    Timer timer;

    @Override
    public void reset() {
        this.call.reset();
        this.serial.reset();
        this.flight.reset();
        this.flight_state.reset();
        this.rssi.reset();
        this.last_packet.reset();
    }

    @Override
    public void font_size_changed(int n) {
        this.call.set_font();
        this.serial.set_font();
        this.flight.set_font();
        this.flight_state.set_font();
        this.rssi.set_font();
        this.last_packet.set_font();
    }

    @Override
    public void units_changed(boolean bl) {
    }

    @Override
    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        this.call.show(altosState, altosListenerState);
        this.serial.show(altosState, altosListenerState);
        this.flight.show(altosState, altosListenerState);
        this.flight_state.show(altosState, altosListenerState);
        this.rssi.show(altosState, altosListenerState);
        this.last_packet.show(altosState, altosListenerState);
        if (!altosListenerState.running) {
            this.stop();
        }
    }

    public int height() {
        Dimension dimension = this.layout.preferredLayoutSize(this);
        return dimension.height;
    }

    @Override
    public String getName() {
        return "Flight Status";
    }

    public void start(AltosFlightStatusUpdate altosFlightStatusUpdate) {
        this.status_update = altosFlightStatusUpdate;
        this.timer = new Timer(100, altosFlightStatusUpdate);
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public AltosFlightStatus() {
        this.setLayout(this.layout);
        this.call = new Call(this.layout, 0);
        this.serial = new Serial(this.layout, 1);
        this.flight = new Flight(this.layout, 2);
        this.flight_state = new FlightState(this.layout, 3);
        this.rssi = new RSSI(this.layout, 4);
        this.last_packet = new LastPacket(this.layout, 5);
    }

    class LastPacket
    extends FlightValue {
        long last_secs;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosListenerState.running) {
                long l = (System.currentTimeMillis() - altosState.received_time + 500L) / 1000L;
                if (l != this.last_secs) {
                    this.value.setText(String.format("%d", l));
                    this.last_secs = l;
                }
            } else {
                this.value.setText("done");
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_secs = -1L;
        }

        public LastPacket(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "Age");
            this.last_secs = -1L;
        }
    }

    class RSSI
    extends FlightValue {
        int last_rssi;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.rssi() != this.last_rssi) {
                this.show();
                this.value.setText(String.format("%d", altosState.rssi()));
                if (altosState.rssi == Integer.MAX_VALUE) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                }
                this.last_rssi = altosState.rssi();
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_rssi = 10000;
        }

        public RSSI(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "RSSI");
            this.last_rssi = 10000;
        }
    }

    class FlightState
    extends FlightValue {
        int last_state;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.state() != this.last_state) {
                if (altosState.state() == 10) {
                    this.hide();
                } else {
                    this.show();
                    this.value.setText(altosState.state_name());
                }
                this.last_state = altosState.state();
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_state = -1;
        }

        public FlightState(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "State");
            this.last_state = -1;
        }
    }

    class Flight
    extends FlightValue {
        int last_flight;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            AltosCalData altosCalData = altosState.cal_data();
            if (altosCalData.flight != this.last_flight) {
                this.show();
                if (altosCalData.flight == Integer.MAX_VALUE) {
                    this.value.setText("none");
                } else {
                    this.value.setText(String.format("%d", altosCalData.flight));
                }
                this.last_flight = altosCalData.flight;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_flight = -1;
        }

        public Flight(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "Flight");
            this.last_flight = -1;
        }
    }

    class Serial
    extends FlightValue {
        int last_serial;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            AltosCalData altosCalData = altosState.cal_data();
            if (altosCalData.serial != this.last_serial) {
                this.show();
                if (altosCalData.serial == Integer.MAX_VALUE) {
                    this.value.setText("none");
                } else {
                    this.value.setText(String.format("%d", altosCalData.serial));
                }
                this.last_serial = altosCalData.serial;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_serial = -1;
        }

        public Serial(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "Serial");
            this.last_serial = -1;
        }
    }

    class Call
    extends FlightValue {
        String last_call;

        boolean same_call(String string) {
            if (this.last_call == null) {
                return string == null;
            }
            return this.last_call.equals(string);
        }

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (!this.same_call(altosState.cal_data().callsign)) {
                this.show();
                this.value.setText(altosState.cal_data().callsign);
                if (altosState.cal_data().callsign == null) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                }
                this.last_call = altosState.cal_data().callsign;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_call = "";
        }

        public Call(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "Callsign");
            this.last_call = "";
        }
    }

    public abstract class FlightValue {
        JLabel label;
        JTextField value;

        void show() {
            this.label.setVisible(true);
            this.value.setVisible(true);
        }

        void hide() {
            this.label.setVisible(false);
            this.value.setVisible(false);
        }

        abstract void show(AltosState var1, AltosListenerState var2);

        void reset() {
            this.value.setText("");
        }

        void set_font() {
            this.label.setFont(Altos.status_font);
            this.value.setFont(Altos.status_font);
        }

        void setVisible(boolean bl) {
            this.label.setVisible(bl);
            this.value.setVisible(bl);
        }

        public FlightValue(GridBagLayout gridBagLayout, int n, String string) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.label = new JLabel(string);
            this.label.setFont(Altos.status_font);
            this.label.setHorizontalAlignment(0);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.label, gridBagConstraints);
            AltosFlightStatus.this.add(this.label);
            this.value = new JTextField("");
            this.value.setEditable(false);
            this.value.setFont(Altos.status_font);
            this.value.setHorizontalAlignment(0);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.value, gridBagConstraints);
            AltosFlightStatus.this.add(this.value);
        }
    }
}

