/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.altusmetrum.altosuilib_14.AltosBTKnown;
import org.altusmetrum.altosuilib_14.AltosBTManage;
import org.altusmetrum.altosuilib_14.AltosConfigFreqUI;
import org.altusmetrum.altosuilib_14.AltosUIConfigure;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.AltosVoice;

public class AltosConfigureUI
extends AltosUIConfigure
implements DocumentListener {
    AltosVoice voice;
    public JTextField callsign_value;
    public JComboBox<String> position_value;
    boolean has_bluetooth;
    static final String[] position_names = new String[]{"Top left", "Top", "Top right", "Left", "Center", "Right", "Bottom left", "Bottom", "Bottom right"};

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.callsign_value != null) {
            AltosUIPreferences.set_callsign(this.callsign_value.getText());
        }
    }

    @Override
    public void add_voice() {
        this.pane.add((Component)new JLabel("Voice"), this.constraints(0, 1));
        JRadioButton jRadioButton = new JRadioButton("Enable", AltosUIPreferences.voice());
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                boolean bl = jRadioButton.isSelected();
                AltosUIPreferences.set_voice(bl);
                if (bl) {
                    AltosConfigureUI.this.voice.speak_always("Enable voice.");
                } else {
                    AltosConfigureUI.this.voice.speak_always("Disable voice.");
                }
            }
        });
        this.pane.add((Component)jRadioButton, this.constraints(1, 1));
        jRadioButton.setToolTipText("Enable/Disable all audio in-flight announcements");
        JButton jButton = new JButton("Test Voice");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosConfigureUI.this.voice.speak("That's one small step for man; one giant leap for mankind.");
            }
        });
        this.pane.add((Component)jButton, this.constraints(2, 1));
        jButton.setToolTipText("Play a stock audio clip to check volume");
        ++this.row;
    }

    @Override
    public void add_callsign() {
        this.pane.add((Component)new JLabel("Callsign"), this.constraints(0, 1));
        this.callsign_value = new JTextField(AltosUIPreferences.callsign());
        this.callsign_value.getDocument().addDocumentListener(this);
        this.callsign_value.setToolTipText("Callsign sent in packet mode");
        this.pane.add((Component)this.callsign_value, this.constraints(1, 2, 1));
        ++this.row;
    }

    @Override
    public void add_bluetooth() {
        JButton jButton = new JButton("Manage Bluetooth");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosBTManage.show(AltosConfigureUI.this.owner, AltosBTKnown.bt_known());
            }
        });
        this.pane.add((Component)jButton, this.constraints(0, 2));
        this.has_bluetooth = true;
    }

    @Override
    public void add_frequencies() {
        JButton jButton = new JButton("Manage Frequencies");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosConfigFreqUI.show(AltosConfigureUI.this.owner);
            }
        });
        jButton.setToolTipText("Configure which values are shown in frequency menus");
        if (this.has_bluetooth) {
            this.pane.add((Component)jButton, this.constraints(2, 1));
        } else {
            this.pane.add((Component)jButton, this.constraints(0, 3));
        }
        ++this.row;
    }

    @Override
    public void add_position() {
        this.pane.add((Component)new JLabel("Menu position"), this.constraints(0, 1));
        this.position_value = new JComboBox<String>(position_names);
        this.position_value.setMaximumRowCount(position_names.length);
        int n = AltosUIPreferences.position();
        this.position_value.setSelectedIndex(n);
        this.position_value.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AltosConfigureUI.this.position_value.getSelectedIndex();
                AltosUIPreferences.set_position(n);
            }
        });
        this.pane.add(this.position_value, this.constraints(1, 2, 1));
        this.position_value.setToolTipText("Position of main AltosUI window");
        ++this.row;
    }

    public AltosConfigureUI(JFrame jFrame, AltosVoice altosVoice) {
        super(jFrame);
        this.voice = altosVoice;
    }
}

