/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.altusmetrum.altoslib_14.AltosFrequency;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUIFreqList;
import org.altusmetrum.altosuilib_14.AltosUIRateList;

public class AltosConfigTDUI
extends AltosUIDialog
implements ActionListener,
ItemListener,
DocumentListener {
    Container pane;
    Box box;
    JLabel product_label;
    JLabel version_label;
    JLabel serial_label;
    JLabel frequency_label;
    JLabel radio_calibration_label;
    JLabel radio_frequency_label;
    JLabel rate_label;
    public boolean dirty;
    JFrame owner;
    JLabel product_value;
    JLabel version_value;
    JLabel serial_value;
    AltosUIFreqList radio_frequency_value;
    JLabel radio_calibration_value;
    AltosUIRateList rate_value;
    JButton save;
    JButton reset;
    JButton reboot;
    JButton close;
    ActionListener listener;

    public AltosConfigTDUI(JFrame jFrame) {
        super(jFrame, "Configure TeleDongle", false);
        this.owner = jFrame;
        Insets insets = new Insets(4, 4, 4, 4);
        Insets insets2 = new Insets(4, 4, 4, 4);
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        this.product_label = new JLabel("Product:");
        this.pane.add((Component)this.product_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        this.product_value = new JLabel("");
        this.pane.add((Component)this.product_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.version_label = new JLabel("Software version:");
        this.pane.add((Component)this.version_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.version_value = new JLabel("");
        this.pane.add((Component)this.version_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.serial_label = new JLabel("Serial:");
        this.pane.add((Component)this.serial_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.serial_value = new JLabel("");
        this.pane.add((Component)this.serial_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.radio_frequency_label = new JLabel("Frequency:");
        this.pane.add((Component)this.radio_frequency_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.radio_frequency_value = new AltosUIFreqList();
        this.radio_frequency_value.addItemListener(this);
        this.pane.add((Component)this.radio_frequency_value, gridBagConstraints);
        this.radio_frequency_value.setToolTipText("Telemetry, RDF and packet frequency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.radio_calibration_label = new JLabel("RF Calibration:");
        this.pane.add((Component)this.radio_calibration_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.radio_calibration_value = new JLabel(String.format("%d", 1186611));
        this.pane.add((Component)this.radio_calibration_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.rate_label = new JLabel("Telemetry Rate:");
        this.pane.add((Component)this.rate_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.rate_value = new AltosUIRateList();
        this.pane.add((Component)this.rate_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        this.save = new JButton("Save");
        this.pane.add((Component)this.save, gridBagConstraints);
        this.save.addActionListener(this);
        this.save.setActionCommand("Save");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.reset = new JButton("Reset");
        this.pane.add((Component)this.reset, gridBagConstraints);
        this.reset.addActionListener(this);
        this.reset.setActionCommand("Reset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = insets;
        this.close = new JButton("Close");
        this.pane.add((Component)this.close, gridBagConstraints);
        this.close.addActionListener(this);
        this.close.setActionCommand("Close");
        this.addWindowListener(new ConfigListener(this));
    }

    public void make_visible() {
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }

    public boolean check_dirty(String string) {
        if (this.dirty) {
            Object[] objectArray = new Object[]{String.format("%s anyway", string), "Keep editing"};
            int n = JOptionPane.showOptionDialog(this, String.format("Configuration modified. %s anyway?", string), "Configuration Modified", -1, 2, null, objectArray, objectArray[1]);
            if (n != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ((string.equals("Close") || string.equals("Reboot")) && !this.check_dirty(string)) {
            return;
        }
        this.listener.actionPerformed(actionEvent);
        if (string.equals("Close") || string.equals("Reboot")) {
            this.setVisible(false);
            this.dispose();
        }
        this.dirty = false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.dirty = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.dirty = true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.dirty = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.dirty = true;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void set_product(String string) {
        this.radio_frequency_value.set_product(string);
        this.product_value.setText(string);
    }

    public void set_version(String string) {
        this.version_value.setText(string);
    }

    public void set_serial(int n) {
        this.radio_frequency_value.set_serial(n);
        this.serial_value.setText(String.format("%d", n));
    }

    public void set_radio_frequency(double d) {
        Object object;
        int n;
        for (n = 0; n < this.radio_frequency_value.getItemCount(); ++n) {
            object = (AltosFrequency)this.radio_frequency_value.getItemAt(n);
            if (!((AltosFrequency)object).close(d)) continue;
            this.radio_frequency_value.setSelectedIndex(n);
            return;
        }
        for (n = 0; n < this.radio_frequency_value.getItemCount(); ++n) {
            object = (AltosFrequency)this.radio_frequency_value.getItemAt(n);
            if (d < ((AltosFrequency)object).frequency) break;
        }
        object = String.format("%s serial %s", this.product_value.getText(), this.serial_value.getText());
        AltosFrequency altosFrequency = new AltosFrequency(d, (String)object);
        AltosPreferences.add_common_frequency(altosFrequency);
        this.radio_frequency_value.insertItemAt(altosFrequency, n);
        this.radio_frequency_value.setSelectedIndex(n);
    }

    public double radio_frequency() {
        return this.radio_frequency_value.frequency();
    }

    public void set_radio_calibration(int n) {
        this.radio_calibration_value.setText(String.format("%d", n));
    }

    public int telemetry_rate() {
        return this.rate_value.getSelectedIndex();
    }

    public void set_telemetry_rate(int n) {
        this.rate_value.setSelectedIndex(n);
    }

    public void set_clean() {
        this.dirty = false;
    }

    class ConfigListener
    extends WindowAdapter {
        AltosConfigTDUI ui;

        public ConfigListener(AltosConfigTDUI altosConfigTDUI2) {
            this.ui = altosConfigTDUI2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.ui.actionPerformed(new ActionEvent(windowEvent.getSource(), 1001, "Close"));
        }
    }
}

