/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.AltosConfigPyroUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.altusmetrum.altoslib_14.AltosConfigDataException;
import org.altusmetrum.altoslib_14.AltosConfigValues;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosPyro;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUIFreqList;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.AltosUIRateList;

public class AltosConfigFCUI
extends AltosUIDialog
implements ActionListener,
ItemListener,
DocumentListener,
AltosConfigValues,
AltosUnitsListener {
    Container pane;
    JLabel product_label;
    JLabel version_label;
    JLabel serial_label;
    JLabel main_deploy_label;
    JLabel apogee_delay_label;
    JLabel apogee_lockout_label;
    JLabel frequency_label;
    JLabel radio_calibration_label;
    JLabel radio_frequency_label;
    JLabel radio_enable_label;
    JLabel rate_label;
    JLabel aprs_interval_label;
    JLabel aprs_ssid_label;
    JLabel aprs_format_label;
    JLabel aprs_offset_label;
    JLabel flight_log_max_label;
    JLabel ignite_mode_label;
    JLabel pad_orientation_label;
    JLabel accel_plus_label;
    JLabel accel_minus_label;
    JLabel callsign_label;
    JLabel beep_label;
    JLabel tracker_motion_label;
    JLabel tracker_interval_label;
    public boolean dirty;
    JFrame owner;
    JLabel product_value;
    JLabel version_value;
    JLabel serial_value;
    JComboBox<String> main_deploy_value;
    JComboBox<String> apogee_delay_value;
    JComboBox<String> apogee_lockout_value;
    AltosUIFreqList radio_frequency_value;
    JLabel radio_calibration_value;
    JRadioButton radio_enable_value;
    AltosUIRateList rate_value;
    JComboBox<String> aprs_interval_value;
    JComboBox<Integer> aprs_ssid_value;
    JComboBox<String> aprs_format_value;
    JComboBox<Integer> aprs_offset_value;
    JComboBox<String> flight_log_max_value;
    JComboBox<String> ignite_mode_value;
    JComboBox<String> pad_orientation_value;
    JTextField accel_plus_value;
    JTextField accel_minus_value;
    JTextField callsign_value;
    JComboBox<String> beep_value;
    JComboBox<String> tracker_motion_value;
    JComboBox<String> tracker_interval_value;
    JButton pyro;
    JButton accel_cal;
    JButton save;
    JButton reset;
    JButton reboot;
    JButton close;
    AltosPyro[] pyros;
    double pyro_firing_time;
    ActionListener listener;
    static final String title = "Configure Flight Computer";
    static String[] main_deploy_values_m = new String[]{"100", "150", "200", "250", "300", "350", "400", "450", "500"};
    static String[] main_deploy_values_ft = new String[]{"250", "500", "750", "1000", "1250", "1500", "1750", "2000"};
    static String[] apogee_delay_values = new String[]{"0", "1", "2", "3", "4", "5"};
    static String[] apogee_lockout_values = new String[]{"0", "5", "10", "15", "20"};
    static String[] ignite_mode_values = new String[]{"Dual Deploy", "Redundant Apogee", "Redundant Main", "Separation & Apogee"};
    static String[] aprs_interval_values = new String[]{"Disabled", "2", "5", "10"};
    static Integer[] aprs_ssid_values = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    static Integer[] aprs_offset_values = new Integer[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18};
    static String[] beep_values = new String[]{"3750", "4000", "4250"};
    static String[] pad_orientation_values_radio = new String[]{"Antenna Up", "Antenna Down"};
    static String[] pad_orientation_values_no_radio = new String[]{"Beeper Up", "Beeper Down"};
    String[] pad_orientation_values;
    static String[] tracker_motion_values_m = new String[]{"2", "5", "10", "25"};
    static String[] tracker_motion_values_ft = new String[]{"5", "20", "50", "100"};
    static String[] tracker_interval_values = new String[]{"1", "2", "5", "10"};
    AltosConfigPyroUI pyro_ui;
    int flight_log_max_limit;
    int flight_log_max;

    boolean is_telemini_v1() {
        String string = this.product_value.getText();
        return string != null && string.startsWith("TeleMini-v1");
    }

    boolean is_telemini() {
        String string = this.product_value.getText();
        return string != null && string.startsWith("TeleMini");
    }

    boolean is_easymini() {
        String string = this.product_value.getText();
        return string != null && string.startsWith("EasyMini");
    }

    boolean is_telemetrum() {
        String string = this.product_value.getText();
        return string != null && string.startsWith("TeleMetrum");
    }

    boolean is_telemega() {
        String string = this.product_value.getText();
        return string != null && string.startsWith("TeleMega");
    }

    boolean is_easymega() {
        String string = this.product_value.getText();
        return string != null && string.startsWith("EasyMega");
    }

    boolean is_easytimer() {
        String string = this.product_value.getText();
        return string != null && string.startsWith("EasyTimer");
    }

    boolean has_radio() {
        return this.is_telemega() || this.is_telemetrum() || this.is_telemini();
    }

    void set_radio_enable_tool_tip() {
        if (this.radio_enable_value.isVisible()) {
            this.radio_enable_value.setToolTipText("Enable/Disable telemetry and RDF transmissions");
        } else {
            this.radio_enable_value.setToolTipText("Firmware version does not support disabling radio");
        }
    }

    void set_rate_tool_tip() {
        if (this.rate_value.isVisible()) {
            this.rate_value.setToolTipText("Select telemetry baud rate");
        } else {
            this.rate_value.setToolTipText("Firmware version does not support variable telemetry rates");
        }
    }

    void set_aprs_interval_tool_tip() {
        if (this.aprs_interval_value.isVisible()) {
            this.aprs_interval_value.setToolTipText("Enable APRS and set the interval between APRS reports");
        } else {
            this.aprs_interval_value.setToolTipText("Hardware doesn't support APRS");
        }
    }

    void set_aprs_ssid_tool_tip() {
        if (this.aprs_ssid_value.isVisible()) {
            this.aprs_ssid_value.setToolTipText("Set the APRS SSID (secondary station identifier)");
        } else if (this.aprs_ssid_value.isVisible()) {
            this.aprs_ssid_value.setToolTipText("Software version doesn't support setting the APRS SSID");
        } else {
            this.aprs_ssid_value.setToolTipText("Hardware doesn't support APRS");
        }
    }

    void set_aprs_format_tool_tip() {
        if (this.aprs_format_value.isVisible()) {
            this.aprs_format_value.setToolTipText("Set the APRS format (compressed/uncompressed)");
        } else if (this.aprs_format_value.isVisible()) {
            this.aprs_format_value.setToolTipText("Software version doesn't support setting the APRS format");
        } else {
            this.aprs_format_value.setToolTipText("Hardware doesn't support APRS");
        }
    }

    void set_aprs_offset_tool_tip() {
        if (this.aprs_offset_value.isVisible()) {
            this.aprs_offset_value.setToolTipText("Set the APRS offset from top of minute");
        } else if (this.aprs_offset_value.isVisible()) {
            this.aprs_offset_value.setToolTipText("Software version doesn't support setting the APRS offset");
        } else {
            this.aprs_offset_value.setToolTipText("Hardware doesn't support APRS");
        }
    }

    void set_flight_log_max_tool_tip() {
        if (this.flight_log_max_value.isVisible()) {
            this.flight_log_max_value.setToolTipText("Size reserved for each flight log (in kB)");
        } else if (this.is_telemini_v1()) {
            this.flight_log_max_value.setToolTipText("TeleMini-v1 stores only one flight");
        } else {
            this.flight_log_max_value.setToolTipText("Cannot set max value with flight logs in memory");
        }
    }

    void set_ignite_mode_tool_tip() {
        if (this.ignite_mode_value.isVisible()) {
            this.ignite_mode_value.setToolTipText("Select when igniters will be fired");
        } else {
            this.ignite_mode_value.setToolTipText("Older firmware could not select ignite mode");
        }
    }

    void set_pad_orientation_tool_tip() {
        if (this.pad_orientation_value.isVisible()) {
            this.pad_orientation_value.setToolTipText("How will the computer be mounted in the airframe");
        } else if (this.is_telemetrum()) {
            this.pad_orientation_value.setToolTipText("Older TeleMetrum firmware must fly antenna forward");
        } else if (this.is_telemini() || this.is_easymini()) {
            this.pad_orientation_value.setToolTipText("TeleMini and EasyMini don't care how they are mounted");
        } else if (this.is_easytimer()) {
            this.pad_orientation_value.setToolTipText("EasyTimer can be mounted in any of six orientations");
        } else {
            this.pad_orientation_value.setToolTipText("Can't select orientation");
        }
    }

    void set_pad_orientation_values() {
        String[] stringArray = this.has_radio() ? pad_orientation_values_radio : pad_orientation_values_no_radio;
        if (stringArray != this.pad_orientation_values) {
            int n = this.pad_orientation_value.getSelectedIndex();
            this.pad_orientation_value.removeAllItems();
            this.pad_orientation_values = stringArray;
            for (int i = 0; i < stringArray.length; ++i) {
                this.pad_orientation_value.addItem(this.pad_orientation_values[i]);
            }
            this.pad_orientation_value.setSelectedIndex(n);
        }
    }

    void set_accel_tool_tips() {
        if (this.accel_plus_value.isVisible()) {
            this.accel_plus_value.setToolTipText("Pad acceleration value in flight orientation");
            this.accel_minus_value.setToolTipText("Upside-down acceleration value");
        } else {
            this.accel_plus_value.setToolTipText("No accelerometer");
            this.accel_minus_value.setToolTipText("No accelerometer");
        }
    }

    void set_beep_tool_tip() {
        if (this.beep_value.isVisible()) {
            this.beep_value.setToolTipText("What frequency the beeper will sound at");
        } else {
            this.beep_value.setToolTipText("Older firmware could not select beeper frequency");
        }
    }

    public AltosConfigFCUI(JFrame jFrame, boolean bl) {
        super(jFrame, title, false);
        this.owner = jFrame;
        int n = 0;
        Insets insets = new Insets(4, 4, 4, 4);
        Insets insets2 = new Insets(4, 4, 4, 4);
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        this.product_label = new JLabel("Product:");
        this.pane.add((Component)this.product_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        this.product_value = new JLabel("");
        this.pane.add((Component)this.product_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.version_label = new JLabel("Software version:");
        this.pane.add((Component)this.version_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.version_value = new JLabel("");
        this.pane.add((Component)this.version_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.serial_label = new JLabel("Serial:");
        this.pane.add((Component)this.serial_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.serial_value = new JLabel("");
        this.pane.add((Component)this.serial_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.main_deploy_label = new JLabel(this.get_main_deploy_label());
        this.pane.add((Component)this.main_deploy_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.main_deploy_value = new JComboBox<String>(this.main_deploy_values());
        this.main_deploy_value.setEditable(true);
        this.main_deploy_value.addItemListener(this);
        this.pane.add(this.main_deploy_value, gridBagConstraints);
        this.main_deploy_value.setToolTipText("Height above pad altitude to fire main charge");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.apogee_delay_label = new JLabel("Apogee Delay(s):");
        this.pane.add((Component)this.apogee_delay_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.apogee_delay_value = new JComboBox<String>(apogee_delay_values);
        this.apogee_delay_value.setEditable(true);
        this.apogee_delay_value.addItemListener(this);
        this.pane.add(this.apogee_delay_value, gridBagConstraints);
        this.apogee_delay_value.setToolTipText("Delay after apogee before charge fires");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.apogee_lockout_label = new JLabel("Apogee Lockout(s):");
        this.pane.add((Component)this.apogee_lockout_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.apogee_lockout_value = new JComboBox<String>(apogee_lockout_values);
        this.apogee_lockout_value.setEditable(true);
        this.apogee_lockout_value.addItemListener(this);
        this.pane.add(this.apogee_lockout_value, gridBagConstraints);
        this.apogee_lockout_value.setToolTipText("Time after launch while apogee detection is locked out");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.radio_frequency_label = new JLabel("Frequency:");
        this.pane.add((Component)this.radio_frequency_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.radio_frequency_value = new AltosUIFreqList();
        this.radio_frequency_value.addItemListener(this);
        this.pane.add((Component)this.radio_frequency_value, gridBagConstraints);
        this.radio_frequency_value.setToolTipText("Telemetry, RDF and packet frequency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.radio_calibration_label = new JLabel("RF Calibration:");
        this.pane.add((Component)this.radio_calibration_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.radio_calibration_value = new JLabel(String.format("%d", 1186611));
        this.pane.add((Component)this.radio_calibration_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.radio_enable_label = new JLabel("Telemetry/RDF/APRS Enable:");
        this.pane.add((Component)this.radio_enable_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.radio_enable_value = new JRadioButton("Enabled");
        this.radio_enable_value.addItemListener(this);
        this.pane.add((Component)this.radio_enable_value, gridBagConstraints);
        this.set_radio_enable_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.rate_label = new JLabel("Telemetry baud rate:");
        this.pane.add((Component)this.rate_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.rate_value = new AltosUIRateList();
        this.rate_value.addItemListener(this);
        this.pane.add((Component)this.rate_value, gridBagConstraints);
        this.set_rate_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.aprs_interval_label = new JLabel("APRS Interval(s):");
        this.pane.add((Component)this.aprs_interval_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.aprs_interval_value = new JComboBox<String>(aprs_interval_values);
        this.aprs_interval_value.setEditable(true);
        this.aprs_interval_value.addItemListener(this);
        this.pane.add(this.aprs_interval_value, gridBagConstraints);
        this.set_aprs_interval_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.aprs_ssid_label = new JLabel("APRS SSID:");
        this.pane.add((Component)this.aprs_ssid_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.aprs_ssid_value = new JComboBox<Integer>(aprs_ssid_values);
        this.aprs_ssid_value.setEditable(false);
        this.aprs_ssid_value.addItemListener(this);
        this.aprs_ssid_value.setMaximumRowCount(aprs_ssid_values.length);
        this.pane.add(this.aprs_ssid_value, gridBagConstraints);
        this.set_aprs_ssid_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.aprs_format_label = new JLabel("APRS format:");
        this.pane.add((Component)this.aprs_format_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.aprs_format_value = new JComboBox<String>(AltosLib.ao_aprs_format_name);
        this.aprs_format_value.setEditable(false);
        this.aprs_format_value.addItemListener(this);
        this.aprs_format_value.setMaximumRowCount(AltosLib.ao_aprs_format_name.length);
        this.pane.add(this.aprs_format_value, gridBagConstraints);
        this.set_aprs_format_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.aprs_offset_label = new JLabel("APRS offset:");
        this.pane.add((Component)this.aprs_offset_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.aprs_offset_value = new JComboBox<Integer>(aprs_offset_values);
        this.aprs_offset_value.setEditable(false);
        this.aprs_offset_value.addItemListener(this);
        this.aprs_offset_value.setMaximumRowCount(aprs_offset_values.length);
        this.pane.add(this.aprs_offset_value, gridBagConstraints);
        this.set_aprs_offset_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.callsign_label = new JLabel("Callsign:");
        this.pane.add((Component)this.callsign_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.callsign_value = new JTextField(AltosUIPreferences.callsign());
        this.callsign_value.getDocument().addDocumentListener(this);
        this.pane.add((Component)this.callsign_value, gridBagConstraints);
        this.callsign_value.setToolTipText("Callsign reported in telemetry data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.flight_log_max_label = new JLabel("Maximum Flight Log Size (kB):");
        this.pane.add((Component)this.flight_log_max_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.flight_log_max_value = new JComboBox();
        this.flight_log_max_value.setEditable(true);
        this.flight_log_max_value.addItemListener(this);
        this.pane.add(this.flight_log_max_value, gridBagConstraints);
        this.set_flight_log_max_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.ignite_mode_label = new JLabel("Igniter Firing Mode:");
        this.pane.add((Component)this.ignite_mode_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.ignite_mode_value = new JComboBox<String>(ignite_mode_values);
        this.ignite_mode_value.setEditable(false);
        this.ignite_mode_value.addItemListener(this);
        this.pane.add(this.ignite_mode_value, gridBagConstraints);
        this.set_ignite_mode_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.pad_orientation_label = new JLabel("Pad Orientation:");
        this.pane.add((Component)this.pad_orientation_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.pad_orientation_values = pad_orientation_values_no_radio;
        this.pad_orientation_value = new JComboBox<String>(this.pad_orientation_values);
        this.pad_orientation_value.setEditable(false);
        this.pad_orientation_value.addItemListener(this);
        this.pane.add(this.pad_orientation_value, gridBagConstraints);
        this.set_pad_orientation_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.accel_plus_label = new JLabel("Accel Plus:");
        this.pane.add((Component)this.accel_plus_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.accel_plus_value = new JTextField(10);
        this.accel_plus_value.setEditable(true);
        this.accel_plus_value.getDocument().addDocumentListener(this);
        this.pane.add((Component)this.accel_plus_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.accel_minus_label = new JLabel("Accel Minus:");
        this.pane.add((Component)this.accel_minus_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.accel_minus_value = new JTextField(10);
        this.accel_minus_value.setEditable(true);
        this.accel_minus_value.getDocument().addDocumentListener(this);
        this.pane.add((Component)this.accel_minus_value, gridBagConstraints);
        this.set_accel_tool_tips();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.beep_label = new JLabel("Beeper Frequency:");
        this.pane.add((Component)this.beep_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.beep_value = new JComboBox<String>(beep_values);
        this.beep_value.setEditable(true);
        this.beep_value.addItemListener(this);
        this.pane.add(this.beep_value, gridBagConstraints);
        this.set_beep_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.tracker_motion_label = new JLabel(this.get_tracker_motion_label());
        this.pane.add((Component)this.tracker_motion_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.tracker_motion_value = new JComboBox<String>(this.tracker_motion_values());
        this.tracker_motion_value.setEditable(true);
        this.tracker_motion_value.addItemListener(this);
        this.pane.add(this.tracker_motion_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.tracker_interval_label = new JLabel("Position Reporting Interval(s):");
        this.pane.add((Component)this.tracker_interval_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.tracker_interval_value = new JComboBox<String>(tracker_interval_values);
        this.tracker_interval_value.setEditable(true);
        this.tracker_interval_value.addItemListener(this);
        this.pane.add(this.tracker_interval_value, gridBagConstraints);
        this.set_tracker_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.pyro = new JButton("Configure Pyro Channels");
        this.pane.add((Component)this.pyro, gridBagConstraints);
        this.pyro.addActionListener(this);
        this.pyro.setActionCommand("Pyro");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.accel_cal = new JButton("Calibrate Accelerometer");
        this.pane.add((Component)this.accel_cal, gridBagConstraints);
        this.accel_cal.addActionListener(this);
        this.accel_cal.setActionCommand("Accel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        this.save = new JButton("Save");
        this.pane.add((Component)this.save, gridBagConstraints);
        this.save.addActionListener(this);
        this.save.setActionCommand("Save");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.reset = new JButton("Reset");
        this.pane.add((Component)this.reset, gridBagConstraints);
        this.reset.addActionListener(this);
        this.reset.setActionCommand("Reset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.reboot = new JButton("Reboot");
        this.pane.add((Component)this.reboot, gridBagConstraints);
        this.reboot.addActionListener(this);
        this.reboot.setActionCommand("Reboot");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = insets;
        this.close = new JButton("Close");
        this.pane.add((Component)this.close, gridBagConstraints);
        this.close.addActionListener(this);
        this.close.setActionCommand("Close");
        this.addWindowListener(new ConfigListener(this));
        AltosPreferences.register_units_listener(this);
    }

    public void make_visible() {
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }

    public boolean check_dirty(String string) {
        if (this.dirty) {
            Object[] objectArray = new Object[]{String.format("%s anyway", string), "Keep editing"};
            int n = JOptionPane.showOptionDialog(this, String.format("Configuration modified. %s anyway?", string), "Configuration Modified", -1, 2, null, objectArray, objectArray[1]);
            if (n != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void set_dirty() {
        this.dirty = true;
        this.setTitle("Configure Flight Computer (modified)");
        this.save.setEnabled(true);
    }

    @Override
    public void set_clean() {
        this.dirty = false;
        this.setTitle(title);
        this.save.setEnabled(false);
    }

    @Override
    public void dispose() {
        if (this.pyro_ui != null) {
            this.pyro_ui.dispose();
        }
        AltosPreferences.unregister_units_listener(this);
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Pyro")) {
            if (this.pyro_ui == null && this.pyros != null) {
                this.pyro_ui = new AltosConfigPyroUI(this, this.pyros, this.pyro_firing_time);
            }
            if (this.pyro_ui != null) {
                this.pyro_ui.make_visible();
            }
            return;
        }
        if ((string.equals("Close") || string.equals("Reboot")) && !this.check_dirty(string)) {
            return;
        }
        if (string.equals("Save")) {
            this.save.setEnabled(false);
        }
        this.listener.actionPerformed(actionEvent);
        if (string.equals("Close") || string.equals("Reboot")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.set_dirty();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.set_dirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.set_dirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.set_dirty();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    @Override
    public void set_product(String string) {
        this.radio_frequency_value.set_product(string);
        this.product_value.setText(string);
        this.set_pad_orientation_tool_tip();
        this.set_accel_tool_tips();
        this.set_flight_log_max_tool_tip();
        this.set_pad_orientation_values();
    }

    @Override
    public void set_version(String string) {
        this.version_value.setText(string);
    }

    @Override
    public void set_serial(int n) {
        this.radio_frequency_value.set_serial(n);
        this.serial_value.setText(String.format("%d", n));
    }

    @Override
    public void set_altitude_32(int n) {
    }

    @Override
    public void set_main_deploy(int n) {
        if (n != Integer.MAX_VALUE) {
            this.main_deploy_value.setSelectedItem(AltosConvert.height.say(n));
        }
        this.main_deploy_value.setVisible(n != Integer.MAX_VALUE);
        this.main_deploy_label.setVisible(n != Integer.MAX_VALUE);
    }

    @Override
    public int main_deploy() throws AltosConfigDataException {
        String string = this.main_deploy_value.getSelectedItem().toString();
        try {
            return (int)(AltosConvert.height.parse_locale(string) + 0.5);
        }
        catch (ParseException parseException) {
            throw new AltosConfigDataException("invalid main deploy height %s", string);
        }
    }

    String get_main_deploy_label() {
        return String.format("Main Deploy Altitude(%s):", AltosConvert.height.parse_units());
    }

    String[] main_deploy_values() {
        if (AltosConvert.imperial_units) {
            return main_deploy_values_ft;
        }
        return main_deploy_values_m;
    }

    void set_main_deploy_values() {
        String[] stringArray = this.main_deploy_values();
        while (this.main_deploy_value.getItemCount() > 0) {
            this.main_deploy_value.removeItemAt(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.main_deploy_value.addItem(stringArray[i]);
        }
        this.main_deploy_value.setMaximumRowCount(stringArray.length);
    }

    @Override
    public void units_changed(boolean bl) {
        boolean bl2 = this.dirty;
        String string = this.main_deploy_value.getSelectedItem().toString();
        this.main_deploy_label.setText(this.get_main_deploy_label());
        this.set_main_deploy_values();
        try {
            int n = (int)(AltosConvert.height.parse_locale(string, !bl) + 0.5);
            this.set_main_deploy(n);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.tracker_motion_value.isVisible()) {
            String string2 = this.tracker_motion_value.getSelectedItem().toString();
            this.tracker_motion_label.setText(this.get_tracker_motion_label());
            this.set_tracker_motion_values();
            try {
                int n = (int)(AltosConvert.height.parse_locale(string2, !bl) + 0.5);
                this.set_tracker_motion(n);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!bl2) {
            this.set_clean();
        }
    }

    @Override
    public void set_apogee_delay(int n) {
        if (n != Integer.MAX_VALUE) {
            this.apogee_delay_value.setSelectedItem(Integer.toString(n));
        }
        this.apogee_delay_value.setVisible(n != Integer.MAX_VALUE);
        this.apogee_delay_label.setVisible(n != Integer.MAX_VALUE);
    }

    private int parse_int(String string, String string2, boolean bl) throws AltosConfigDataException {
        String string3 = string2;
        if (bl) {
            string3 = string2.split("\\s+")[0];
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AltosConfigDataException("Invalid %s \"%s\"", string, string2);
        }
    }

    @Override
    public int apogee_delay() throws AltosConfigDataException {
        return this.parse_int("apogee delay", this.apogee_delay_value.getSelectedItem().toString(), false);
    }

    @Override
    public void set_apogee_lockout(int n) {
        if (n != Integer.MAX_VALUE) {
            this.apogee_lockout_value.setSelectedItem(Integer.toString(n));
        }
        this.apogee_lockout_value.setVisible(n != Integer.MAX_VALUE);
        this.apogee_lockout_label.setVisible(n != Integer.MAX_VALUE);
    }

    @Override
    public int apogee_lockout() throws AltosConfigDataException {
        return this.parse_int("apogee lockout", this.apogee_lockout_value.getSelectedItem().toString(), false);
    }

    @Override
    public void set_radio_frequency(double d) {
        if (d != 2.147483647E9) {
            this.radio_frequency_value.set_frequency(d);
        }
        this.radio_frequency_label.setVisible(d != 2.147483647E9);
        this.radio_frequency_value.setVisible(d != 2.147483647E9);
    }

    @Override
    public double radio_frequency() {
        return this.radio_frequency_value.frequency();
    }

    @Override
    public void set_radio_calibration(int n) {
        if (n != Integer.MAX_VALUE) {
            this.radio_calibration_value.setText(String.format("%d", n));
        }
        this.radio_calibration_value.setVisible(n != Integer.MAX_VALUE);
        this.radio_calibration_label.setVisible(n != Integer.MAX_VALUE);
    }

    @Override
    public void set_radio_enable(int n) {
        if (n != Integer.MAX_VALUE) {
            this.radio_enable_value.setSelected(n != 0);
        }
        this.radio_enable_label.setVisible(n != Integer.MAX_VALUE);
        this.radio_enable_value.setVisible(n != Integer.MAX_VALUE);
        this.set_radio_enable_tool_tip();
    }

    @Override
    public int radio_enable() {
        if (this.radio_enable_value.isVisible()) {
            return this.radio_enable_value.isSelected() ? 1 : 0;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_telemetry_rate(int n) {
        if (n != Integer.MAX_VALUE) {
            this.rate_value.set_rate(n);
        }
        this.rate_label.setVisible(n != Integer.MAX_VALUE);
        this.rate_value.setVisible(n != Integer.MAX_VALUE);
        this.set_rate_tool_tip();
    }

    @Override
    public int telemetry_rate() {
        return this.rate_value.rate();
    }

    @Override
    public void set_callsign(String string) {
        if (string != null) {
            this.callsign_value.setText(string);
        }
        this.callsign_value.setVisible(string != null);
        this.callsign_label.setVisible(string != null);
    }

    @Override
    public String callsign() {
        if (this.callsign_value.isVisible()) {
            return this.callsign_value.getText();
        }
        return null;
    }

    public String flight_log_max_label(int n) {
        if (this.flight_log_max_limit != 0) {
            int n2 = this.flight_log_max_limit / n;
            String string = n2 > 1 ? "s" : "";
            return String.format("%d (%d flight%s)", n, n2, string);
        }
        return String.format("%d", n);
    }

    @Override
    public void set_flight_log_max(int n) {
        if (n != Integer.MAX_VALUE) {
            this.flight_log_max_value.setSelectedItem(this.flight_log_max_label(n));
            this.flight_log_max = n;
        }
        this.flight_log_max_value.setVisible(n != Integer.MAX_VALUE);
        this.flight_log_max_label.setVisible(n != Integer.MAX_VALUE);
        this.set_flight_log_max_tool_tip();
    }

    @Override
    public void set_flight_log_max_enabled(boolean bl) {
        this.flight_log_max_value.setEnabled(bl);
        this.set_flight_log_max_tool_tip();
    }

    @Override
    public int flight_log_max() throws AltosConfigDataException {
        if (this.flight_log_max_value.isVisible()) {
            return this.parse_int("flight log max", this.flight_log_max_value.getSelectedItem().toString(), true);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_flight_log_max_limit(int n, int n2) {
        this.flight_log_max_limit = n;
        if (n != Integer.MAX_VALUE) {
            this.flight_log_max_value.removeAllItems();
            for (int i = 8; i >= 1; --i) {
                int n3 = this.flight_log_max_limit / i;
                if (n2 != 0) {
                    n3 &= ~(n2 - 1);
                }
                this.flight_log_max_value.addItem(String.format("%d (%d flights)", n3, i));
            }
        }
        if (this.flight_log_max != 0 && this.flight_log_max != Integer.MAX_VALUE) {
            this.set_flight_log_max(this.flight_log_max);
        }
    }

    @Override
    public void set_ignite_mode(int n) {
        if (n != Integer.MAX_VALUE) {
            if (n >= ignite_mode_values.length) {
                n = 0;
            }
            if (n < 0) {
                this.ignite_mode_value.setEnabled(false);
                n = 0;
            } else {
                this.ignite_mode_value.setEnabled(true);
            }
            this.ignite_mode_value.setSelectedIndex(n);
        }
        this.ignite_mode_value.setVisible(n != Integer.MAX_VALUE);
        this.ignite_mode_label.setVisible(n != Integer.MAX_VALUE);
        this.set_ignite_mode_tool_tip();
    }

    @Override
    public int ignite_mode() {
        if (this.ignite_mode_value.isVisible()) {
            return this.ignite_mode_value.getSelectedIndex();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_pad_orientation(int n) {
        if (n != Integer.MAX_VALUE) {
            if (n >= this.pad_orientation_values.length) {
                n = 0;
            }
            if (n < 0) {
                n = 0;
            }
            this.pad_orientation_value.setSelectedIndex(n);
        }
        this.pad_orientation_value.setVisible(n != Integer.MAX_VALUE);
        this.pad_orientation_label.setVisible(n != Integer.MAX_VALUE);
        this.accel_cal.setVisible(n != Integer.MAX_VALUE);
        this.set_pad_orientation_tool_tip();
    }

    @Override
    public int pad_orientation() {
        if (this.pad_orientation_value.isVisible()) {
            return this.pad_orientation_value.getSelectedIndex();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_accel_cal(int n, int n2) {
        if (n != Integer.MAX_VALUE) {
            this.accel_plus_value.setText(String.format("%d", n));
            this.accel_minus_value.setText(String.format("%d", n2));
        }
        this.accel_plus_value.setVisible(n != Integer.MAX_VALUE);
        this.accel_plus_label.setVisible(n != Integer.MAX_VALUE);
        this.accel_minus_value.setVisible(n2 != Integer.MAX_VALUE);
        this.accel_minus_label.setVisible(n2 != Integer.MAX_VALUE);
        this.set_accel_tool_tips();
    }

    @Override
    public int accel_cal_plus() {
        if (this.accel_plus_value.isVisible()) {
            return Integer.parseInt(this.accel_plus_value.getText());
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int accel_cal_minus() {
        if (this.accel_minus_value.isVisible()) {
            return Integer.parseInt(this.accel_minus_value.getText());
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_beep(int n) {
        if (n != Integer.MAX_VALUE) {
            int n2 = (int)Math.floor(AltosConvert.beep_value_to_freq(n) + 0.5);
            for (int i = 0; i < beep_values.length; ++i) {
                if (n != AltosConvert.beep_freq_to_value(Integer.parseInt(beep_values[i]))) continue;
                this.beep_value.setSelectedIndex(i);
                this.set_beep_tool_tip();
                return;
            }
            this.beep_value.setSelectedItem(String.format("%d", n2));
        }
        this.beep_value.setVisible(n != Integer.MAX_VALUE);
        this.beep_label.setVisible(n != Integer.MAX_VALUE);
        this.set_beep_tool_tip();
    }

    @Override
    public int beep() {
        if (this.beep_value.isVisible()) {
            return AltosConvert.beep_freq_to_value(Integer.parseInt(this.beep_value.getSelectedItem().toString()));
        }
        return Integer.MAX_VALUE;
    }

    String[] tracker_motion_values() {
        if (AltosConvert.imperial_units) {
            return tracker_motion_values_ft;
        }
        return tracker_motion_values_m;
    }

    void set_tracker_motion_values() {
        String[] stringArray = this.tracker_motion_values();
        while (this.tracker_motion_value.getItemCount() > 0) {
            this.tracker_motion_value.removeItemAt(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.tracker_motion_value.addItem(stringArray[i]);
        }
        this.tracker_motion_value.setMaximumRowCount(stringArray.length);
    }

    String get_tracker_motion_label() {
        return String.format("Logging Trigger Motion (%s):", AltosConvert.height.parse_units());
    }

    void set_tracker_tool_tip() {
        if (this.tracker_motion_value.isVisible()) {
            this.tracker_motion_value.setToolTipText("How far the device must move before logging");
        } else {
            this.tracker_motion_value.setToolTipText("This device doesn't disable logging when stationary");
        }
        if (this.tracker_interval_value.isVisible()) {
            this.tracker_interval_value.setToolTipText("How often to report GPS position");
        } else {
            this.tracker_interval_value.setToolTipText("This device can't configure interval");
        }
    }

    @Override
    public void set_tracker_motion(int n) {
        if (n != Integer.MAX_VALUE) {
            this.tracker_motion_value.setSelectedItem(AltosConvert.height.say(n));
        }
        this.tracker_motion_label.setVisible(n != Integer.MAX_VALUE);
        this.tracker_motion_value.setVisible(n != Integer.MAX_VALUE);
    }

    @Override
    public int tracker_motion() throws AltosConfigDataException {
        if (this.tracker_motion_value.isVisible()) {
            String string = this.tracker_motion_value.getSelectedItem().toString();
            try {
                return (int)(AltosConvert.height.parse_locale(string) + 0.5);
            }
            catch (ParseException parseException) {
                throw new AltosConfigDataException("invalid tracker motion %s", string);
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_tracker_interval(int n) {
        if (n != Integer.MAX_VALUE) {
            this.tracker_interval_value.setSelectedItem(String.format("%d", n));
        }
        this.tracker_interval_label.setVisible(n != Integer.MAX_VALUE);
        this.tracker_interval_value.setVisible(n != Integer.MAX_VALUE);
    }

    @Override
    public int tracker_interval() throws AltosConfigDataException {
        if (this.tracker_interval_value.isVisible()) {
            return this.parse_int("tracker interval", this.tracker_interval_value.getSelectedItem().toString(), false);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_pyros(AltosPyro[] altosPyroArray) {
        this.pyros = altosPyroArray;
        if (this.pyros != null && this.pyro_ui != null) {
            this.pyro_ui.set_pyros(this.pyros);
        }
        this.pyro.setVisible(this.pyros != null);
    }

    @Override
    public AltosPyro[] pyros() throws AltosConfigDataException {
        if (this.pyro_ui != null) {
            this.pyros = this.pyro_ui.get_pyros();
        }
        return this.pyros;
    }

    @Override
    public void set_pyro_firing_time(double d) {
        this.pyro_firing_time = d;
        if (this.pyro_firing_time != 2.147483647E9 && this.pyro_ui != null) {
            this.pyro_ui.set_pyro_firing_time(this.pyro_firing_time);
        }
        this.pyro.setVisible(this.pyro_firing_time != 2.147483647E9);
    }

    @Override
    public double pyro_firing_time() throws AltosConfigDataException {
        if (this.pyro_ui != null) {
            this.pyro_firing_time = this.pyro_ui.get_pyro_firing_time();
        }
        return this.pyro_firing_time;
    }

    private String aprs_interval_string(int n) {
        if (n == 0) {
            return "Disabled";
        }
        return Integer.toString(n);
    }

    private int aprs_interval_value(String string) throws AltosConfigDataException {
        if (string.equalsIgnoreCase("Disabled")) {
            return 0;
        }
        return this.parse_int("aprs interval", string, false);
    }

    @Override
    public void set_aprs_interval(int n) {
        if (n != Integer.MAX_VALUE) {
            this.aprs_interval_value.setSelectedItem(this.aprs_interval_string(n));
        }
        this.aprs_interval_value.setVisible(n != Integer.MAX_VALUE);
        this.aprs_interval_label.setVisible(n != Integer.MAX_VALUE);
        this.set_aprs_interval_tool_tip();
    }

    @Override
    public int aprs_interval() throws AltosConfigDataException {
        if (this.aprs_interval_value.isVisible()) {
            return this.aprs_interval_value(this.aprs_interval_value.getSelectedItem().toString());
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_aprs_ssid(int n) {
        if (n != Integer.MAX_VALUE) {
            this.aprs_ssid_value.setSelectedItem(n);
        }
        this.aprs_ssid_value.setVisible(n != Integer.MAX_VALUE);
        this.aprs_ssid_label.setVisible(n != Integer.MAX_VALUE);
        this.set_aprs_ssid_tool_tip();
    }

    @Override
    public int aprs_ssid() throws AltosConfigDataException {
        if (this.aprs_ssid_value.isVisible()) {
            Integer n = (Integer)this.aprs_ssid_value.getSelectedItem();
            return n;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_aprs_format(int n) {
        if (n != Integer.MAX_VALUE) {
            this.aprs_format_value.setSelectedIndex(n);
        }
        this.aprs_format_value.setVisible(n != Integer.MAX_VALUE);
        this.aprs_format_label.setVisible(n != Integer.MAX_VALUE);
        this.set_aprs_format_tool_tip();
    }

    @Override
    public int aprs_format() throws AltosConfigDataException {
        if (this.aprs_format_value.isVisible()) {
            return this.aprs_format_value.getSelectedIndex();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_aprs_offset(int n) {
        if (n != Integer.MAX_VALUE) {
            this.aprs_offset_value.setSelectedItem(n);
        }
        this.aprs_offset_value.setVisible(n != Integer.MAX_VALUE);
        this.aprs_offset_label.setVisible(n != Integer.MAX_VALUE);
        this.set_aprs_offset_tool_tip();
    }

    @Override
    public int aprs_offset() throws AltosConfigDataException {
        if (this.aprs_offset_value.isVisible()) {
            Integer n = (Integer)this.aprs_offset_value.getSelectedItem();
            return n;
        }
        return Integer.MAX_VALUE;
    }

    class ConfigListener
    extends WindowAdapter {
        AltosConfigFCUI ui;

        public ConfigListener(AltosConfigFCUI altosConfigFCUI2) {
            this.ui = altosConfigFCUI2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.ui.actionPerformed(new ActionEvent(windowEvent.getSource(), 1001, "Close"));
        }
    }
}

