/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.Altos;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JTable;
import org.altusmetrum.altoslib_14.AltosCompanion;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosFlightInfoTableModel;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosCompanionInfo
extends JTable
implements AltosFlightDisplay {
    private AltosFlightInfoTableModel model = (AltosFlightInfoTableModel)this.getModel();
    static final int info_columns = 2;
    static final int info_rows = 17;
    AltosCompanion companion;

    int desired_row_height() {
        FontMetrics fontMetrics = this.getFontMetrics(Altos.table_value_font);
        return (fontMetrics.getHeight() + fontMetrics.getLeading()) * 18 / 10;
    }

    @Override
    public void font_size_changed(int n) {
        this.setFont(Altos.table_value_font);
        this.setRowHeight(this.desired_row_height());
        this.doLayout();
    }

    @Override
    public void units_changed(boolean bl) {
    }

    public AltosCompanionInfo() {
        super(new AltosFlightInfoTableModel(17, 2));
        this.setAutoResizeMode(4);
        this.setShowGrid(true);
        this.font_size_changed(AltosUIPreferences.font_size());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public void reset() {
        this.model.reset();
    }

    void info_add_row(int n, String string, String string2) {
        this.model.addRow(n, string, string2);
    }

    void info_add_row(int n, String string, String string2, Object ... objectArray) {
        this.info_add_row(n, string, String.format(string2, objectArray));
    }

    void info_finish() {
        this.model.finish();
    }

    public void clear() {
        this.model.clear();
    }

    public String board_name() {
        if (this.companion == null) {
            return "None";
        }
        switch (this.companion.board_id) {
            case 10: {
                return "TeleScience";
            }
        }
        return String.format("%02x\n", this.companion.board_id);
    }

    @Override
    public String getName() {
        return "Companion";
    }

    @Override
    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        if (altosState == null) {
            return;
        }
        if (altosState.companion != null) {
            this.companion = altosState.companion;
        }
        this.reset();
        this.info_add_row(0, "Companion board", "%s", this.board_name());
        if (this.companion != null) {
            this.info_add_row(0, "Last Data", "%5d", this.companion.tick);
            this.info_add_row(0, "Update period", "%5.2f s", (double)this.companion.update_period / 100.0);
            this.info_add_row(0, "Channels", "%3d", this.companion.channels);
            for (int i = 0; i < this.companion.channels; ++i) {
                this.info_add_row(1, String.format("Channel %2d", i), "%6d", this.companion.companion_data[i]);
            }
        }
        this.info_finish();
    }
}

