/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosUIFlightTab;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.altosuilib_14.AltosUIUnitsIndicator;

public class AltosAscent
extends AltosUIFlightTab {
    JLabel cur;
    JLabel max;

    @Override
    public void font_size_changed(int n) {
        super.font_size_changed(n);
        this.cur.setFont(AltosUILib.label_font);
        this.max.setFont(AltosUILib.label_font);
    }

    public void labels(GridBagLayout gridBagLayout, int n) {
        this.cur = new JLabel("Current");
        this.cur.setFont(AltosUILib.label_font);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.cur, gridBagConstraints);
        this.add(this.cur);
        this.max = new JLabel("Maximum");
        this.max.setFont(AltosUILib.label_font);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagLayout.setConstraints(this.max, gridBagConstraints);
        this.add(this.max);
    }

    @Override
    public String getName() {
        return "Ascent";
    }

    public AltosAscent() {
        int n = 0;
        this.labels(this.layout, n++);
        this.add(new Height(this, n++));
        this.add(new Speed(this, n++));
        this.add(new Accel(this, n++));
        this.add(new Orient(this, n++));
        this.add(new Lat(this, n++));
        this.add(new Lon(this, n++));
        this.add(new Apogee(this, n++));
        this.add(new Main(this, n++));
    }

    class Lon
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(AltosState altosState, int n) {
            return altosState.gps == null || !altosState.gps.connected;
        }

        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.gps == null) {
                return 2.147483647E9;
            }
            if (!altosState.gps.connected) {
                return 2.147483647E9;
            }
            return altosState.gps.lon;
        }

        Lon(Container container, int n) {
            super(container, n, AltosConvert.longitude, "Longitude", 1, false, 2);
        }
    }

    class Lat
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(AltosState altosState, int n) {
            return altosState.gps == null || !altosState.gps.connected;
        }

        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.gps == null) {
                return 2.147483647E9;
            }
            if (!altosState.gps.connected) {
                return 2.147483647E9;
            }
            return altosState.gps.lat;
        }

        Lat(Container container, int n) {
            super(container, n, AltosConvert.latitude, "Latitude", 1, false, 2);
        }
    }

    class Main
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.main_voltage;
        }

        @Override
        public boolean good(double d) {
            return d >= 3.5;
        }

        @Override
        public boolean hide(double d) {
            return d == 2.147483647E9;
        }

        public Main(Container container, int n) {
            super(container, n, AltosConvert.voltage, "Main Igniter Voltage", 1, true, 2);
        }
    }

    class Apogee
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.apogee_voltage;
        }

        @Override
        public boolean good(double d) {
            return d >= 3.5;
        }

        @Override
        public boolean hide(double d) {
            return d == 2.147483647E9;
        }

        public Apogee(Container container, int n) {
            super(container, n, AltosConvert.voltage, "Apogee Igniter Voltage", 1, true, 2);
        }
    }

    class Orient
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(double d) {
            return d == 2.147483647E9;
        }

        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.orient();
            }
            return altosState.max_orient();
        }

        public Orient(Container container, int n) {
            super(container, n, AltosConvert.orient, "Tilt Angle", 2, false, 1);
        }
    }

    class Accel
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(double d) {
            return d == 2.147483647E9;
        }

        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.acceleration();
            }
            return altosState.max_acceleration();
        }

        public Accel(Container container, int n) {
            super(container, n, AltosConvert.accel, "Acceleration", 2, false, 1);
        }
    }

    class Speed
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.speed();
            }
            return altosState.max_speed();
        }

        public Speed(Container container, int n) {
            super(container, n, AltosConvert.speed, "Speed", 2, false, 1);
        }
    }

    class Height
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.height();
            }
            return altosState.max_height();
        }

        public Height(Container container, int n) {
            super(container, n, AltosConvert.height, "Height", 2, false, 1);
        }
    }
}

