/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.altusmetrum.altoslib_14.AltosTimeSeries;
import org.altusmetrum.altoslib_14.AltosTimeValue;
import org.altusmetrum.altoslib_14.AltosUnits;
import org.altusmetrum.altosuilib_14.AltosUIAxis;
import org.altusmetrum.altosuilib_14.AltosUIDataPoint;
import org.altusmetrum.altosuilib_14.AltosUIGrapher;
import org.altusmetrum.altosuilib_14.AltosUILineStyle;
import org.altusmetrum.altosuilib_14.AltosUITime;
import org.altusmetrum.altosuilib_14.AltosXYSeries;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class AltosUITimeSeries
extends AltosTimeSeries
implements AltosUIGrapher {
    AltosUILineStyle line_style;
    boolean enable;
    boolean custom_axis_set;
    AltosUIAxis axis;
    boolean marker;
    boolean marker_top;
    XYLineAndShapeRenderer renderer;
    XYPlot plot;
    AltosXYSeries xy_series;
    ArrayList<ValueMarker> markers;
    float width;

    @Override
    public boolean need_reset() {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public void add(AltosUIDataPoint altosUIDataPoint) {
    }

    @Override
    public void setNotify(boolean bl) {
    }

    @Override
    public void fireSeriesChanged() {
    }

    public void set_data() {
        if (this.marker) {
            if (this.markers != null) {
                for (ValueMarker valueMarker : this.markers) {
                    this.plot.removeDomainMarker((Marker)valueMarker);
                }
            }
            this.markers = new ArrayList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ValueMarker valueMarker;
                valueMarker = (AltosTimeValue)iterator.next();
                String string = this.units.string_value(valueMarker.value);
                ValueMarker valueMarker2 = new ValueMarker(valueMarker.time);
                valueMarker2.setLabel(string);
                if (this.marker_top) {
                    valueMarker2.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
                    valueMarker2.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                } else {
                    valueMarker2.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
                    valueMarker2.setLabelTextAnchor(TextAnchor.BOTTOM_LEFT);
                }
                valueMarker2.setPaint((Paint)this.line_style.color);
                valueMarker2.setStroke((Stroke)new BasicStroke(this.width, 0, 2));
                if (this.enable) {
                    this.plot.addDomainMarker((Marker)valueMarker2);
                }
                this.markers.add(valueMarker2);
            }
        } else {
            this.xy_series.clear();
            this.xy_series.setNotify(false);
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AltosTimeValue altosTimeValue = (AltosTimeValue)iterator.next();
                double d = altosTimeValue.value;
                if (this.units != null) {
                    d = this.units.graph_value(d);
                }
                this.xy_series.add(altosTimeValue.time, d);
            }
            this.xy_series.setNotify(true);
        }
        this.clear_changed();
    }

    @Override
    public void set_units() {
        this.axis.set_units();
        if (this.units != null) {
            String string = new AltosUITime().graph_format(7);
            String string2 = this.units.graph_format(7);
            StandardXYToolTipGenerator standardXYToolTipGenerator = new StandardXYToolTipGenerator(String.format("{1}s: {2}%s ({0})", this.units.graph_units()), (NumberFormat)new DecimalFormat(string), (NumberFormat)new DecimalFormat(string2));
            this.renderer.setBaseToolTipGenerator((XYToolTipGenerator)standardXYToolTipGenerator);
        }
        this.set_data();
    }

    public AltosXYSeries xy_series() {
        return this.xy_series;
    }

    @Override
    public void set_enable(boolean bl) {
        if (this.enable != bl) {
            this.enable = bl;
            if (this.marker) {
                for (ValueMarker valueMarker : this.markers) {
                    if (bl) {
                        this.plot.addDomainMarker((Marker)valueMarker);
                        continue;
                    }
                    this.plot.removeDomainMarker((Marker)valueMarker);
                }
            } else {
                this.renderer.setSeriesVisible(0, Boolean.valueOf(bl));
                this.axis.set_enable(bl);
            }
        }
    }

    public void set_line_width(float f) {
        this.width = f;
        if (this.markers != null) {
            for (ValueMarker valueMarker : this.markers) {
                valueMarker.setStroke((Stroke)new BasicStroke(f, 0, 2));
            }
        } else if ((double)this.line_style.dash[0] == 0.0) {
            this.renderer.setSeriesStroke(0, (Stroke)new BasicStroke(f, 1, 1));
        } else {
            this.renderer.setSeriesStroke(0, (Stroke)new BasicStroke(f, 1, 1, 10.0f, this.line_style.dash, 0.0f));
        }
    }

    public void set_axis(AltosUILineStyle altosUILineStyle, boolean bl, AltosUIAxis altosUIAxis) {
        this.line_style = altosUILineStyle;
        this.enable = bl;
        this.axis = altosUIAxis;
        this.marker = false;
        this.width = 1.0f;
        altosUIAxis.ref(this.enable);
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.renderer.setSeriesPaint(0, (Paint)altosUILineStyle.color);
        this.set_line_width(this.width);
        this.renderer.setSeriesVisible(0, Boolean.valueOf(bl));
        this.xy_series = new AltosXYSeries(this.label);
    }

    public void set_marker(AltosUILineStyle altosUILineStyle, boolean bl, XYPlot xYPlot, boolean bl2) {
        this.line_style = altosUILineStyle;
        this.enable = bl;
        this.marker = true;
        this.plot = xYPlot;
        this.marker_top = bl2;
    }

    public void set_shapes_visible(boolean bl) {
        this.renderer.setSeriesShapesVisible(0, bl);
    }

    public AltosUITimeSeries(String string, AltosUnits altosUnits) {
        super(string, altosUnits);
    }

    public AltosUITimeSeries(String string, AltosUnits altosUnits, AltosUILineStyle altosUILineStyle, boolean bl, AltosUIAxis altosUIAxis) {
        this(string, altosUnits);
        this.set_axis(altosUILineStyle, bl, altosUIAxis);
    }
}

