/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import org.altusmetrum.altosuilib_14.AltosUIDataMissing;
import org.altusmetrum.altosuilib_14.AltosUIDataPoint;
import org.altusmetrum.altosuilib_14.AltosUIGrapher;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class AltosUIMarker
implements AltosUIGrapher {
    ArrayList<ValueMarker> markers = new ArrayList();
    int last_id = -1;
    XYPlot plot;
    boolean enabled;
    int fetch;
    Color color;

    private void remove_markers() {
        for (ValueMarker valueMarker : this.markers) {
            this.plot.removeDomainMarker((Marker)valueMarker);
        }
    }

    private void add_markers() {
        for (ValueMarker valueMarker : this.markers) {
            this.plot.addDomainMarker((Marker)valueMarker);
        }
    }

    @Override
    public void set_units() {
    }

    @Override
    public boolean need_reset() {
        return true;
    }

    @Override
    public void set_enable(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        if (bl) {
            this.add_markers();
        } else {
            this.remove_markers();
        }
        this.enabled = bl;
    }

    @Override
    public void clear() {
        if (this.enabled) {
            this.remove_markers();
        }
        this.markers = new ArrayList();
    }

    @Override
    public void add(AltosUIDataPoint altosUIDataPoint) {
        try {
            int n = altosUIDataPoint.id(this.fetch);
            if (n < 0) {
                return;
            }
            if (n == this.last_id) {
                return;
            }
            ValueMarker valueMarker = new ValueMarker(altosUIDataPoint.x());
            valueMarker.setLabel(altosUIDataPoint.id_name(this.fetch));
            valueMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            valueMarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            valueMarker.setPaint((Paint)this.color);
            if (this.enabled) {
                this.plot.addDomainMarker((Marker)valueMarker);
            }
            this.markers.add(valueMarker);
            this.last_id = n;
        }
        catch (AltosUIDataMissing altosUIDataMissing) {
            // empty catch block
        }
    }

    public AltosUIMarker(int n, Color color, XYPlot xYPlot, boolean bl) {
        this.fetch = n;
        this.color = color;
        this.plot = xYPlot;
        this.enabled = bl;
    }

    @Override
    public void setNotify(boolean bl) {
    }

    @Override
    public void fireSeriesChanged() {
    }

    public AltosUIMarker(int n, Color color, XYPlot xYPlot) {
        this(n, color, xYPlot, true);
    }
}

