/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.Hashtable;
import javax.swing.JPanel;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosUnits;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosShapeListener;
import org.altusmetrum.altosuilib_14.AltosUIAxis;
import org.altusmetrum.altosuilib_14.AltosUIEnable;
import org.altusmetrum.altosuilib_14.AltosUILineStyle;
import org.altusmetrum.altosuilib_14.AltosUITimeSeries;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class AltosUIGraph
implements AltosUnitsListener,
AltosShapeListener {
    XYPlot plot;
    JFreeChart chart;
    public ChartPanel panel;
    NumberAxis xAxis;
    AltosUIEnable enable;
    AltosUITimeSeries[] series;
    int axis_index;
    int series_index;
    Hashtable<Integer, Boolean> axes_added;
    private static final Color gridline_color = new Color(0, 0, 0);
    private static final Color border_color = new Color(255, 255, 255);
    private static final Color background_color = new Color(255, 255, 255);

    public JPanel panel() {
        return this.panel;
    }

    public AltosUIAxis newAxis(String string, AltosUnits altosUnits, AltosUILineStyle altosUILineStyle, int n) {
        AltosUIAxis altosUIAxis = new AltosUIAxis(string, altosUnits, altosUILineStyle, this.axis_index++, n);
        this.plot.setRangeAxis(altosUIAxis.index, (ValueAxis)altosUIAxis);
        return altosUIAxis;
    }

    public AltosUIAxis newAxis(String string, AltosUnits altosUnits, AltosUILineStyle altosUILineStyle) {
        return this.newAxis(string, altosUnits, altosUILineStyle, 2);
    }

    void addAxis(AltosUIAxis altosUIAxis) {
        if (!this.axes_added.containsKey(altosUIAxis.index)) {
            this.axes_added.put(altosUIAxis.index, true);
            this.plot.setRangeAxis(altosUIAxis.index, (ValueAxis)altosUIAxis);
        }
    }

    public void addSeries(AltosUITimeSeries altosUITimeSeries) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection((XYSeries)altosUITimeSeries.xy_series());
        this.addAxis(altosUITimeSeries.axis);
        altosUITimeSeries.renderer.setPlot(this.plot);
        this.plot.setDataset(this.series_index, (XYDataset)xYSeriesCollection);
        this.plot.setRenderer(this.series_index, (XYItemRenderer)altosUITimeSeries.renderer);
        this.plot.mapDatasetToRangeAxis(this.series_index, altosUITimeSeries.axis.index);
        if (this.enable != null) {
            this.enable.add(altosUITimeSeries.label, altosUITimeSeries, altosUITimeSeries.enable);
        }
        ++this.series_index;
    }

    public void addMarker(AltosUITimeSeries altosUITimeSeries) {
    }

    public void units_changed(boolean bl) {
        for (AltosUITimeSeries altosUITimeSeries : this.series) {
            altosUITimeSeries.set_units();
        }
    }

    public void filter_changed() {
        this.units_changed(false);
    }

    @Override
    public void set_shapes_visible(boolean bl) {
        for (AltosUITimeSeries altosUITimeSeries : this.series) {
            altosUITimeSeries.set_shapes_visible(bl);
        }
    }

    @Override
    public void set_line_width(float f) {
        for (AltosUITimeSeries altosUITimeSeries : this.series) {
            altosUITimeSeries.set_line_width(f);
        }
    }

    public void setName(String string) {
        this.chart.setTitle(string);
    }

    public void set_series(AltosUITimeSeries[] altosUITimeSeriesArray) {
        this.series = altosUITimeSeriesArray;
        boolean bl = false;
        for (AltosUITimeSeries altosUITimeSeries : altosUITimeSeriesArray) {
            if (!altosUITimeSeries.enable) continue;
            bl = true;
        }
        if (!bl) {
            for (AltosUITimeSeries altosUITimeSeries : altosUITimeSeriesArray) {
                altosUITimeSeries.set_enable(true);
            }
        }
        for (AltosUITimeSeries altosUITimeSeries : altosUITimeSeriesArray) {
            this.addSeries(altosUITimeSeries);
        }
        this.units_changed(false);
    }

    public AltosUIGraph(AltosUIEnable altosUIEnable, String string) {
        this.enable = altosUIEnable;
        this.series = null;
        this.axis_index = 0;
        if (altosUIEnable != null) {
            altosUIEnable.register_shape_listener(this);
        }
        this.axes_added = new Hashtable();
        this.xAxis = new NumberAxis("Time (s)");
        this.xAxis.setAutoRangeIncludesZero(true);
        this.plot = new XYPlot();
        this.plot.setDomainAxis((ValueAxis)this.xAxis);
        this.plot.setOrientation(PlotOrientation.VERTICAL);
        this.plot.setDomainPannable(true);
        this.plot.setRangePannable(true);
        this.chart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, true);
        ChartUtilities.applyCurrentTheme((JFreeChart)this.chart);
        this.plot.setDomainGridlinePaint((Paint)gridline_color);
        this.plot.setRangeGridlinePaint((Paint)gridline_color);
        this.plot.setBackgroundPaint((Paint)background_color);
        this.plot.setBackgroundAlpha(1.0f);
        this.chart.setBackgroundPaint((Paint)background_color);
        this.chart.setBorderPaint((Paint)border_color);
        this.panel = new ChartPanel(this.chart);
        this.panel.setMouseWheelEnabled(true);
        this.panel.setPreferredSize(new Dimension(800, 500));
        AltosPreferences.register_units_listener((AltosUnitsListener)this);
    }
}

