/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.altusmetrum.altoslib_14.AltosFilterListener;
import org.altusmetrum.altosuilib_14.AltosShapeListener;
import org.altusmetrum.altosuilib_14.AltosUIGrapher;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosUIEnable
extends Container
implements ChangeListener {
    Insets il;
    Insets ir;
    int y;
    int x;
    JCheckBox imperial_units;
    JCheckBox show_shapes;
    JLabel line_width_label;
    JSpinner line_width;
    JLabel speed_filter_label;
    JSlider speed_filter;
    JLabel accel_filter_label;
    JSlider accel_filter;
    AltosFilterListener filter_listener;
    AltosShapeListener shape_listener;
    static final int max_rows = 14;
    LinkedList<GraphElement> elements = new LinkedList();

    public void units_changed(boolean bl) {
        if (this.imperial_units != null) {
            this.imperial_units.setSelected(bl);
        }
    }

    public void add(String string, AltosUIGrapher altosUIGrapher, boolean bl) {
        GraphElement graphElement = new GraphElement(string, altosUIGrapher, bl);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.elements.add(graphElement);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.x++;
        gridBagConstraints.gridy = this.y++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = this.ir;
        this.add((Component)graphElement.enable, gridBagConstraints);
        if (this.y == 14) {
            this.y = 0;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            double d = (double)this.speed_filter.getValue() / 1000.0;
            double d2 = (double)this.accel_filter.getValue() / 1000.0;
            if (this.filter_listener != null) {
                this.filter_listener.filter_changed(d, d2);
            }
        }
    }

    public void set_shapes_visible(boolean bl) {
        if (this.shape_listener != null) {
            this.shape_listener.set_shapes_visible(bl);
        }
    }

    public void set_line_width(float f) {
        if (this.shape_listener != null) {
            this.shape_listener.set_line_width(f);
        }
    }

    public void register_shape_listener(AltosShapeListener altosShapeListener) {
        this.shape_listener = altosShapeListener;
    }

    public void add_units() {
        this.imperial_units = new JCheckBox("Imperial Units", AltosUIPreferences.imperial_units());
        this.imperial_units.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                boolean bl = jCheckBox.isSelected();
                AltosUIPreferences.set_imperial_units((boolean)bl);
            }
        });
        this.imperial_units.setToolTipText("Use Imperial units instead of metric");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1000;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = this.il;
        this.add((Component)this.imperial_units, gridBagConstraints);
        this.show_shapes = new JCheckBox("Show Markers", false);
        this.show_shapes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                boolean bl = jCheckBox.isSelected();
                AltosUIEnable.this.set_shapes_visible(bl);
            }
        });
        this.show_shapes.setToolTipText("Show marker Use Imperial units instead of metric");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1001;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = this.il;
        this.add((Component)this.show_shapes, gridBagConstraints);
        this.line_width_label = new JLabel("Line Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1001;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = this.il;
        this.add((Component)this.line_width_label, gridBagConstraints);
        this.line_width = new JSpinner();
        this.line_width.setValue(1);
        this.line_width.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)AltosUIEnable.this.line_width.getValue();
                if (n < 1) {
                    n = 1;
                    AltosUIEnable.this.line_width.setValue(n);
                }
                AltosUIEnable.this.set_line_width(n);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1001;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = this.il;
        this.add((Component)this.line_width, gridBagConstraints);
        this.speed_filter_label = new JLabel("Speed Filter(ms)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1002;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = this.il;
        this.add((Component)this.speed_filter_label, gridBagConstraints);
        this.speed_filter = new JSlider(0, 0, 10000, (int)(this.filter_listener.speed_filter() * 1000.0));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 10000; i += 5000) {
            hashtable.put(i, new JLabel(String.format("%d", i)));
        }
        this.speed_filter.setPaintTicks(true);
        this.speed_filter.setMajorTickSpacing(1000);
        this.speed_filter.setMinorTickSpacing(250);
        this.speed_filter.setLabelTable(hashtable);
        this.speed_filter.setPaintTrack(false);
        this.speed_filter.setSnapToTicks(true);
        this.speed_filter.setPaintLabels(true);
        this.speed_filter.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1002;
        gridBagConstraints.gridwidth = 1000;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = this.il;
        this.add((Component)this.speed_filter, gridBagConstraints);
        this.accel_filter_label = new JLabel("Acceleration Filter(ms)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1003;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = this.il;
        this.add((Component)this.accel_filter_label, gridBagConstraints);
        this.accel_filter = new JSlider(0, 0, 10000, (int)(this.filter_listener.accel_filter() * 1000.0));
        this.accel_filter.setPaintTicks(true);
        this.accel_filter.setMajorTickSpacing(1000);
        this.accel_filter.setMinorTickSpacing(250);
        this.accel_filter.setLabelTable(hashtable);
        this.accel_filter.setPaintTrack(false);
        this.accel_filter.setSnapToTicks(true);
        this.accel_filter.setPaintLabels(true);
        this.accel_filter.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1003;
        gridBagConstraints.gridwidth = 1000;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = this.il;
        this.add((Component)this.accel_filter, gridBagConstraints);
    }

    public AltosUIEnable(AltosFilterListener altosFilterListener) {
        this.filter_listener = altosFilterListener;
        this.il = new Insets(4, 4, 4, 4);
        this.ir = new Insets(4, 4, 4, 4);
        this.x = 0;
        this.y = 0;
        this.setLayout(new GridBagLayout());
        this.add_units();
    }

    class GraphElement
    implements ActionListener {
        AltosUIGrapher grapher;
        JCheckBox enable;
        String name;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.grapher.set_enable(this.enable.isSelected());
        }

        GraphElement(String string, AltosUIGrapher altosUIGrapher, boolean bl) {
            this.name = string;
            this.grapher = altosUIGrapher;
            this.enable = new JCheckBox(string, bl);
            altosUIGrapher.set_enable(bl);
            this.enable.addActionListener(this);
        }
    }
}

