/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUILib;

public abstract class AltosDeviceDialog
extends AltosUIDialog
implements ActionListener {
    private AltosDevice value;
    private JList<AltosDevice> list;
    private JButton cancel_button;
    private JButton select_button;
    public Frame frame;
    public int product;
    public JPanel buttonPane;
    private Timer timer;
    AltosDevice[] devices;

    public AltosDevice getValue() {
        return this.value;
    }

    public abstract AltosDevice[] devices();

    public void update_devices() {
        AltosDevice altosDevice = this.list.getSelectedValue();
        this.devices = this.devices();
        this.list.setListData((AltosDevice[])this.devices);
        for (AltosDevice altosDevice2 : this.devices) {
            if (!altosDevice2.equals(altosDevice)) continue;
            this.list.setSelectedValue(altosDevice2, true);
            break;
        }
        this.select_button.setEnabled(this.devices.length > 0);
    }

    public void add_bluetooth() {
    }

    public AltosDeviceDialog(Frame frame, Component component, int n) {
        super(frame, "Device Selection", true);
        this.product = n;
        this.frame = frame;
        this.value = null;
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.setActionCommand("cancel");
        this.cancel_button.addActionListener(this);
        this.select_button = new JButton("Select");
        this.select_button.setActionCommand("select");
        this.select_button.addActionListener(this);
        this.select_button.setEnabled(false);
        this.getRootPane().setDefaultButton(this.select_button);
        this.list = new JList<AltosDevice>(this.devices){

            @Override
            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                int n3;
                if (n == 1 && n2 < 0 && (n3 = this.getFirstVisibleIndex()) != -1) {
                    Rectangle rectangle2 = this.getCellBounds(n3, n3);
                    if (rectangle2.y == rectangle.y && n3 != 0) {
                        Point point = rectangle2.getLocation();
                        --point.y;
                        int n4 = this.locationToIndex(point);
                        Rectangle rectangle3 = this.getCellBounds(n4, n4);
                        if (rectangle3 == null || rectangle3.y >= rectangle2.y) {
                            return 0;
                        }
                        return rectangle3.height;
                    }
                }
                return super.getScrollableUnitIncrement(rectangle, n, n2);
            }
        };
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(-1);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AltosDeviceDialog.this.select_button.doClick();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(400, 80));
        jScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JLabel jLabel = new JLabel("Select Device");
        jLabel.setLabelFor(this.list);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 2));
        this.buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.buttonPane.add(Box.createHorizontalGlue());
        this.buttonPane.add(this.cancel_button);
        this.buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        if (AltosUILib.has_bluetooth) {
            this.add_bluetooth();
        }
        this.buttonPane.add(this.select_button);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)this.buttonPane, "Last");
        this.update_devices();
        if (this.devices != null && this.devices.length != 0) {
            this.list.setSelectedValue(this.devices[0], true);
        }
        this.pack();
        this.setLocationRelativeTo(component);
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosDeviceDialog.this.update_devices();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                AltosDeviceDialog.this.timer.start();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                AltosDeviceDialog.this.timer.stop();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("select".equals(actionEvent.getActionCommand())) {
            this.value = this.list.getSelectedValue();
            this.setVisible(false);
        }
        if ("cancel".equals(actionEvent.getActionCommand())) {
            this.setVisible(false);
        }
    }
}

