/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.altusmetrum.altoslib_14.AltosJson;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosUnitInfoListener;

public class AltosUnitInfo
extends Thread {
    int sn;
    int rfcal;
    AltosUnitInfoListener listener;
    String json_string;

    public int sn() {
        return this.sn;
    }

    public int rfcal() {
        return this.rfcal;
    }

    void add(String string) {
        this.json_string = this.json_string == null ? string : this.json_string + "\n" + string;
    }

    void notify_complete() {
        this.rfcal = Integer.MAX_VALUE;
        if (this.json_string != null) {
            System.out.printf("json_string: %s\n", this.json_string);
            AltosJson altosJson = AltosJson.fromString(this.json_string);
            System.out.printf("json: %s\n", altosJson);
            String string = null;
            try {
                AltosJson altosJson2 = altosJson.get("unitinfo");
                string = altosJson2.get_string("rfcal", null);
                if (string != null) {
                    this.rfcal = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.printf("mal-formed integer %s\n", string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.printf("mal-formed json\n", new Object[0]);
            }
        }
        this.listener.notify_unit_info(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String string;
            String string2 = System.getenv("UNIT_INFO");
            if (string2 == null) {
                string2 = "https://altusmetrum.org/cgi-bin/unitinfo.cgi?sn=%d";
            }
            String string3 = String.format(string2, this.sn);
            URL uRL = new URL(string3);
            System.out.printf("URL: %s\n", string3);
            URLConnection uRLConnection = uRL.openConnection();
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream(), AltosLib.unicode_set);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                this.add(string);
            }
        }
        catch (Exception exception) {
            System.out.printf("file exception %s\n", exception.toString());
        }
        finally {
            this.notify_complete();
        }
    }

    public AltosUnitInfo(int n, AltosUnitInfoListener altosUnitInfoListener) {
        this.listener = altosUnitInfoListener;
        this.sn = n;
        this.rfcal = Integer.MAX_VALUE;
        this.start();
    }
}

