/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosTelemetryStandard;

public class AltosTelemetrySensor
extends AltosTelemetryStandard {
    int state() {
        return this.uint8(5);
    }

    int accel() {
        return this.int16(6);
    }

    int pres() {
        return this.int16(8);
    }

    int temp() {
        return this.int16(10);
    }

    int v_batt() {
        return this.int16(12);
    }

    int sense_d() {
        return this.int16(14);
    }

    int sense_m() {
        return this.int16(16);
    }

    int acceleration() {
        return this.int16(18);
    }

    int speed() {
        return this.int16(20);
    }

    int height_16() {
        return this.int16(22);
    }

    int ground_pres() {
        return this.int16(24);
    }

    int ground_accel() {
        return this.int16(26);
    }

    int accel_plus_g() {
        return this.int16(28);
    }

    int accel_minus_g() {
        return this.int16(30);
    }

    public AltosTelemetrySensor(int[] nArray) throws AltosCRCException {
        super(nArray);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        super.provide_data(altosDataListener);
        altosDataListener.set_state(this.state());
        AltosCalData altosCalData = altosDataListener.cal_data();
        if (this.type() == 1) {
            altosCalData.set_ground_accel(this.ground_accel());
            altosCalData.set_accel_plus_minus(this.accel_plus_g(), this.accel_minus_g());
            altosDataListener.set_acceleration(altosCalData.acceleration(this.accel()));
        }
        altosCalData.set_ground_pressure(AltosConvert.barometer_to_pressure(this.ground_pres()));
        altosDataListener.set_pressure(AltosConvert.barometer_to_pressure(this.pres()));
        altosDataListener.set_temperature(AltosConvert.thermometer_to_temperature(this.temp()));
        altosDataListener.set_battery_voltage(AltosConvert.cc_battery_to_voltage(this.v_batt()));
        if (this.type() == 1 || this.type() == 2) {
            altosDataListener.set_apogee_voltage(AltosConvert.cc_igniter_to_voltage(this.sense_d()));
            altosDataListener.set_main_voltage(AltosConvert.cc_igniter_to_voltage(this.sense_m()));
        }
        altosDataListener.set_kalman(this.height_16(), (double)this.speed() / 16.0, (double)this.acceleration() / 16.0);
    }
}

