/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosTelemetryStandard;

public class AltosTelemetryMegaData
extends AltosTelemetryStandard {
    int state() {
        return this.uint8(5);
    }

    int v_batt() {
        return this.int16(6);
    }

    int v_pyro() {
        return this.int16(8);
    }

    int sense(int n) {
        int n2 = this.uint8(10 + n);
        return n2 << 4 | n2 >> 4;
    }

    int ground_pres() {
        return this.int32(16);
    }

    int ground_accel() {
        return this.int16(20);
    }

    int accel_plus_g() {
        return this.int16(22);
    }

    int accel_minus_g() {
        return this.int16(24);
    }

    int acceleration() {
        return this.int16(26);
    }

    int speed() {
        return this.int16(28);
    }

    int height_16() {
        return this.int16(30);
    }

    public AltosTelemetryMegaData(int[] nArray) throws AltosCRCException {
        super(nArray);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        super.provide_data(altosDataListener);
        altosDataListener.set_state(this.state());
        altosDataListener.set_battery_voltage(AltosConvert.mega_battery_voltage(this.v_batt()));
        altosDataListener.set_pyro_voltage(AltosConvert.mega_pyro_voltage(this.v_pyro()));
        altosDataListener.set_apogee_voltage(AltosConvert.mega_pyro_voltage(this.sense(4)));
        altosDataListener.set_main_voltage(AltosConvert.mega_pyro_voltage(this.sense(5)));
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = AltosConvert.mega_pyro_voltage(this.sense(i));
        }
        altosDataListener.set_igniter_voltage(dArray);
        AltosCalData altosCalData = altosDataListener.cal_data();
        altosCalData.set_ground_accel(this.ground_accel());
        altosCalData.set_ground_pressure(this.ground_pres());
        altosCalData.set_accel_plus_minus(this.accel_plus_g(), this.accel_minus_g());
        altosDataListener.set_kalman(this.height_16(), (double)this.speed() / 16.0, (double)this.acceleration() / 16.0);
    }
}

