/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.TreeSet;
import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosTelemetry;
import org.altusmetrum.altoslib_14.AltosTelemetryOrdered;
import org.altusmetrum.altoslib_14.AltosTelemetryOrderedIterator;

public class AltosTelemetryIterable
implements Iterable<AltosTelemetry> {
    TreeSet<AltosTelemetryOrdered> telems = new TreeSet();
    int tick = 0;
    int index = 0;

    public void add(AltosTelemetry altosTelemetry) {
        int n;
        if (!this.telems.isEmpty()) {
            for (n = altosTelemetry.tick(); n < this.tick - 1000; n += 65536) {
            }
        }
        this.tick = n;
        this.telems.add(new AltosTelemetryOrdered(altosTelemetry, this.index++, this.tick));
    }

    @Override
    public Iterator<AltosTelemetry> iterator() {
        return new AltosTelemetryOrderedIterator(this.telems);
    }

    public AltosTelemetryIterable(FileInputStream fileInputStream) throws IOException {
        String string;
        while ((string = AltosLib.gets(fileInputStream)) != null) {
            try {
                AltosTelemetry altosTelemetry = AltosTelemetry.parse(string);
                if (altosTelemetry == null) break;
                this.add(altosTelemetry);
            }
            catch (ParseException parseException) {
                System.out.printf("parse exception %s\n", parseException.getMessage());
            }
            catch (AltosCRCException altosCRCException) {}
        }
    }
}

