/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;

public class AltosSensorTM {
    public int tick;
    public int accel;
    public int pres;
    public int temp;
    public int batt;
    public int drogue;
    public int main;

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink) throws InterruptedException {
        try {
            AltosSensorTM altosSensorTM = new AltosSensorTM(altosLink);
            AltosCalData altosCalData = altosDataListener.cal_data();
            if (altosSensorTM == null) {
                return;
            }
            altosDataListener.set_acceleration(altosCalData.acceleration(altosSensorTM.accel));
            altosDataListener.set_pressure(AltosConvert.barometer_to_pressure(altosSensorTM.pres));
            altosDataListener.set_temperature(AltosConvert.thermometer_to_temperature(altosSensorTM.temp));
            altosDataListener.set_battery_voltage(AltosConvert.cc_battery_to_voltage(altosSensorTM.batt));
            altosDataListener.set_apogee_voltage(AltosConvert.cc_igniter_to_voltage(altosSensorTM.drogue));
            altosDataListener.set_main_voltage(AltosConvert.cc_igniter_to_voltage(altosSensorTM.main));
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public AltosSensorTM(AltosLink altosLink) throws InterruptedException, TimeoutException {
        String[] stringArray = altosLink.adc();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("tick:")) {
                this.tick = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("accel:")) {
                this.accel = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("pres:")) {
                this.pres = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("temp:")) {
                this.temp = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("batt:")) {
                this.batt = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("drogue:")) {
                this.drogue = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("main:")) {
                this.main = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            ++n;
        }
    }
}

