/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;

public class AltosSensorEMini {
    public int tick;
    public int apogee;
    public int main;
    public int batt;

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink, int n) throws InterruptedException {
        try {
            AltosSensorEMini altosSensorEMini = new AltosSensorEMini(altosLink);
            AltosCalData altosCalData = altosDataListener.cal_data();
            if (altosSensorEMini == null) {
                return;
            }
            switch (n) {
                case 1: {
                    altosDataListener.set_battery_voltage(AltosConvert.easy_mini_1_voltage(altosSensorEMini.batt, altosCalData.serial));
                    altosDataListener.set_apogee_voltage(AltosConvert.easy_mini_1_voltage(altosSensorEMini.apogee, altosCalData.serial));
                    altosDataListener.set_main_voltage(AltosConvert.easy_mini_1_voltage(altosSensorEMini.main, altosCalData.serial));
                    break;
                }
                case 2: {
                    altosDataListener.set_battery_voltage(AltosConvert.easy_mini_2_voltage(altosSensorEMini.batt));
                    altosDataListener.set_apogee_voltage(AltosConvert.easy_mini_2_voltage(altosSensorEMini.apogee));
                    altosDataListener.set_main_voltage(AltosConvert.easy_mini_2_voltage(altosSensorEMini.main));
                }
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public AltosSensorEMini(AltosLink altosLink) throws InterruptedException, TimeoutException {
        String[] stringArray = altosLink.adc();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("tick:")) {
                this.tick = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("apogee:")) {
                this.apogee = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("main:")) {
                this.main = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("batt:")) {
                this.batt = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            ++n;
        }
    }
}

