/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.altusmetrum.altoslib_14.AltosHexfile;
import org.altusmetrum.altoslib_14.AltosHexsym;
import org.altusmetrum.altoslib_14.AltosNoSymbol;
import org.altusmetrum.altoslib_14.AltosUnitInfo;
import org.altusmetrum.altoslib_14.AltosUnitInfoListener;
import org.altusmetrum.altoslib_14.AltosUsbId;

public class AltosRomconfig
implements AltosUnitInfoListener {
    public boolean valid;
    public boolean radio_calibration_broken;
    public int version;
    public int check;
    public int serial_number;
    public int radio_calibration;
    public int address_offset;
    public AltosUsbId usb_id;
    public String usb_product;
    static final int AO_USB_DESC_STRING = 3;
    static final String ao_romconfig_version = "ao_romconfig_version";
    static final String ao_romconfig_check = "ao_romconfig_check";
    static final String ao_serial_number = "ao_serial_number";
    static final String ao_radio_cal = "ao_radio_cal";
    static final String ao_usb_descriptors = "ao_usb_descriptors";
    Semaphore unit_info_done;
    static final int[] adjust_rom = new int[]{0, -4, 4};
    private static final String[] fetch_names = new String[]{"ao_romconfig_version", "ao_romconfig_check", "ao_serial_number", "ao_radio_cal", "ao_usb_descriptors"};
    private static final String[] required_names = new String[]{"ao_romconfig_version", "ao_romconfig_check", "ao_serial_number"};

    private static long find_address(AltosHexfile altosHexfile, String string, int n) throws AltosNoSymbol {
        AltosHexsym altosHexsym = altosHexfile.lookup_symbol(string);
        if (altosHexsym == null) {
            throw new AltosNoSymbol(string);
        }
        if (altosHexfile.address <= altosHexsym.address && altosHexsym.address + (long)n <= altosHexfile.max_address) {
            return altosHexsym.address;
        }
        throw new AltosNoSymbol(string);
    }

    private static int find_offset(AltosHexfile altosHexfile, String string, int n) throws AltosNoSymbol {
        return (int)(AltosRomconfig.find_address(altosHexfile, string, n) - altosHexfile.address);
    }

    private static int get_int(AltosHexfile altosHexfile, String string, int n, int n2) throws AltosNoSymbol {
        byte[] byArray = altosHexfile.data;
        int n3 = AltosRomconfig.find_offset(altosHexfile, string, n) + n2;
        int n4 = 0;
        int n5 = 0;
        while (n > 0) {
            n4 |= (byArray[n3] & 0xFF) << n5;
            ++n3;
            --n;
            n5 += 8;
        }
        return n4;
    }

    static void put_int(int n, AltosHexfile altosHexfile, String string, int n2) throws AltosNoSymbol, IOException {
        byte[] byArray = altosHexfile.data;
        int n3 = AltosRomconfig.find_offset(altosHexfile, string, n2);
        while (n2 > 0) {
            byArray[n3] = (byte)(n & 0xFF);
            ++n3;
            --n2;
            n >>= 8;
        }
    }

    static void put_string(String string, AltosHexfile altosHexfile, String string2) throws AltosNoSymbol {
        byte[] byArray = altosHexfile.data;
        int n = AltosRomconfig.find_offset(altosHexfile, string2, string.length());
        for (int i = 0; i < string.length(); ++i) {
            byArray[n + i] = (byte)string.charAt(i);
        }
    }

    static void put_usb_serial(int n, AltosHexfile altosHexfile, String string) throws AltosNoSymbol {
        int n2;
        byte[] byArray = altosHexfile.data;
        int n3 = 0;
        for (n2 = AltosRomconfig.find_offset(altosHexfile, string, 2); n2 < byArray.length && byArray[n2] != 0 && (byArray[n2 + 1] != 3 || ++n3 != 4); n2 += byArray[n2] & 0xFF) {
        }
        if (n2 >= byArray.length || byArray[n2] == 0) {
            throw new AltosNoSymbol(string);
        }
        int n4 = ((byArray[n2] & 0xFF) - 2) / 2;
        String string2 = String.format("%%0%dd", n4);
        String string3 = String.format(string2, n);
        if (string3.length() != n4) {
            throw new AltosNoSymbol(String.format("weird usb length issue %s isn't %d\n", string3, n4));
        }
        for (int i = 0; i < n4; ++i) {
            byArray[n2 + 2 + i * 2] = (byte)string3.charAt(i);
            byArray[n2 + 2 + i * 2 + 1] = 0;
        }
    }

    @Override
    public void notify_unit_info(AltosUnitInfo altosUnitInfo) {
        this.unit_info_done.release();
    }

    private void fetch_radio_cal() {
        this.unit_info_done = new Semaphore(0);
        AltosUnitInfo altosUnitInfo = new AltosUnitInfo(this.serial_number, this);
        this.radio_calibration_broken = true;
        try {
            this.unit_info_done.acquire();
            int n = altosUnitInfo.rfcal();
            if (n != Integer.MAX_VALUE) {
                this.radio_calibration = n;
                this.radio_calibration_broken = false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public AltosRomconfig(AltosHexfile altosHexfile) {
        try {
            for (int n : adjust_rom) {
                try {
                    this.version = AltosRomconfig.get_int(altosHexfile, ao_romconfig_version, 2, n);
                    this.check = AltosRomconfig.get_int(altosHexfile, ao_romconfig_check, 2, n);
                    if (this.check == (~this.version & 0xFFFF)) {
                        System.out.printf("adjust %d version %x check %x success\n", n, this.version, this.check);
                        switch (this.version) {
                            case 1: 
                            case 2: {
                                this.serial_number = AltosRomconfig.get_int(altosHexfile, ao_serial_number, 2, n);
                                try {
                                    this.radio_calibration = AltosRomconfig.get_int(altosHexfile, ao_radio_cal, 4, n);
                                }
                                catch (AltosNoSymbol altosNoSymbol) {
                                    this.radio_calibration = 0;
                                }
                                this.valid = true;
                                if (this.serial_number != 2584 && (3686 > this.serial_number || this.serial_number > 3938 || this.radio_calibration != 5695485)) break;
                                this.fetch_radio_cal();
                            }
                        }
                        break;
                    }
                    System.out.printf("adjust %d version %x check %x fail\n", n, this.version, this.check);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.printf("adjust %d out of bounds\n", n);
                }
            }
            this.usb_id = altosHexfile.find_usb_id();
            this.usb_product = altosHexfile.find_usb_product();
        }
        catch (AltosNoSymbol altosNoSymbol) {
            this.valid = false;
        }
    }

    private static int fetch_len(String string) {
        if (string.equals(ao_usb_descriptors)) {
            return 256;
        }
        return 2;
    }

    private static boolean name_required(String string) {
        for (String string2 : required_names) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static long fetch_base(AltosHexfile altosHexfile) throws AltosNoSymbol {
        long l = 0xFFFFFFFFL;
        for (String string : fetch_names) {
            try {
                int n = AltosRomconfig.fetch_len(string);
                long l2 = AltosRomconfig.find_address(altosHexfile, string, n);
                if (l2 >= l) continue;
                l = l2;
            }
            catch (AltosNoSymbol altosNoSymbol) {
                if (!AltosRomconfig.name_required(string)) continue;
                throw altosNoSymbol;
            }
        }
        return l;
    }

    public static long fetch_bounds(AltosHexfile altosHexfile) throws AltosNoSymbol {
        long l = 0L;
        for (String string : fetch_names) {
            try {
                int n = AltosRomconfig.fetch_len(string);
                long l2 = AltosRomconfig.find_address(altosHexfile, string, n) + (long)n;
                if (l2 <= l) continue;
                l = l2;
            }
            catch (AltosNoSymbol altosNoSymbol) {
                if (!AltosRomconfig.name_required(string)) continue;
                throw altosNoSymbol;
            }
        }
        return l;
    }

    public void write(AltosHexfile altosHexfile) throws IOException {
        if (!this.valid) {
            throw new IOException("rom configuration invalid");
        }
        AltosRomconfig altosRomconfig = new AltosRomconfig(altosHexfile);
        if (!altosRomconfig.valid) {
            throw new IOException("image does not contain existing rom config");
        }
        try {
            switch (altosRomconfig.version) {
                case 2: {
                    try {
                        AltosRomconfig.put_usb_serial(this.serial_number, altosHexfile, ao_usb_descriptors);
                    }
                    catch (AltosNoSymbol altosNoSymbol) {
                        // empty catch block
                    }
                }
                case 1: {
                    AltosRomconfig.put_int(this.serial_number, altosHexfile, ao_serial_number, 2);
                    try {
                        AltosRomconfig.put_int(this.radio_calibration, altosHexfile, ao_radio_cal, 4);
                        break;
                    }
                    catch (AltosNoSymbol altosNoSymbol) {
                        // empty catch block
                    }
                }
            }
        }
        catch (AltosNoSymbol altosNoSymbol) {
            throw new IOException(altosNoSymbol.getMessage());
        }
        AltosRomconfig altosRomconfig2 = new AltosRomconfig(altosHexfile);
        if (!altosRomconfig2.valid) {
            throw new IOException("writing new rom config failed\n");
        }
    }

    public String toString() {
        return String.format("valid %b version %d serial %d radio %d usb %04x:%04x %s", this.valid, this.version, this.serial_number, this.radio_calibration, this.usb_id == null ? 0 : this.usb_id.vid, this.usb_id == null ? 0 : this.usb_id.pid, this.usb_product == null ? "unknown" : this.usb_product);
    }

    public AltosRomconfig(int n, int n2) {
        this.valid = true;
        this.version = 1;
        this.check = ~this.version & 0xFFFF;
        this.serial_number = n;
        this.radio_calibration = n2;
    }

    public boolean valid() {
        return this.valid;
    }

    public AltosRomconfig() {
        this.valid = false;
    }
}

