/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.LinkedList;
import org.altusmetrum.altoslib_14.AltosFontListener;
import org.altusmetrum.altoslib_14.AltosImage;
import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosMapCache;
import org.altusmetrum.altoslib_14.AltosMapStore;
import org.altusmetrum.altoslib_14.AltosMapStoreListener;
import org.altusmetrum.altoslib_14.AltosMapTileListener;
import org.altusmetrum.altoslib_14.AltosMapTransform;

public class AltosMapTile
implements AltosFontListener,
AltosMapStoreListener {
    LinkedList<AltosMapTileListener> listeners = new LinkedList();
    public AltosLatLon upper_left;
    public AltosLatLon center;
    public int px_size;
    int zoom;
    int maptype;
    int scale;
    private AltosMapCache cache;
    public AltosMapStore store;
    public int status;
    public static final int loaded = 0;
    public static final int fetched = 1;
    public static final int fetching = 2;
    public static final int failed = 3;
    public static final int bad_request = 4;
    public static final int forbidden = 5;

    public static String status_name(int n) {
        switch (n) {
            case 0: {
                return "loaded";
            }
            case 1: {
                return "fetched";
            }
            case 2: {
                return "fetching";
            }
            case 3: {
                return "failed";
            }
            case 4: {
                return "bad_request";
            }
            case 5: {
                return "forbidden";
            }
        }
        return "unknown";
    }

    @Override
    public void font_size_changed(int n) {
    }

    private synchronized void notify_listeners(int n) {
        this.status = n;
        for (AltosMapTileListener altosMapTileListener : this.listeners) {
            altosMapTileListener.notify_tile(this, n);
        }
    }

    @Override
    public void notify_store(AltosMapStore altosMapStore, int n) {
        this.notify_listeners(n);
    }

    public void notify_image(AltosImage altosImage) {
        this.status = altosImage == null ? 3 : 0;
        this.notify_listeners(this.status);
    }

    public void paint(AltosMapTransform altosMapTransform) {
    }

    public AltosImage get_image() {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(this);
    }

    public synchronized void add_listener(AltosMapTileListener altosMapTileListener) {
        if (!this.listeners.contains(altosMapTileListener)) {
            this.listeners.add(altosMapTileListener);
        }
        altosMapTileListener.notify_tile(this, this.status);
    }

    public synchronized void remove_listener(AltosMapTileListener altosMapTileListener) {
        this.listeners.remove(altosMapTileListener);
    }

    public AltosMapTile(AltosMapCache altosMapCache, AltosLatLon altosLatLon, AltosLatLon altosLatLon2, int n, int n2, int n3, int n4) {
        this.cache = altosMapCache;
        this.upper_left = altosLatLon;
        while (altosLatLon2.lon < -180.0) {
            altosLatLon2.lon += 360.0;
        }
        while (altosLatLon2.lon > 180.0) {
            altosLatLon2.lon -= 360.0;
        }
        this.center = altosLatLon2;
        this.zoom = n;
        this.maptype = n2;
        this.px_size = n3;
        this.scale = n4;
        this.store = AltosMapStore.get(altosLatLon2, n, n2, n3, n4);
        this.store.add_listener(this);
    }
}

