/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.Semaphore;
import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosMap;
import org.altusmetrum.altoslib_14.AltosMapLoaderListener;
import org.altusmetrum.altoslib_14.AltosMapStore;
import org.altusmetrum.altoslib_14.AltosMapStoreListener;
import org.altusmetrum.altoslib_14.AltosMapTile;
import org.altusmetrum.altoslib_14.AltosMapTransform;
import org.altusmetrum.altoslib_14.AltosPointDouble;
import org.altusmetrum.altoslib_14.AltosPointInt;

public class AltosMapLoader
extends Thread
implements AltosMapStoreListener {
    AltosMapLoaderListener listener;
    double latitude;
    double longitude;
    int min_z;
    int max_z;
    int cur_z;
    int all_types;
    int cur_type;
    double radius;
    int scale;
    int tiles_loaded_layer;
    int tiles_loaded_total;
    int tiles_this_layer;
    int tiles_total;
    int layers_total;
    int layers_loaded;
    private static final int MAX_LOADING = 200;
    private Semaphore loading = new Semaphore(200);
    boolean abort;

    int tile_radius(int n) {
        double d = AltosMapTransform.lon_from_distance(this.latitude, this.radius);
        AltosMapTransform altosMapTransform = new AltosMapTransform(256, 256, n + 15, new AltosLatLon(this.latitude, this.longitude));
        AltosPointDouble altosPointDouble = altosMapTransform.point(new AltosLatLon(this.latitude, this.longitude));
        AltosPointDouble altosPointDouble2 = altosMapTransform.point(new AltosLatLon(this.latitude, this.longitude + d));
        int n2 = (int)Math.ceil(Math.abs(altosPointDouble.x - altosPointDouble2.x) / 512.0);
        return n2;
    }

    int tiles_per_layer(int n) {
        int n2 = this.tile_radius(n);
        return (n2 * 2 + 1) * (n2 * 2 + 1);
    }

    private boolean do_load() {
        this.tiles_this_layer = this.tiles_per_layer(this.cur_z);
        this.tiles_loaded_layer = 0;
        this.listener.debug("tiles_this_layer %d (zoom %d)\n", this.tiles_this_layer, this.cur_z);
        int n = this.tile_radius(this.cur_z);
        int n2 = this.cur_z + 15;
        int n3 = this.cur_type;
        AltosLatLon altosLatLon = new AltosLatLon(this.latitude, this.longitude);
        AltosMapTransform altosMapTransform = new AltosMapTransform(256, 256, n2, altosLatLon);
        AltosPointInt altosPointInt = AltosMap.floor(altosMapTransform.point(altosLatLon));
        AltosPointInt altosPointInt2 = new AltosPointInt(altosPointInt.x - n * 512, altosPointInt.y - n * 512);
        AltosPointInt altosPointInt3 = new AltosPointInt(altosPointInt.x + n * 512, altosPointInt.y + n * 512);
        for (int i = altosPointInt2.y; i <= altosPointInt3.y; i += 512) {
            for (int j = altosPointInt2.x; j <= altosPointInt3.x; j += 512) {
                try {
                    this.loading.acquire();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
                AltosPointInt altosPointInt4 = new AltosPointInt(j, i);
                AltosLatLon altosLatLon2 = altosMapTransform.lat_lon(altosPointInt4);
                AltosLatLon altosLatLon3 = altosMapTransform.lat_lon(new AltosPointDouble(j + 256, i + 256));
                AltosMapStore altosMapStore = AltosMapStore.get(altosLatLon3, n2, n3, 512, this.scale);
                this.listener.debug("load state %s url %s\n", AltosMapTile.status_name(altosMapStore.status()), altosMapStore.url);
                altosMapStore.add_listener(this);
                if (!this.abort) continue;
                return false;
            }
        }
        return true;
    }

    private int next_type(int n) {
        int n2;
        for (n2 = n; n2 <= 3 && (this.all_types & 1 << n2) == 0; ++n2) {
        }
        return n2;
    }

    private boolean next_load() {
        int n = this.next_type(this.cur_type + 1);
        if (n > 3) {
            if (this.cur_z == this.max_z) {
                return false;
            }
            ++this.cur_z;
            n = this.next_type(0);
        }
        this.cur_type = n;
        return true;
    }

    @Override
    public void run() {
        int n;
        this.cur_z = this.min_z;
        int n2 = 0;
        for (n = 0; n <= 3; ++n) {
            if ((this.all_types & 1 << n) == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            this.all_types = 1;
            n2 = 1;
        }
        this.cur_type = this.next_type(0);
        this.tiles_total = 0;
        for (n = this.min_z; n <= this.max_z; ++n) {
            this.tiles_total += this.tiles_per_layer(n) * n2;
        }
        this.layers_total = (this.max_z - this.min_z + 1) * n2;
        this.layers_loaded = 0;
        this.tiles_loaded_total = 0;
        this.listener.debug("total tiles %d layers %d\n", this.tiles_total, this.layers_total);
        this.listener.loader_start(this.tiles_total);
        while (this.do_load() && this.next_load()) {
        }
        if (this.abort) {
            this.listener.loader_done(this.tiles_total);
        }
    }

    @Override
    public synchronized void notify_store(AltosMapStore altosMapStore, int n) {
        boolean bl = false;
        if (n == 2) {
            return;
        }
        this.loading.release();
        altosMapStore.remove_listener(this);
        if (this.layers_loaded >= this.layers_total) {
            return;
        }
        ++this.tiles_loaded_total;
        ++this.tiles_loaded_layer;
        this.listener.debug("AltosMapLoader.notify_store status %d total %d of %d layer %d of %d\n", n, this.tiles_loaded_total, this.tiles_total, this.tiles_loaded_layer, this.tiles_this_layer);
        if (this.tiles_loaded_layer == this.tiles_this_layer) {
            ++this.layers_loaded;
            this.listener.debug("%d layers loaded\n", this.layers_loaded);
            bl = true;
        }
        if (this.tiles_loaded_total == this.tiles_total) {
            this.listener.loader_done(this.tiles_total);
        } else {
            this.listener.loader_notify(this.tiles_loaded_total, this.tiles_total, altosMapStore.file.toString());
        }
    }

    public void abort() {
        this.abort = true;
    }

    public AltosMapLoader(AltosMapLoaderListener altosMapLoaderListener, double d, double d2, int n, int n2, double d3, int n3, int n4) {
        altosMapLoaderListener.debug("lat %f lon %f min_z %d max_z %d radius %f all_types %d\n", d, d2, n, n2, d3, n3);
        this.listener = altosMapLoaderListener;
        this.latitude = d;
        this.longitude = d2;
        this.min_z = n;
        this.max_z = n2;
        this.radius = d3;
        this.all_types = 1;
        this.scale = n4;
        this.abort = false;
        this.start();
    }
}

