/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosLine;
import org.altusmetrum.altoslib_14.AltosPreferences;

public abstract class AltosLink
implements Runnable {
    public static final int ERROR = -1;
    public static final int TIMEOUT = -2;
    public static boolean debug = false;
    public boolean has_error = false;
    LinkedList<String> pending_output = new LinkedList();
    public LinkedList<LinkedBlockingQueue<AltosLine>> monitors = new LinkedList();
    public LinkedBlockingQueue<AltosLine> reply_queue = new LinkedBlockingQueue();
    public LinkedBlockingQueue<byte[]> binary_queue = new LinkedBlockingQueue();
    private String match_string = null;
    public boolean reply_abort;
    public int in_reply;
    boolean cancel_enable = true;
    boolean reply_timeout_shown = false;
    private int len_read = 0;
    public boolean monitor_mode = false;
    public int telemetry = 1;
    public int telemetry_rate = -1;
    public double frequency;
    public String callsign = "";
    private AltosConfigData config_data_local;
    private AltosConfigData config_data_remote;
    private Object config_data_lock = new Object();
    public boolean remote;
    public int serial;
    public String name;

    public abstract int getchar() throws InterruptedException;

    public abstract void print(String var1) throws InterruptedException;

    public abstract void putchar(byte var1);

    public abstract void close() throws InterruptedException;

    public static void set_debug(boolean bl) {
        debug = bl;
    }

    public synchronized void add_monitor(LinkedBlockingQueue<AltosLine> linkedBlockingQueue) {
        this.set_monitor(true);
        this.monitors.add(linkedBlockingQueue);
    }

    public synchronized void remove_monitor(LinkedBlockingQueue<AltosLine> linkedBlockingQueue) {
        this.monitors.remove(linkedBlockingQueue);
        if (this.monitors.isEmpty()) {
            this.set_monitor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printf(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        if (debug) {
            LinkedList<String> linkedList = this.pending_output;
            synchronized (linkedList) {
                this.pending_output.add(string2);
            }
        }
        try {
            this.print(string2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String get_reply_no_dialog(int n) throws InterruptedException, TimeoutException {
        this.flush_output();
        AltosLine altosLine = this.reply_queue.poll(n, TimeUnit.MILLISECONDS);
        if (altosLine != null) {
            return altosLine.line;
        }
        return null;
    }

    public String get_reply() throws InterruptedException {
        return this.get_reply(5000);
    }

    public abstract boolean can_cancel_reply();

    public abstract boolean show_reply_timeout();

    public abstract void hide_reply_timeout();

    public void set_cancel_enable(boolean bl) {
        this.cancel_enable = bl;
    }

    private boolean check_reply_timeout() {
        if (!this.cancel_enable) {
            return false;
        }
        if (!this.reply_timeout_shown) {
            this.reply_timeout_shown = this.show_reply_timeout();
        }
        return this.reply_abort;
    }

    private void cleanup_reply_timeout() {
        if (this.reply_timeout_shown) {
            this.reply_timeout_shown = false;
            this.hide_reply_timeout();
        }
    }

    private boolean match_bytes(byte[] byArray, int n, String string) {
        if (n < string.length()) {
            return false;
        }
        String string2 = new String(byArray, 0, n, AltosLib.unicode_set);
        if (string2 == null) {
            return false;
        }
        return string2.indexOf(string) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] byArray = null;
        int n = 0;
        try {
            while (true) {
                int n2 = this.getchar();
                if (Thread.interrupted()) {
                    return;
                }
                if (n2 == -1) {
                    if (debug) {
                        System.out.printf("ERROR\n", new Object[0]);
                    }
                    this.has_error = true;
                    this.add_telem(new AltosLine());
                    this.add_reply(new AltosLine());
                    return;
                }
                if (n2 == -2) {
                    if (!debug) continue;
                    System.out.printf("TIMEOUT\n", new Object[0]);
                    continue;
                }
                if (n2 == 13 && this.len_read == 0) continue;
                AltosLink altosLink = this;
                synchronized (altosLink) {
                    if (n2 == 10 && this.len_read == 0) {
                        if (n != 0) {
                            this.add_bytes(byArray, n);
                            n = 0;
                        }
                    } else {
                        if (byArray == null) {
                            byArray = new byte[256];
                        } else if (n == byArray.length) {
                            byte[] byArray2 = new byte[n * 2];
                            System.arraycopy(byArray, 0, byArray2, 0, n);
                            byArray = byArray2;
                        }
                        byArray[n] = (byte)n2;
                        if (this.len_read != 0 && ++n == this.len_read) {
                            this.add_binary(byArray, n);
                            n = 0;
                            this.len_read = 0;
                        }
                        if (this.match_string != null && this.match_bytes(byArray, n, this.match_string)) {
                            this.match_string = null;
                            this.add_bytes(byArray, n);
                            n = 0;
                        }
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void set_match(String string) {
        this.match_string = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_reply(int n) throws InterruptedException {
        String string;
        block9: {
            boolean bl = this.can_cancel_reply();
            string = null;
            if (this.remote && bl) {
                n = 500;
                switch (this.telemetry_rate) {
                    default: {
                        n = 500;
                        break;
                    }
                    case 1: {
                        n = 2000;
                        break;
                    }
                    case 2: {
                        n = 8000;
                    }
                }
            }
            try {
                ++this.in_reply;
                this.flush_output();
                this.reply_abort = false;
                this.reply_timeout_shown = false;
                do {
                    AltosLine altosLine;
                    if ((altosLine = this.reply_queue.poll(n, TimeUnit.MILLISECONDS)) == null) continue;
                    this.cleanup_reply_timeout();
                    string = altosLine.line;
                    break block9;
                } while (this.remote && bl && !this.check_reply_timeout());
                string = null;
            }
            finally {
                --this.in_reply;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get_binary_reply(int n, int n2) throws InterruptedException {
        byte[] byArray;
        block7: {
            boolean bl = this.can_cancel_reply();
            byArray = null;
            AltosLink altosLink = this;
            synchronized (altosLink) {
                this.len_read = n2;
            }
            try {
                ++this.in_reply;
                this.flush_output();
                this.reply_abort = false;
                this.reply_timeout_shown = false;
                do {
                    if ((byArray = this.binary_queue.poll(n, TimeUnit.MILLISECONDS)) == null) continue;
                    this.cleanup_reply_timeout();
                    break block7;
                } while (this.remote && bl && !this.check_reply_timeout());
                byArray = null;
            }
            finally {
                --this.in_reply;
            }
        }
        return byArray;
    }

    public void add_telem(AltosLine altosLine) throws InterruptedException {
        for (int i = 0; i < this.monitors.size(); ++i) {
            LinkedBlockingQueue<AltosLine> linkedBlockingQueue = this.monitors.get(i);
            linkedBlockingQueue.put(altosLine);
        }
    }

    public void add_reply(AltosLine altosLine) throws InterruptedException {
        this.reply_queue.put(altosLine);
    }

    public void abort_reply() {
        try {
            this.add_telem(new AltosLine());
            this.add_reply(new AltosLine());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void add_string(String string) throws InterruptedException {
        if (string.startsWith("TELEM") || string.startsWith("VERSION") || string.startsWith("CRC")) {
            this.add_telem(new AltosLine(string));
        } else {
            this.add_reply(new AltosLine(string));
        }
    }

    public void add_bytes(byte[] byArray, int n) throws InterruptedException {
        String string = new String(byArray, 0, n, AltosLib.unicode_set);
        if (debug) {
            System.out.printf("\t\t\t\t\t%s\n", string);
        }
        this.add_string(string);
    }

    public void add_binary(byte[] byArray, int n) throws InterruptedException {
        byte[] byArray2 = new byte[n];
        if (debug) {
            System.out.printf("\t\t\t\t\t%d:", n);
        }
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i];
            if (!debug) continue;
            System.out.printf(" %02x", byArray2[i]);
        }
        if (debug) {
            System.out.printf("\n", new Object[0]);
        }
        this.binary_queue.put(byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush_output() {
        if (this.pending_output == null) {
            return;
        }
        LinkedList<String> linkedList = this.pending_output;
        synchronized (linkedList) {
            for (String string : this.pending_output) {
                System.out.print(string);
            }
            this.pending_output.clear();
        }
    }

    public void flush_input(int n) throws InterruptedException {
        boolean bl;
        this.flush_output();
        do {
            Thread.sleep(n);
            bl = !this.reply_queue.isEmpty();
            this.reply_queue.clear();
        } while (bl);
    }

    public void flush_input() throws InterruptedException {
        if (this.remote) {
            int n = 500;
            switch (this.telemetry_rate) {
                default: {
                    n = 500;
                    break;
                }
                case 1: {
                    n = 1000;
                    break;
                }
                case 2: {
                    n = 2000;
                }
            }
            this.flush_input(n);
        } else {
            this.flush_input(100);
        }
    }

    private int telemetry_len() {
        return AltosLib.telemetry_len(this.telemetry);
    }

    private void set_radio_freq(int n) {
        if (this.monitor_mode) {
            this.printf("m 0\nc F %d\nm %x\n", n, this.telemetry_len());
        } else {
            this.printf("c F %d\n", n);
        }
        this.flush_output();
    }

    public void set_radio_frequency(double d, boolean bl, boolean bl2, int n) {
        if (debug) {
            System.out.printf("set_radio_frequency %7.3f (freq %b) (set %b) %d\n", d, bl, bl2, n);
        }
        if (d == 0.0 || d == 2.147483647E9) {
            return;
        }
        if (bl) {
            this.set_radio_freq((int)Math.floor(d * 1000.0 + 0.5));
        } else if (bl2) {
            this.set_radio_setting(AltosConvert.radio_frequency_to_setting(d, n));
        } else {
            this.set_channel(AltosConvert.radio_frequency_to_channel(d));
        }
    }

    public void set_radio_frequency(double d) throws InterruptedException, TimeoutException {
        this.frequency = d;
        AltosConfigData altosConfigData = this.config_data();
        this.set_radio_frequency(this.frequency, altosConfigData.radio_frequency > 0, altosConfigData.radio_setting > 0, altosConfigData.radio_calibration);
    }

    public void set_telemetry(int n) {
        this.telemetry = n;
        if (this.monitor_mode) {
            this.printf("m 0\nm %x\n", this.telemetry_len());
        }
        this.flush_output();
    }

    public void set_telemetry_rate(int n) {
        this.telemetry_rate = n;
        if (this.monitor_mode) {
            this.printf("m 0\nc T %d\nm %x\n", this.telemetry_rate, this.telemetry_len());
        } else {
            this.printf("c T %d\n", this.telemetry_rate);
        }
        this.flush_output();
    }

    public synchronized void set_monitor(boolean bl) {
        this.monitor_mode = bl;
        if (bl) {
            this.printf("m %x\n", this.telemetry_len());
        } else {
            this.printf("m 0\n", new Object[0]);
        }
        this.flush_output();
    }

    public synchronized boolean get_monitor() {
        return this.monitor_mode;
    }

    private void set_channel(int n) {
        if (this.monitor_mode) {
            this.printf("m 0\nc r %d\nm %x\n", n, this.telemetry_len());
        } else {
            this.printf("c r %d\n", n);
        }
        this.flush_output();
    }

    private void set_radio_setting(int n) {
        if (this.monitor_mode) {
            this.printf("m 0\nc R %d\nm %x\n", n, this.telemetry_len());
        } else {
            this.printf("c R %d\n", n);
        }
        this.flush_output();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AltosConfigData config_data() throws InterruptedException, TimeoutException {
        Object object = this.config_data_lock;
        synchronized (object) {
            AltosConfigData altosConfigData;
            if (this.remote) {
                if (this.config_data_remote == null) {
                    this.printf("m 0\n", new Object[0]);
                    this.config_data_remote = new AltosConfigData(this);
                    if (this.monitor_mode) {
                        this.set_monitor(true);
                    }
                }
                altosConfigData = this.config_data_remote;
            } else {
                if (this.config_data_local == null) {
                    this.printf("m 0\n", new Object[0]);
                    this.config_data_local = new AltosConfigData(this);
                    if (this.monitor_mode) {
                        this.set_monitor(true);
                    }
                }
                altosConfigData = this.config_data_local;
            }
            return altosConfigData;
        }
    }

    public void set_callsign(String string) {
        this.callsign = string;
        if (string != null) {
            this.printf("c c %s\n", string);
            this.flush_output();
        }
    }

    public boolean is_loader() throws InterruptedException {
        boolean bl = false;
        this.printf("v\n", new Object[0]);
        while (true) {
            String string;
            if ((string = this.get_reply()) == null) {
                return false;
            }
            if (string.startsWith("software-version")) break;
            if (!string.startsWith("altos-loader")) continue;
            bl = true;
        }
        return bl;
    }

    public void to_loader() throws InterruptedException {
        this.printf("X\n", new Object[0]);
        this.flush_output();
        this.close();
        Thread.sleep(1000L);
    }

    public void start_remote() throws TimeoutException, InterruptedException {
        if (this.frequency == 0.0 || this.frequency == 2.147483647E9) {
            this.frequency = AltosPreferences.frequency(this.serial);
        }
        if (debug) {
            System.out.printf("start remote %7.3f\n", this.frequency);
        }
        this.set_radio_frequency(this.frequency);
        if (this.telemetry_rate < 0) {
            this.telemetry_rate = AltosPreferences.telemetry_rate(this.serial);
        }
        this.set_telemetry_rate(this.telemetry_rate);
        if (this.callsign == null || this.callsign.equals("")) {
            this.callsign = AltosPreferences.callsign();
        }
        this.set_callsign(this.callsign);
        this.printf("p\nE 0\n", new Object[0]);
        this.flush_input();
        this.remote = true;
    }

    public void stop_remote() throws InterruptedException {
        if (debug) {
            System.out.printf("stop remote\n", new Object[0]);
        }
        try {
            this.flush_output();
            this.flush_input();
        }
        finally {
            this.printf("~\n", new Object[0]);
            this.flush_output();
        }
        this.remote = false;
    }

    public int rssi() throws TimeoutException, InterruptedException {
        if (this.remote) {
            return 0;
        }
        this.printf("s\n", new Object[0]);
        String string = this.get_reply_no_dialog(5000);
        if (string == null) {
            throw new TimeoutException();
        }
        String[] stringArray = string.split("\\s+");
        if (stringArray.length < 2) {
            return 0;
        }
        if (!stringArray[0].equals("RSSI:")) {
            return 0;
        }
        int n = Integer.parseInt(stringArray[1]);
        return n;
    }

    public String[] adc() throws TimeoutException, InterruptedException {
        String string;
        this.printf("a\n", new Object[0]);
        do {
            if ((string = this.get_reply_no_dialog(5000)) != null) continue;
            throw new TimeoutException();
        } while (!string.startsWith("tick:"));
        String[] stringArray = string.split("\\s+");
        return stringArray;
    }

    public boolean has_monitor_battery() {
        try {
            return this.config_data().has_monitor_battery();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }

    public double monitor_battery() throws InterruptedException {
        double d = 2.147483647E9;
        try {
            AltosConfigData altosConfigData = this.config_data();
            int n = Integer.MAX_VALUE;
            if (altosConfigData.has_monitor_battery()) {
                String[] stringArray = this.adc();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equals("batt")) {
                        n = Integer.parseInt(stringArray[n2 + 1]);
                        n2 += 2;
                        continue;
                    }
                    ++n2;
                }
            }
            if (n != Integer.MAX_VALUE) {
                d = altosConfigData.product.startsWith("TeleBT-v3") || altosConfigData.product.startsWith("TeleBT-v4") ? AltosConvert.tele_bt_3_battery(n) : AltosConvert.cc_battery_to_voltage(n);
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return d;
    }
}

