/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.altusmetrum.altoslib_14.AltosEepromFile;
import org.altusmetrum.altoslib_14.AltosRecordSet;
import org.altusmetrum.altoslib_14.AltosTelemetryFile;

public class AltosLib {
    public static final int AO_LOG_FLIGHT = 70;
    public static final int AO_LOG_SENSOR = 65;
    public static final int AO_LOG_TEMP_VOLT = 84;
    public static final int AO_LOG_DEPLOY = 68;
    public static final int AO_LOG_STATE = 83;
    public static final int AO_LOG_GPS_POS = 80;
    public static final int AO_LOG_GPS_TIME = 71;
    public static final int AO_LOG_GPS_LAT = 78;
    public static final int AO_LOG_GPS_LON = 87;
    public static final int AO_LOG_GPS_ALT = 72;
    public static final int AO_LOG_GPS_SAT = 86;
    public static final int AO_LOG_GPS_DATE = 89;
    public static final int AO_LOG_PRESSURE = 80;
    public static final int AO_LOG_CONFIG_VERSION = 1000;
    public static final int AO_LOG_MAIN_DEPLOY = 1001;
    public static final int AO_LOG_APOGEE_DELAY = 1002;
    public static final int AO_LOG_RADIO_CHANNEL = 1003;
    public static final int AO_LOG_CALLSIGN = 1004;
    public static final int AO_LOG_ACCEL_CAL = 1005;
    public static final int AO_LOG_RADIO_CAL = 1006;
    public static final int AO_LOG_MAX_FLIGHT_LOG = 1007;
    public static final int AO_LOG_MANUFACTURER = 2000;
    public static final int AO_LOG_PRODUCT = 2001;
    public static final int AO_LOG_SERIAL_NUMBER = 2002;
    public static final int AO_LOG_LOG_FORMAT = 2003;
    public static final int AO_LOG_FREQUENCY = 2004;
    public static final int AO_LOG_APOGEE_LOCKOUT = 2005;
    public static final int AO_LOG_RADIO_RATE = 2006;
    public static final int AO_LOG_IGNITE_MODE = 2007;
    public static final int AO_LOG_PAD_ORIENTATION = 2008;
    public static final int AO_LOG_RADIO_ENABLE = 2009;
    public static final int AO_LOG_AES_KEY = 2010;
    public static final int AO_LOG_APRS = 2011;
    public static final int AO_LOG_BEEP_SETTING = 2012;
    public static final int AO_LOG_TRACKER_SETTING = 2013;
    public static final int AO_LOG_PYRO_TIME = 2014;
    public static final int AO_LOG_APRS_ID = 2015;
    public static final int AO_LOG_ALTITUDE_32 = 2016;
    public static final int AO_LOG_BARO_RESERVED = 3000;
    public static final int AO_LOG_BARO_SENS = 3001;
    public static final int AO_LOG_BARO_OFF = 3002;
    public static final int AO_LOG_BARO_TCS = 3004;
    public static final int AO_LOG_BARO_TCO = 3005;
    public static final int AO_LOG_BARO_TREF = 3006;
    public static final int AO_LOG_BARO_TEMPSENS = 3007;
    public static final int AO_LOG_BARO_CRC = 3008;
    public static final int AO_LOG_IMU_CAL = 3009;
    public static final int AO_LOG_SOFTWARE_VERSION = 9999;
    public static final int MISSING = Integer.MAX_VALUE;
    public static final int AO_LOG_INVALID = -1;
    public static final int ao_flight_startup = 0;
    public static final int ao_flight_idle = 1;
    public static final int ao_flight_pad = 2;
    public static final int ao_flight_boost = 3;
    public static final int ao_flight_fast = 4;
    public static final int ao_flight_coast = 5;
    public static final int ao_flight_drogue = 6;
    public static final int ao_flight_main = 7;
    public static final int ao_flight_landed = 8;
    public static final int ao_flight_invalid = 9;
    public static final int ao_flight_stateless = 10;
    public static final int vendor_altusmetrum = 65534;
    public static final int product_altusmetrum = 10;
    public static final int product_telemetrum = 11;
    public static final int product_teledongle = 12;
    public static final int product_easytimer = 13;
    public static final int product_telebt = 14;
    public static final int product_telelaunch = 15;
    public static final int product_telelco = 16;
    public static final int product_telescience = 17;
    public static final int product_telepyro = 18;
    public static final int product_telemega = 35;
    public static final int product_megadongle = 36;
    public static final int product_telegps = 37;
    public static final int product_easymini = 38;
    public static final int product_telemini = 39;
    public static final int product_easymega = 40;
    public static final int product_usbtrng = 41;
    public static final int product_usbrelay = 42;
    public static final int product_mpusb = 43;
    public static final int product_easymotor = 44;
    public static final int product_altusmetrum_min = 10;
    public static final int product_altusmetrum_max = 44;
    public static final int product_any = 65536;
    public static final int product_basestation = 65537;
    public static final int product_altimeter = 65538;
    private static Product[] products = new Product[]{new Product("telemetrum", 11), new Product("teleballoon", 11), new Product("teledongle", 12), new Product("easytimer", 13), new Product("telebt", 14), new Product("telelaunch", 15), new Product("telelco", 16), new Product("telescience", 17), new Product("telepyro", 18), new Product("telemega", 35), new Product("megadongle", 36), new Product("telegps", 37), new Product("easymini", 38), new Product("telemini", 39), new Product("easymega", 40), new Product("easymotor", 44)};
    public static final String bt_product_telebt = "TeleBT";
    public static final double ao_battery_good = 3.8;
    public static final double ao_igniter_good = 3.5;
    public static final int ao_telemetry_off = 0;
    public static final int ao_telemetry_min = 1;
    public static final int ao_telemetry_standard = 1;
    public static final int ao_telemetry_0_9 = 2;
    public static final int ao_telemetry_0_8 = 3;
    public static final int ao_telemetry_max = 3;
    private static final String[] ao_telemetry_name = new String[]{"Off", "Standard Telemetry", "TeleMetrum v0.9", "TeleMetrum v0.8"};
    public static final int ao_telemetry_rate_38400 = 0;
    public static final int ao_telemetry_rate_9600 = 1;
    public static final int ao_telemetry_rate_2400 = 2;
    public static final int ao_telemetry_rate_max = 2;
    public static final Integer[] ao_telemetry_rate_values = new Integer[]{38400, 9600, 2400};
    public static final int ao_aprs_format_compressed = 0;
    public static final int ao_aprs_format_uncompressed = 1;
    public static final String[] ao_aprs_format_name = new String[]{"Compressed", "Uncompressed"};
    public static final String launch_sites_url = "https://maps.altusmetrum.org/launch-sites.txt";
    public static final String launch_sites_env = "LAUNCH_SITES";
    public static final String unit_info_url = "https://altusmetrum.org/cgi-bin/unitinfo.cgi?sn=%d";
    public static final String unit_info_env = "UNIT_INFO";
    public static final int ao_telemetry_standard_len = 32;
    public static final int ao_telemetry_0_9_len = 95;
    public static final int ao_telemetry_0_8_len = 94;
    private static final int[] ao_telemetry_len = new int[]{0, 32, 95, 94};
    private static HashMap<String, Integer> string_to_state = new HashMap();
    private static boolean map_initialized = false;
    private static String[] state_to_string = new String[]{"startup", "idle", "pad", "boost", "fast", "coast", "drogue", "main", "landed", "invalid", "stateless"};
    private static String[] state_to_string_capital = new String[]{"Startup", "Idle", "Pad", "Boost", "Fast", "Coast", "Drogue", "Main", "Landed", "Invalid", "Stateless"};
    public static final int AO_GPS_VALID = 16;
    public static final int AO_GPS_RUNNING = 32;
    public static final int AO_GPS_DATE_VALID = 64;
    public static final int AO_GPS_NUM_SAT_SHIFT = 0;
    public static final int AO_GPS_NUM_SAT_MASK = 15;
    public static final int AO_PAD_ORIENTATION_ANTENNA_UP = 0;
    public static final int AO_PAD_ORIENTATION_ANTENNA_DOWN = 1;
    public static final int AO_PAD_ORIENTATION_WORDS_UPRIGHT = 2;
    public static final int AO_PAD_ORIENTATION_WORDS_UPSIDEDOWN = 3;
    public static final int AO_PAD_ORIENTATION_BIG_PARTS_UP = 4;
    public static final int AO_PAD_ORIENTATION_BIG_PARTS_DOWN = 5;
    public static final int AO_LOG_FORMAT_UNKNOWN = 0;
    public static final int AO_LOG_FORMAT_FULL = 1;
    public static final int AO_LOG_FORMAT_TINY = 2;
    public static final int AO_LOG_FORMAT_TELEMETRY = 3;
    public static final int AO_LOG_FORMAT_TELESCIENCE = 4;
    public static final int AO_LOG_FORMAT_TELEMEGA_OLD = 5;
    public static final int AO_LOG_FORMAT_EASYMINI1 = 6;
    public static final int AO_LOG_FORMAT_TELEMETRUM = 7;
    public static final int AO_LOG_FORMAT_TELEMINI2 = 8;
    public static final int AO_LOG_FORMAT_TELEGPS = 9;
    public static final int AO_LOG_FORMAT_TELEMEGA = 10;
    public static final int AO_LOG_FORMAT_DETHERM = 11;
    public static final int AO_LOG_FORMAT_TELEMINI3 = 12;
    public static final int AO_LOG_FORMAT_TELEFIRETWO = 13;
    public static final int AO_LOG_FORMAT_EASYMINI2 = 14;
    public static final int AO_LOG_FORMAT_TELEMEGA_3 = 15;
    public static final int AO_LOG_FORMAT_EASYMEGA_2 = 16;
    public static final int AO_LOG_FORMAT_TELESTATIC = 17;
    public static final int AO_LOG_FORMAT_MICROPEAK2 = 18;
    public static final int AO_LOG_FORMAT_TELEMEGA_4 = 19;
    public static final int AO_LOG_FORMAT_EASYMOTOR = 20;
    public static final int AO_LOG_FORMAT_NONE = 127;
    public static final Charset unicode_set = Charset.forName("UTF-8");

    public static boolean is_gps_cmd(int n) {
        switch (n) {
            case 71: 
            case 72: 
            case 78: 
            case 80: 
            case 86: 
            case 87: 
            case 89: {
                return true;
            }
        }
        return false;
    }

    public static int name_to_product(String string) {
        String string2 = string.toLowerCase();
        for (int i = 0; i < products.length; ++i) {
            if (!string2.startsWith(AltosLib.products[i].name)) continue;
            return AltosLib.products[i].product;
        }
        return 65536;
    }

    public static boolean has_9dof(int n) {
        return n == 35 || n == 40;
    }

    public static boolean has_radio(int n) {
        return n != 38 && n != 40;
    }

    public static boolean has_gps(int n) {
        return n == 11 || n == 35 || n == 37;
    }

    public static void initialize_map() {
        string_to_state.put("startup", 0);
        string_to_state.put("idle", 1);
        string_to_state.put("pad", 2);
        string_to_state.put("boost", 3);
        string_to_state.put("fast", 4);
        string_to_state.put("coast", 5);
        string_to_state.put("drogue", 6);
        string_to_state.put("apogee", 5);
        string_to_state.put("main", 7);
        string_to_state.put("landed", 8);
        string_to_state.put("invalid", 9);
        string_to_state.put("stateless", 10);
        map_initialized = true;
    }

    public static int telemetry_len(int n) {
        if (n <= 3) {
            return ao_telemetry_len[n];
        }
        throw new IllegalArgumentException(String.format("Invalid telemetry %d", n));
    }

    public static String telemetry_name(int n) {
        if (n <= 3) {
            return ao_telemetry_name[n];
        }
        throw new IllegalArgumentException(String.format("Invalid telemetry %d", n));
    }

    private static int[] split_version(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static int compare_version(String string, String string2) {
        int[] nArray = AltosLib.split_version(string);
        int[] nArray2 = AltosLib.split_version(string2);
        for (int i = 0; i < Math.min(nArray.length, nArray2.length); ++i) {
            if (nArray[i] < nArray2[i]) {
                return -1;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return 1;
        }
        if (nArray.length < nArray2.length) {
            return -1;
        }
        if (nArray.length > nArray2.length) {
            return 1;
        }
        return 0;
    }

    public static int state(String string) {
        if (!map_initialized) {
            AltosLib.initialize_map();
        }
        if (string_to_state.containsKey(string)) {
            return string_to_state.get(string);
        }
        return 9;
    }

    public static String state_name(int n) {
        if (n < 0 || state_to_string.length <= n) {
            return "invalid";
        }
        return state_to_string[n];
    }

    public static String state_name_capital(int n) {
        if (n < 0 || state_to_string.length <= n) {
            return "Invalid";
        }
        return state_to_string_capital[n];
    }

    public static boolean isspace(int n) {
        switch (n) {
            case 9: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static final boolean ishex(int n) {
        if (48 <= n && n <= 57) {
            return true;
        }
        if (97 <= n && n <= 102) {
            return true;
        }
        return 65 <= n && n <= 70;
    }

    public static final boolean ishex(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (AltosLib.ishex(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int fromhex(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (97 <= n && n <= 102) {
            return n - 97 + 10;
        }
        if (65 <= n && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    public static int fromhex(String string) throws NumberFormatException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!AltosLib.ishex(c)) {
                if (i == 0) {
                    throw new NumberFormatException(String.format("invalid hex \"%s\"", string));
                }
                return n;
            }
            n = n * 16 + AltosLib.fromhex(c);
        }
        return n;
    }

    public static boolean isdec(int n) {
        return 48 <= n && n <= 57;
    }

    public static boolean isdec(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (AltosLib.isdec(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int fromdec(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        return -1;
    }

    public static int int8(int[] nArray, int n) {
        return (byte)nArray[n];
    }

    public static int uint8(int[] nArray, int n) {
        return nArray[n];
    }

    public static int int16(int[] nArray, int n) {
        return (short)(nArray[n] + (nArray[n + 1] << 8));
    }

    public static int uint16(int[] nArray, int n) {
        return nArray[n] + (nArray[n + 1] << 8);
    }

    public static int uint32(int[] nArray, int n) {
        return nArray[n] + (nArray[n + 1] << 8) + (nArray[n + 2] << 16) + (nArray[n + 3] << 24);
    }

    public static int int32(int[] nArray, int n) {
        return AltosLib.uint32(nArray, n);
    }

    public static String string(int[] nArray, int n, int n2) {
        int n3;
        if (n + n2 > nArray.length) {
            if (n > nArray.length) {
                n = nArray.length;
                n2 = 0;
            } else {
                n2 = nArray.length - n;
            }
        }
        for (n3 = n2 - 1; n3 >= 0 && nArray[n + n3] == 0; --n3) {
        }
        n2 = n3 + 1;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            byArray[n3] = (byte)nArray[n + n3];
        }
        String string = new String(byArray, unicode_set);
        return string;
    }

    public static int hexbyte(String string, int n) {
        if (string.length() < n + 2) {
            throw new NumberFormatException(String.format("invalid hex \"%s\"", string));
        }
        char c = string.charAt(n);
        if (!AltosLib.ishex(c)) {
            throw new NumberFormatException(String.format("invalid hex \"%c\"", c));
        }
        char c2 = string.charAt(n + 1);
        if (!AltosLib.ishex(c2)) {
            throw new NumberFormatException(String.format("invalid hex \"%c\"", c2));
        }
        return AltosLib.fromhex(c) * 16 + AltosLib.fromhex(c2);
    }

    public static int[] hexbytes(String string) {
        if ((string.length() & 1) != 0) {
            throw new NumberFormatException(String.format("invalid line \"%s\"", string));
        }
        byte[] byArray = string.getBytes(unicode_set);
        int n = byArray.length / 2;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = AltosLib.fromhex(byArray[i << 1]);
            int n3 = AltosLib.fromhex(byArray[(i << 1) + 1]);
            if (n2 < 0 || n3 < 0) {
                throw new NumberFormatException(String.format("invalid hex \"%c%c\"", byArray[i << 1], byArray[(i << 1) + 1]));
            }
            nArray[i] = (n2 << 4) + n3;
        }
        return nArray;
    }

    public static long fromdec(String string) throws NumberFormatException {
        long l = 0L;
        long l2 = 1L;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 && c == '-') {
                l2 = -1L;
                continue;
            }
            if (!AltosLib.isdec(c)) {
                if (i == 0) {
                    throw new NumberFormatException(String.format("invalid number \"%s\"", string));
                }
                return l;
            }
            l = l * 10L + (long)AltosLib.fromdec(c);
        }
        return l * l2;
    }

    public static String gets(FileInputStream fileInputStream) throws IOException {
        int n;
        String string = "";
        while ((n = fileInputStream.read()) != -1) {
            if (n == 13) continue;
            if (n == 10) {
                return string;
            }
            string = string + (char)n;
        }
        return null;
    }

    public static String replace_extension(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string.concat(string2);
    }

    public static File replace_extension(File file, String string) {
        return new File(AltosLib.replace_extension(file.getPath(), string));
    }

    public static String product_name(int n) {
        switch (n) {
            case 10: {
                return "AltusMetrum";
            }
            case 11: {
                return "TeleMetrum";
            }
            case 12: {
                return "TeleDongle";
            }
            case 13: {
                return "EasyTimer";
            }
            case 14: {
                return bt_product_telebt;
            }
            case 15: {
                return "TeleLaunch";
            }
            case 16: {
                return "TeleLco";
            }
            case 17: {
                return "Telescience";
            }
            case 18: {
                return "TelePyro";
            }
            case 35: {
                return "TeleMega";
            }
            case 36: {
                return "MegaDongle";
            }
            case 37: {
                return "TeleGPS";
            }
            case 38: {
                return "EasyMini";
            }
            case 39: {
                return "TeleMini";
            }
            case 44: {
                return "EasyMotor";
            }
        }
        return "unknown";
    }

    public static String igniter_name(int n) {
        return String.format("Igniter %c", 65 + n);
    }

    public static String igniter_short_name(int n) {
        return String.format("igniter_%c", 97 + n);
    }

    public static AltosRecordSet record_set(File file) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        if (file.getName().endsWith("telem")) {
            return new AltosTelemetryFile(fileInputStream);
        }
        if (file.getName().endsWith("eeprom")) {
            return new AltosEepromFile(fileInputStream);
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new IOException(String.format("%s (Missing extension)", file.toString()));
        }
        String string2 = string.substring(n);
        throw new IOException(String.format("%s (Invalid extension '%s')", file.toString(), string2));
    }

    private static class Product {
        final String name;
        final int product;

        Product(String string, int n) {
            this.name = string;
            this.product = n;
        }
    }
}

