/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFlightSeries;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGPSTimeValue;
import org.altusmetrum.altoslib_14.AltosTimeValue;

public class AltosFlightStats {
    public double max_height;
    public double max_gps_height;
    public double max_speed;
    public double max_acceleration;
    public double[] state_speed = new double[10];
    public double[] state_enter_speed = new double[10];
    public double[] state_enter_height = new double[10];
    public double[] state_enter_gps_height = new double[10];
    public double[] state_accel = new double[10];
    public double[] state_time = new double[10];
    public String product;
    public String firmware_version;
    public int serial;
    public int flight;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public double boost_time;
    public double landed_time;
    public double lat;
    public double lon;
    public double pad_lat;
    public double pad_lon;
    public boolean has_flight_data;
    public boolean has_gps;
    public boolean has_gps_sats;
    public boolean has_gps_detail;
    public boolean has_flight_adc;
    public boolean has_battery;
    public boolean has_rssi;
    public boolean has_imu;
    public boolean has_mag;
    public boolean has_orient;
    public int num_igniter;
    AltosTimeValue[] speeds = new AltosTimeValue[10];
    AltosTimeValue[] accels = new AltosTimeValue[10];

    double landed_time(AltosFlightSeries altosFlightSeries) {
        double d = 2.147483647E9;
        double d2 = 2.147483647E9;
        if (altosFlightSeries.state_series != null) {
            for (AltosTimeValue altosTimeValue : altosFlightSeries.state_series) {
                if (altosTimeValue.value == 8.0) {
                    d = altosTimeValue.time;
                    break;
                }
                d2 = altosTimeValue.time;
            }
        }
        if (d == 2.147483647E9 && altosFlightSeries.height_series != null) {
            d = altosFlightSeries.height_series.get((int)(altosFlightSeries.height_series.size() - 1)).time;
        }
        double d3 = 2.147483647E9;
        if (altosFlightSeries.height_series != null) {
            for (AltosTimeValue altosTimeValue : altosFlightSeries.height_series) {
                d3 = altosTimeValue.value;
                if (!(altosTimeValue.time >= d)) continue;
                break;
            }
        }
        if (d3 == 2.147483647E9) {
            return 2.147483647E9;
        }
        boolean bl = true;
        double d4 = 2.147483647E9;
        if (altosFlightSeries.height_series != null) {
            for (AltosTimeValue altosTimeValue : altosFlightSeries.height_series) {
                if (altosTimeValue.value > d3 + 10.0) {
                    bl = true;
                    continue;
                }
                if (!bl || !(Math.abs(altosTimeValue.value - d3) < 2.0)) continue;
                bl = false;
                d4 = altosTimeValue.time;
            }
        }
        if (d4 == 2.147483647E9 || d2 != 2.147483647E9 && d4 < d2) {
            d4 = d;
        }
        return d4;
    }

    double boost_time(AltosFlightSeries altosFlightSeries) {
        double d = 2.147483647E9;
        double d2 = 2.147483647E9;
        if (altosFlightSeries.state_series != null) {
            for (AltosTimeValue altosTimeValue : altosFlightSeries.state_series) {
                if (!(altosTimeValue.value >= 3.0) || !(altosTimeValue.value <= 8.0)) continue;
                d2 = altosTimeValue.time;
                break;
            }
        }
        if (altosFlightSeries.accel_series != null) {
            for (AltosTimeValue altosTimeValue : altosFlightSeries.accel_series) {
                if (altosTimeValue.value < 1.0) {
                    d = altosTimeValue.time;
                }
                if (d2 == 2.147483647E9 || !(altosTimeValue.time >= d2)) continue;
                break;
            }
        }
        if (d == 2.147483647E9) {
            d = d2;
        }
        return d;
    }

    private void add_times(AltosFlightSeries altosFlightSeries, int n, double d, double d2) {
        double d3 = d2 - d;
        if (0 <= n && n <= 9 && d3 > 0.0) {
            if (this.state_enter_speed[n] == 2.147483647E9) {
                this.state_enter_speed[n] = altosFlightSeries.speed_series.value(d);
            }
            if (this.state_enter_height[n] == 2.147483647E9) {
                this.state_enter_height[n] = altosFlightSeries.height_series.value(d);
            }
            if (this.state_enter_gps_height[n] == 2.147483647E9 && altosFlightSeries.gps_height != null) {
                this.state_enter_gps_height[n] = altosFlightSeries.gps_height.value(d);
            }
            this.speeds[n].value += altosFlightSeries.speed_series.average(d, d2) * d3;
            this.speeds[n].time += d3;
            this.accels[n].value += altosFlightSeries.accel_series.average(d, d2) * d3;
            this.accels[n].time += d3;
            int n2 = n;
            this.state_time[n2] = this.state_time[n2] + d3;
            if (n == 3) {
                AltosTimeValue altosTimeValue;
                AltosTimeValue altosTimeValue2 = altosFlightSeries.speed_series.max(d, d2);
                if (altosTimeValue2 != null && (this.max_speed == 2.147483647E9 || altosTimeValue2.value > this.max_speed)) {
                    this.max_speed = altosTimeValue2.value;
                }
                if ((altosTimeValue = altosFlightSeries.accel_series.max(d, d2)) != null && (this.max_acceleration == 2.147483647E9 || altosTimeValue.value > this.max_acceleration)) {
                    this.max_acceleration = altosTimeValue.value;
                }
            }
        }
    }

    public AltosFlightStats(AltosFlightSeries altosFlightSeries) {
        AltosTimeValue altosTimeValue;
        int n;
        AltosCalData altosCalData = altosFlightSeries.cal_data();
        altosFlightSeries.finish();
        this.boost_time = this.boost_time(altosFlightSeries);
        this.landed_time = this.landed_time(altosFlightSeries);
        if (altosFlightSeries.state_series != null) {
            n = 0;
            boolean bl = false;
            for (AltosTimeValue altosTimeValue2 : altosFlightSeries.state_series) {
                if ((int)altosTimeValue2.value == 3 && this.boost_time != 2.147483647E9 && n == 0) {
                    altosTimeValue2.time = this.boost_time;
                    n = 1;
                }
                if ((int)altosTimeValue2.value != 8 || this.landed_time == 2.147483647E9 || bl) continue;
                altosTimeValue2.time = this.landed_time;
                bl = true;
            }
        }
        this.day = Integer.MAX_VALUE;
        this.month = Integer.MAX_VALUE;
        this.year = Integer.MAX_VALUE;
        this.second = Integer.MAX_VALUE;
        this.minute = Integer.MAX_VALUE;
        this.hour = Integer.MAX_VALUE;
        this.flight = Integer.MAX_VALUE;
        this.serial = Integer.MAX_VALUE;
        this.lon = 2.147483647E9;
        this.lat = 2.147483647E9;
        this.has_flight_data = false;
        this.has_gps = false;
        this.has_gps_sats = false;
        this.has_flight_adc = false;
        this.has_battery = false;
        this.has_rssi = false;
        this.has_imu = false;
        this.has_mag = false;
        this.has_orient = false;
        for (n = 0; n < 10; ++n) {
            this.state_speed[n] = 2.147483647E9;
            this.state_enter_speed[n] = 2.147483647E9;
            this.state_accel[n] = 2.147483647E9;
            this.state_time[n] = 0.0;
            this.speeds[n] = new AltosTimeValue(0.0, 0.0);
            this.accels[n] = new AltosTimeValue(0.0, 0.0);
        }
        this.max_speed = 2.147483647E9;
        this.max_acceleration = 2.147483647E9;
        if (altosFlightSeries.state_series != null) {
            AltosTimeValue object = null;
            Object object2 = altosFlightSeries.state_series.iterator();
            while (object2.hasNext()) {
                AltosTimeValue altosTimeValue3 = object2.next();
                if (object != null) {
                    this.add_times(altosFlightSeries, (int)object.value, object.time, altosTimeValue3.time);
                }
                object = altosTimeValue3;
            }
            if (object != null && (object2 = altosFlightSeries.accel_series.last()) != null) {
                this.add_times(altosFlightSeries, (int)object.value, object.time, ((AltosTimeValue)object2).time);
            }
        }
        for (int i = 0; i <= 9; ++i) {
            if (this.speeds[i].time > 0.0) {
                this.state_speed[i] = this.speeds[i].value / this.speeds[i].time;
            }
            if (!(this.accels[i].time > 0.0)) continue;
            this.state_accel[i] = this.accels[i].value / this.accels[i].time;
        }
        this.product = altosCalData.product;
        this.firmware_version = altosCalData.firmware_version;
        this.serial = altosCalData.serial;
        this.flight = altosCalData.flight;
        this.has_battery = altosFlightSeries.battery_voltage_series != null;
        this.has_flight_adc = altosFlightSeries.main_voltage_series != null;
        this.has_rssi = altosFlightSeries.rssi_series != null;
        this.has_flight_data = altosFlightSeries.pressure_series != null;
        AltosGPS altosGPS = altosFlightSeries.cal_data().gps_pad;
        if (altosGPS != null) {
            this.year = altosGPS.year;
            this.month = altosGPS.month;
            this.day = altosGPS.day;
            this.hour = altosGPS.hour;
            this.minute = altosGPS.minute;
            this.second = altosGPS.second;
            this.has_gps = true;
            this.lat = this.pad_lat = altosGPS.lat;
            this.lon = this.pad_lon = altosGPS.lon;
            if (altosFlightSeries.gps_series != null) {
                for (AltosGPSTimeValue altosGPSTimeValue : altosFlightSeries.gps_series) {
                    altosGPS = altosGPSTimeValue.gps;
                    if (!altosGPS.locked || altosGPS.nsat < 4) continue;
                    this.lat = altosGPS.lat;
                    this.lon = altosGPS.lon;
                }
            }
        }
        this.max_height = altosFlightSeries.max_height;
        if (this.max_height == 2.147483647E9 && altosFlightSeries.height_series != null) {
            this.max_height = altosFlightSeries.height_series.max().value;
        }
        this.max_gps_height = 2.147483647E9;
        if (altosFlightSeries.gps_height != null && (altosTimeValue = altosFlightSeries.gps_height.max()) != null) {
            this.max_gps_height = altosTimeValue.value;
        }
    }
}

