/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosPresTemp;

public class AltosEepromRecordMega
extends AltosEepromRecord {
    public static final int record_length = 32;
    public static final int max_sat = 12;
    private int log_format;

    private int flight() {
        return this.data16(0);
    }

    private int ground_accel() {
        return this.data16(2);
    }

    private int ground_pres() {
        return this.data32(4);
    }

    private int ground_accel_along() {
        return this.data16(8);
    }

    private int ground_accel_across() {
        return this.data16(10);
    }

    private int ground_accel_through() {
        return this.data16(12);
    }

    private int ground_roll() {
        switch (this.log_format) {
            case 10: 
            case 15: 
            case 16: 
            case 19: {
                return this.data32(16);
            }
            case 5: {
                return this.data16(14);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int ground_pitch() {
        switch (this.log_format) {
            case 10: 
            case 15: 
            case 16: 
            case 19: {
                return this.data32(20);
            }
            case 5: {
                return this.data16(16);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int ground_yaw() {
        switch (this.log_format) {
            case 10: 
            case 15: 
            case 16: 
            case 19: {
                return this.data32(24);
            }
            case 5: {
                return this.data16(18);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int state() {
        return this.data16(0);
    }

    private int reason() {
        return this.data16(2);
    }

    private int pres() {
        return this.data32(0);
    }

    private int temp() {
        return this.data32(4);
    }

    private int accel_x() {
        return this.data16(8);
    }

    private int accel_y() {
        return this.data16(10);
    }

    private int accel_z() {
        return this.data16(12);
    }

    private int gyro_x() {
        return this.data16(14);
    }

    private int gyro_y() {
        return this.data16(16);
    }

    private int gyro_z() {
        return this.data16(18);
    }

    private int mag_x() {
        return this.data16(20);
    }

    private int mag_z() {
        return this.data16(22);
    }

    private int mag_y() {
        return this.data16(24);
    }

    private int imu_type() {
        switch (this.log_format) {
            case 5: 
            case 10: {
                return 0;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 4;
            }
            case 19: {
                return 2;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int accel_across() {
        switch (this.log_format) {
            case 5: 
            case 10: 
            case 15: {
                return this.accel_x();
            }
            case 16: 
            case 19: {
                return -this.accel_y();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int accel_along() {
        switch (this.log_format) {
            case 5: 
            case 10: 
            case 15: {
                return this.accel_y();
            }
            case 16: 
            case 19: {
                return this.accel_x();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int accel_through() {
        return this.accel_z();
    }

    private int gyro_pitch() {
        switch (this.log_format) {
            case 5: 
            case 10: 
            case 15: {
                return this.gyro_x();
            }
            case 16: {
                return -this.gyro_y();
            }
            case 19: {
                return -this.gyro_y();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int gyro_roll() {
        switch (this.log_format) {
            case 5: 
            case 10: 
            case 15: {
                return this.gyro_y();
            }
            case 16: 
            case 19: {
                return this.gyro_x();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int gyro_yaw() {
        return this.gyro_z();
    }

    private int mag_across() {
        switch (this.log_format) {
            case 5: 
            case 10: 
            case 15: {
                return this.mag_x();
            }
            case 16: {
                return -this.mag_y();
            }
            case 19: {
                return this.mag_y();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int mag_along() {
        switch (this.log_format) {
            case 5: 
            case 10: 
            case 15: {
                return this.mag_y();
            }
            case 16: 
            case 19: {
                return this.mag_x();
            }
        }
        return Integer.MAX_VALUE;
    }

    private int mag_through() {
        return this.mag_z();
    }

    private int accel() {
        return this.data16(26);
    }

    private int v_batt() {
        return this.data16(0);
    }

    private int v_pbatt() {
        return this.data16(2);
    }

    private int nsense() {
        return this.data16(4);
    }

    private int sense(int n) {
        return this.data16(6 + n * 2);
    }

    private int pyro() {
        return this.data16(26);
    }

    private int latitude() {
        return this.data32(0);
    }

    private int longitude() {
        return this.data32(4);
    }

    private int altitude_low() {
        return this.data16(8);
    }

    private int hour() {
        return this.data8(10);
    }

    private int minute() {
        return this.data8(11);
    }

    private int second() {
        return this.data8(12);
    }

    private int flags() {
        return this.data8(13);
    }

    private int year() {
        return this.data8(14);
    }

    private int month() {
        return this.data8(15);
    }

    private int day() {
        return this.data8(16);
    }

    private int course() {
        return this.data8(17);
    }

    private int ground_speed() {
        return this.data16(18);
    }

    private int climb_rate() {
        return this.data16(20);
    }

    private int pdop() {
        return this.data8(22);
    }

    private int hdop() {
        return this.data8(23);
    }

    private int vdop() {
        return this.data8(24);
    }

    private int mode() {
        return this.data8(25);
    }

    private int altitude_high() {
        return this.data16(26);
    }

    private int nsat() {
        return this.data16(0);
    }

    private int svid(int n) {
        return this.data8(2 + n * 2);
    }

    private int c_n(int n) {
        return this.data8(2 + n * 2 + 1);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        super.provide_data(altosDataListener, altosCalData);
        altosCalData.set_imu_type(this.imu_type());
        switch (this.cmd()) {
            case 70: {
                altosCalData.set_flight(this.flight());
                altosCalData.set_ground_accel(this.ground_accel());
                altosCalData.set_ground_pressure(this.ground_pres());
                altosDataListener.set_accel_ground(altosCalData.accel_along(this.ground_accel_along()), altosCalData.accel_across(this.ground_accel_across()), altosCalData.accel_through(this.ground_accel_through()));
                altosCalData.set_gyro_zero((double)this.ground_roll() / 512.0, (double)this.ground_pitch() / 512.0, (double)this.ground_yaw() / 512.0);
                break;
            }
            case 83: {
                altosDataListener.set_state(this.state());
                break;
            }
            case 65: {
                AltosConfigData altosConfigData = this.eeprom.config_data();
                AltosPresTemp altosPresTemp = altosConfigData.ms5607().pres_temp(this.pres(), this.temp());
                altosDataListener.set_pressure(altosPresTemp.pres);
                altosDataListener.set_temperature(altosPresTemp.temp);
                int n = this.accel_along();
                int n2 = this.accel_across();
                int n3 = this.accel_through();
                int n4 = this.gyro_roll();
                int n5 = this.gyro_pitch();
                int n6 = this.gyro_yaw();
                int n7 = this.mag_along();
                int n8 = this.mag_across();
                int n9 = this.mag_through();
                if (this.log_format == 5) {
                    altosCalData.check_imu_wrap(n4, n5, n6);
                }
                altosDataListener.set_accel(altosCalData.accel_along(n), altosCalData.accel_across(n2), altosCalData.accel_through(n3));
                altosDataListener.set_gyro(altosCalData.gyro_roll(n4), altosCalData.gyro_pitch(n5), altosCalData.gyro_yaw(n6));
                altosDataListener.set_mag(altosCalData.mag_along(n7), altosCalData.mag_across(n8), altosCalData.mag_through(n9));
                altosDataListener.set_acceleration(altosCalData.acceleration(this.accel()));
                break;
            }
            case 84: {
                altosDataListener.set_battery_voltage(AltosConvert.mega_battery_voltage(this.v_batt()));
                altosDataListener.set_pyro_voltage(AltosConvert.mega_pyro_voltage(this.v_pbatt()));
                int n = this.nsense();
                altosDataListener.set_apogee_voltage(AltosConvert.mega_pyro_voltage(this.sense(n - 2)));
                altosDataListener.set_main_voltage(AltosConvert.mega_pyro_voltage(this.sense(n - 1)));
                double[] dArray = new double[n - 2];
                for (int i = 0; i < n - 2; ++i) {
                    dArray[i] = AltosConvert.mega_pyro_voltage(this.sense(i));
                }
                altosDataListener.set_igniter_voltage(dArray);
                altosDataListener.set_pyro_fired(this.pyro());
                break;
            }
            case 71: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
                altosGPS.lat = (double)this.latitude() / 1.0E7;
                altosGPS.lon = (double)this.longitude() / 1.0E7;
                altosGPS.alt = this.config_data().altitude_32() ? (double)(this.altitude_low() & 0xFFFF | this.altitude_high() << 16) : (double)this.altitude_low();
                altosGPS.hour = this.hour();
                altosGPS.minute = this.minute();
                altosGPS.second = this.second();
                int n = this.flags();
                altosGPS.connected = (n & 0x20) != 0;
                altosGPS.locked = (n & 0x10) != 0;
                altosGPS.nsat = (n & 0xF) >> 0;
                altosGPS.year = 2000 + this.year();
                altosGPS.month = this.month();
                altosGPS.day = this.day();
                altosGPS.ground_speed = (double)this.ground_speed() * 0.01;
                altosGPS.course = this.course() * 2;
                altosGPS.climb_rate = (double)this.climb_rate() * 0.01;
                if (this.config_data().compare_version("1.4.9") >= 0) {
                    altosGPS.pdop = (double)this.pdop() / 10.0;
                    altosGPS.hdop = (double)this.hdop() / 10.0;
                    altosGPS.vdop = (double)this.vdop() / 10.0;
                    break;
                }
                altosGPS.pdop = (double)this.pdop() / 100.0;
                if (altosGPS.pdop < 0.8) {
                    altosGPS.pdop += 2.56;
                }
                altosGPS.hdop = (double)this.hdop() / 100.0;
                if (altosGPS.hdop < 0.8) {
                    altosGPS.hdop += 2.56;
                }
                altosGPS.vdop = (double)this.vdop() / 100.0;
                if (!(altosGPS.vdop < 0.8)) break;
                altosGPS.vdop += 2.56;
                break;
            }
            case 86: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(true);
                int n = this.nsat();
                if (n > 12) {
                    n = 12;
                }
                for (int i = 0; i < n; ++i) {
                    altosGPS.add_sat(this.svid(i), this.c_n(i));
                }
                break;
            }
        }
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordMega(this.eeprom, n);
    }

    public AltosEepromRecordMega(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 32);
        this.log_format = altosEeprom.config_data().log_format;
    }

    public AltosEepromRecordMega(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

