/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosLib;

public abstract class AltosEepromRecord
implements Comparable<AltosEepromRecord> {
    AltosEeprom eeprom;
    int wide_tick;
    final int start;
    final int length;
    public static final int header_length = 4;

    public int cmd() {
        return this.eeprom.data8(this.start);
    }

    public int tick() {
        return this.eeprom.data16(this.start + 2);
    }

    public int data8(int n) {
        return this.eeprom.data8(n += this.start + 4);
    }

    public int data16(int n) {
        return (this.data8(n) | this.data8(n + 1) << 8) << 16 >> 16;
    }

    public int data24(int n) {
        return this.data8(n) | this.data8(n + 1) << 8 | this.data8(n + 2) << 16;
    }

    public int data32(int n) {
        return this.data8(n) | this.data8(n + 1) << 8 | this.data8(n + 2) << 16 | this.data8(n + 3) << 24;
    }

    public boolean empty(int n) {
        for (int i = 0; i < this.length; ++i) {
            if (this.eeprom.data8(n + i) == 255) continue;
            return false;
        }
        return true;
    }

    public boolean valid(int n) {
        int n2 = AltosConvert.checksum(this.eeprom.data, n, this.length);
        if (n2 != 0) {
            ++this.eeprom.errors;
            System.out.printf("invalid checksum 0x%x at 0x%x\n", n2, n);
            return false;
        }
        return true;
    }

    public boolean valid() {
        return this.valid(this.start);
    }

    private int cmdi() {
        if (this.cmd() == 70) {
            return 0;
        }
        return 1;
    }

    public AltosConfigData config_data() {
        return this.eeprom.config_data();
    }

    @Override
    public int compareTo(AltosEepromRecord altosEepromRecord) {
        int n = this.cmdi() - altosEepromRecord.cmdi();
        if (n != 0) {
            return n;
        }
        int n2 = this.wide_tick - altosEepromRecord.wide_tick;
        if (n2 != 0) {
            return n2;
        }
        return this.start - altosEepromRecord.start;
    }

    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        AltosGPS altosGPS;
        altosDataListener.set_tick(this.tick());
        if (this.cmd() == 70) {
            altosCalData.set_boost_tick();
        }
        altosDataListener.set_time(altosCalData.time());
        if (!AltosLib.is_gps_cmd(this.cmd()) && (altosGPS = altosDataListener.temp_gps()) != null) {
            altosDataListener.set_gps(altosGPS, true, true);
        }
    }

    public int next_start() {
        int n = this.start + this.length;
        while (n + this.length <= this.eeprom.data.size()) {
            if (!this.empty(n) && this.valid(n)) {
                return n;
            }
            n += this.length;
        }
        return -1;
    }

    public abstract AltosEepromRecord next();

    public AltosEepromRecord(AltosEeprom altosEeprom, int n, int n2) {
        this.eeprom = altosEeprom;
        this.start = n;
        this.length = n2;
    }
}

